﻿/*
 *	Sub class that adds a check box in front of the tree item icon
 *
 *	Created by Erik Arvidsson (http://webfx.eae.net/contact.html#erik)
 *
 *	Disclaimer:	This is not any official WebFX component. It was created due to
 *				demand and is just a quick and dirty implementation. If you are
 *				interested in this functionality the contact us
 *				http://webfx.eae.net/contact.html
 *
 *	Notice that you'll need to add a css rule the sets the size of the input box.
 *	Something like this will do fairly good in both Moz and IE
 *	
 *	input.tree-check-box {
 *		width:		auto;
 *		margin:		0;
 *		padding:	0;
 *		height:		14px;
 *		vertical-align:	middle;
 *	}
 *
 */

function WebFXCheckBoxTreeItem(sText, sAction, bChecked, eParent, sIcon, sOpenIcon, sData, sContent) {
	this.base = WebFXTreeItem;
	this.base(sText, sAction, eParent, sIcon, sOpenIcon, sData);
	
	this.csContent = sContent ||"";
	this._checked = bChecked;
	if( bChecked)
	{
	    this.base.reserve = 1;
	}
}

WebFXCheckBoxTreeItem.prototype = new WebFXTreeItem;

/*设置*/
var WebFXCheckBoxTree={};
WebFXCheckBoxTree.Settings={
    "isRelatedParent":true,//点击的时候是否关联父系checkbox
    "isRelatedChild":true,//点击的时候是否关联子的checkbox
    "ignoreDisabled":false//忽略被禁用的，依然设置是否被选中
};

WebFXCheckBoxTreeItem.prototype.toString = function (nItem, nItemCount) {
	var foo = this.parentNode;
	var indent = '';
	if (nItem + 1 == nItemCount) { this.parentNode._last = true; }
	var i = 0;
	while (foo.parentNode) {
		foo = foo.parentNode;
		indent = "<img src=\"" + ((foo._last)?webFXTreeConfig.blankIcon:webFXTreeConfig.iIcon) + "\">" + indent;
		i++;
	}
	this._level = i;
	if (this.childNodes.length) { this.folder = 1; }
	else { this.open = false; }
	if ((this.folder) || (webFXTreeHandler.behavior != 'classic')) {
		if (!this.icon) { this.icon = webFXTreeConfig.folderIcon; }
		if (!this.openIcon) { this.openIcon = webFXTreeConfig.openFolderIcon; }
	}
	else if (!this.icon) { this.icon = webFXTreeConfig.fileIcon; }
	var label = this.text;//replace(/</g, '&lt;').replace(/>/g, '&gt;');
	var str = "<div id=\"" + this.id + "\" ondblclick=\"webFXTreeHandler.toggle(this);\" class=\"webfx-tree-item\" onkeydown=\"return webFXTreeHandler.keydown(this, event)\">";
	str += indent;
	str += "<img id=\"" + this.id + "-plus\" src=\"" + ((this.folder)?((this.open)?((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon):((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon)):((this.parentNode._last)?webFXTreeConfig.lIcon:webFXTreeConfig.tIcon)) + "\" onclick=\"webFXTreeHandler.toggle(this);\">"
	
	// insert check box
	str += "<input type=\"checkbox\"" +
		" class=\"tree-check-box\"" +
		" id=\""+ this.id +"-checkbox\"" +
		" value=\""+ this.data +"\"" +
		(this._checked ? " checked=\"checked\"" : "") +
		" onclick=\"webFXTreeHandler.setChecked(this.checked,"+ this.id +",this )\"" +
		" />";
	// end insert checkbox
	
	str += "<img id=\"" + this.id + "-icon\" class=\"webfx-tree-icon\" src=\"" + ((webFXTreeHandler.behavior == 'classic' && this.open)?this.openIcon:this.icon) + "\" onclick=\"webFXTreeHandler.select(this);\"><a href=\"" + this.action + "\" id=\"" + this.id + "-anchor\" onfocus=\"webFXTreeHandler.focus(this);\" onblur=\"webFXTreeHandler.blur(this);\">" + label + "</a><span id=\""+this.id+"-csCont\">"+this.csContent+"</span></div>";
	str += "<div id=\"" + this.id + "-cont\" class=\"webfx-tree-container cont_" + this.id + "\" style=\"display: " + ((this.open)?'block':'none') + ";\">";
	//修改了class的值，为了可以在样式里修改表现，因为CSS类名不能用数字开头
	var sb = [];
	for (var i = 0; i < this.childNodes.length; i++) {
		sb.push(this.childNodes[i].toString(i,this.childNodes.length));
	}
	//str += "</div>";
	this.plusIcon = ((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon);
	this.minusIcon = ((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon);
	return str + sb.join("") + "</div>";
}

WebFXCheckBoxTreeItem.prototype.getChecked = function () {
	var divEl = document.getElementById(this.id);
	var inputEl = divEl.getElementsByTagName("INPUT")[0];
	return this._checked = inputEl.checked;
};

WebFXCheckBoxTreeItem.prototype.setChecked = function (bChecked) {
		var divEl = document.getElementById(this.id);
		//alert(this.id);
		var inputEl = divEl.getElementsByTagName("INPUT")[0];
		if(inputEl.disabled )
		    return;
		this._checked = inputEl.checked = bChecked;
		
		/*
		if (typeof this.onchange == "function")
			this.onchange();*/
};
//勾选执行的自定义函数
webFXTreeHandler.customFunctionForCheckBox=function(obj){return;};
//勾选执行的函数
webFXTreeHandler.setChecked=function(flag,id,obj)
{
    this.customFunctionForCheckBox(obj);
	//id为 id-cont 以及  id 的容器里的checkbox都要被选择
	var divEl = document.getElementById(id);
	if( divEl==null)
	    return;
	var inputs = divEl.getElementsByTagName("INPUT");
	if( inputs == null || inputs.length==0)
	    return;//有的场合input没有，比如当此节点是根节点的时，要全选的情况
	var inputEl = divEl.getElementsByTagName("INPUT")[0];
	inputEl.checked=flag;
	
	if(flag)
	    webFXTreeHandler.all[""+id].reserve = 1;
	else
	    webFXTreeHandler.all[""+id].reserve = 0;
	
	if(WebFXCheckBoxTree.Settings["isRelatedChild"])
	{
	    var checkboxes=document.getElementById(id+"-cont").getElementsByTagName("INPUT");
	    for(var i=0;i<checkboxes.length;i++)
	    {
	        if(checkboxes[i].disabled && WebFXCheckBoxTree.Settings["ignoreDisabled"]==false)
	        {}
	        else
	        {
		        //checkboxes[i].checked=flag;
		        var _id = checkboxes[i].id.replace(/-checkbox/gi,"");
		        webFXTreeHandler.all[""+_id].setChecked(flag);
		    }
		}
	}
		
	if(flag && WebFXCheckBoxTree.Settings["isRelatedParent"])//要选择父系的类别
	{
		var temp = webFXTreeHandler.all[id] ;
		while(true)
		{
			//alert(temp.parentNode.id);
			if(temp.parentNode instanceof WebFXCheckBoxTreeItem)
				temp.parentNode.setChecked(true);
			else
				break;
			temp=temp.parentNode;
		}
	}
}

if( typeof webFXTreeHandler.setChecked != "function")
	webFXTreeHandler.setChecked=function(){};