﻿<%@ page language="C#" autoeventwireup="true" inherits="Nd.Webs.FrameWork.Web.Purview.UserGrant, App_Web_usergrant.aspx.ada6d92" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>用户可授权权限管理</title>
<link type="text/css" rel="Stylesheet" href="../Lib/Skin/<%=Style %>/style.css" />
<style type="text/css">
    .systemOpenLevel
    {
    	padding-left: 35px;
    	background: url(../Lib/Skin/tree/open.gif) no-repeat;
    	line-height: 18px;
    	vertical-align: middle;
    	cursor: pointer;
    }
    .systemCloseLevel
    {
    	padding-left: 35px;
    	background: url(../Lib/Skin/tree/close.gif) no-repeat;
    	line-height: 18px;
    	vertical-align: middle;
    	cursor: pointer;
    }
    .menuLevel
    {
    	margin-left: 20px;
    	padding-left: 18px;
    	background:url(../Lib/Skin/tree/file.gif) no-repeat;
    }
     .TableList ul
     {
     	margin:0; padding:0;
     }
    .TableList ul li
    {
    	margin: 2px 0px 2px 25px;
    }
</style>
<script type="text/javascript" src="../Lib/Js/Utility.js"></script>
<script type="text/javascript" src="../Lib/Js/CellColorChange.js"></script>
<script type="text/javascript" src="../Lib/Js/autosuggest.js"></script>
<script type="text/javascript" src="../Lib/Js/DateFormat.js"></script>

<script type="text/javascript" src="../lib/BubbleTooltips/Positionfunctions.js"></script>
<script type="text/javascript" src="../lib/js/xtreeNodeColor.js"></script>
<script type="text/javascript">
function f(id)
{
    return document.getElementById(id);
}
window.onresize= SetSize;
window.onload = SetSize;

function SetSize()
{
    var wh= getDocumentRect();
    var promptHeight = document.getElementById("prompt").offsetHeight + 2;
    f("tbList").style.height=(wh.height-15 - promptHeight) + "px";
    f("grantList").style.height=(wh.height -15- promptHeight) + "px";
}
</script>
<script type="text/javascript">
    var UserID;
    var UserName;
    //搜索用户的可授权权限项
    function SearchGrant()
    {
        var userID = document.getElementById("UserNameID").value;
        if(userID.length == 0)
        {
//            document.getElementById("UserName").focus();
//            document.getElementById("UserName").select();
            return;
        }
        
        this.UserID = userID;
        this.UserName = document.getElementById("UserName").value;
        Utility.Ajax.Request({
            param: {UserID: userID},
            url: "Handler/UserGrant.ashx?Action=Search",
            success: SearchGrantHandle
        });

        //document.getElementById("searchBtn").disabled=false;
    }
    function SearchGrantHandle(result)
    {
        document.getElementById("grantList").innerHTML = result.responseText;
    }
    
    //设置搜索默认按钮
    function SetDefaultBtn(evt, btnID)
    {
        if(evt.keyCode==13)
        {
            var btn = document.getElementById(btnID);
            if(btn)
            {
//                btn.focus();
//                btn.onclick();
                SearchGrant();
            }
        }
    }
    
    //改变折叠状态
    function ChangePucker(parentCode)
    {
        var child = document.getElementById("parent_" + parentCode);
        if(child)
        {
            if(child.style.display == "none")
            {
                document.getElementById("menu_" + parentCode).firstChild.className = "systemOpenLevel";
                child.style.display = "block";
            }
            else
            {
                document.getElementById("menu_" + parentCode).firstChild.className = "systemCloseLevel";
                child.style.display = "none";
            }
        }
    }
    
    //改变权限授权状态
    function ChangeGrant(el)
    {
        var custom = el.getAttribute("Custom");
        var inherit = el.getAttribute("Inherit");
        var menuCode = el.getAttribute("MenuCode");
        var check = el.checked;
        var msg = "{0}<span style=\"color: "+color.red+"\">" + UserName + "</span>的<b style=\"color: "+color.red+"\">" + el.nextSibling.innerHTML + "</b>自定义的<span style=\"color: "+color.red+"\">{1}</span>";
        el.disabled = true;
        Utility.Ajax.Request({
            param: {UserID: UserID, MenuCode: menuCode},
            url: "Handler/UserGrant.ashx?Action=ChangeUserGrant",
            success: ChangeUserGrantHandle
            });
            
        function ChangeUserGrantHandle(result)
        {
            result = result.responseText.split("$");
            var newCustom = result[1];
            var newInherit = result[2];
            var eventHander;
            var eventType;
            var newChecked = false;
            var newColor = "black";
            
            switch(newCustom)
            {
                case "0":
                    //用户自定义不可授权权限
                    eventHander = "添加";
                    eventType = "不可授权权限";
                    newChecked = false;
                    newColor = color.red;//"#F43EF8";
                    break;
                case "1":
                    //用户自定义可授权权限
                    eventHander = "添加";
                    eventType = "可授权权限";
                    newChecked = true;
                    newColor =color.red;// "#F43EF8";
                    break;
                case "9":
                    //用户无自定义授权权限
                    eventHander = "取消";
                    eventType = custom == "1" ? "可授权权限" : custom == "0" ? "不可授权权限" : "授权权限";
                    //用户无自定义授权权限
                    if(newInherit == "1")
                    {
                        //用户继承的可授权权限
                        newChecked = true;
                        newColor = color.blue;//"#0086E3";
                    }
                    else
                    {
                        newChecked = false;
                        newColor = "black";
                    }
                    break;
            }
            
            msg = msg.replace("{0}", eventHander).replace("{1}", eventType);
            switch(result[0])
            {
                default:
                    msg = "<b style=\"color: red\">" + result[0] + "</b>";
                    el.checked = !check;
                    break;
                case "0":
                    //失败
                    msg += " <b style=\"color: red\">失败!!!</b>";
                    el.checked = !check;
                    break;
                case "1":
                    //成功
                    el.setAttribute("Custom", newCustom);
                    el.setAttribute("Inherit", newInherit);
                    el.checked = newChecked;
                    el.nextSibling.style.color = newColor;
                    msg += " <span style=\"color: green\">成功...</span>";
                    break;
            }
            msg += "<span style=\"color: #606066\">(" + new Date().Format("yyyy-MM-dd HH:mm:ss") + ")</span>";
            AddHanderMsg(msg);
            el.disabled = false;
        }
    }
    
    //增加一条信息
    function AddHanderMsg(msg)
    {
        var item = document.createElement("div");
        item.style.marginTop = "5px";
        item.innerHTML = msg;
        document.getElementById("handlerMsg").insertBefore(item, document.getElementById("handlerMsg").firstChild);
    }
</script>
</head>
<body>
<%@ Register Src="~/Common/UserControl/PurviewSettingTip.ascx" TagName="Tip" TagPrefix="EA" %>
<EA:Tip ID="Tip1" runat="server" Text="设置某一特定人员的可授权的范围，精确到子系统下的一级菜单，若勾选，表示该人员可对该子系统下所有的菜单/功能进行授权，如果某一人员及其所在的组同时拥有某一权限，则仅计算人员特定的权限。"></EA:Tip>
    <table id="tbList" class="TableList" style="width: 100%; border:1px solid #fff;">
        <!--<thead>
            <tr><th colspan="2">用户可授权权限管理</th></tr>
        </thead>-->
        <tbody>
            <tr>
                <td style="width: 250px;" valign="top">
                    <div id="user">
                        账号/姓名：<input id="UserName" type="text" class="tinput" style="width: 120px;" onkeydown="SetDefaultBtn(event, 'searchBtn')" />
                        <input id="UserNameID" type="hidden" />
                        <input id="searchBtn" type="button" value="搜索" class="btn" onclick="SearchGrant()" />
                        <br />
                        <br />
                    </div>
                    <div id="memo">
                        <b>菜单字体颜色说明：</b>
                        <ul style="border-bottom: dotted 1px #606066;">
                            <li style="color: #F43EF8">用户自定义的授权权限</li>
                            <li style="color: #0086E3">用户从其所在角色组中继承的授权权限</li>
                            <li style="color: Black">用户未拥有自定义及从角色组继承的授权权限</li>
                        </ul>
                    </div>
                    <div id="handlerMsg" style="height: 100%; overflow: auto"></div>
                </td>
                <td id="grantList" style="height:100%; vertical-align: top"></td>
            </tr>
        </tbody>
    </table>
    <script type="text/javascript">
        //var obj = new actb({ id: "UserName", url: "../Handler/HRDataLib.ashx?action=SearchUser&userName=", buttonID: "searchBtn", selected: false });
        var obj = new actb({ id: "UserName", url: "../Handler/HRDataLib.ashx?action=SearchUser&userName=", buttonID: "", selected: false });
    </script>
</body>
</html>
