if(typeof SubsSortable == 'undefined')
  throw("jscontrolstags-swap.js requires including subsdraggable.js library");
  
if(!JSControlsTags) var JSControlsTags = {};
JSControlsTags.Swap =  Class.create();
JSControlsTags.Swap.prototype = Object.extend({

  initialize: function (source, items, styleClassList, targets, options) {
    // Div source
    this.source = $(source);
    // HTML Select  
    this.items = $(items);
    this.setOptions(options);
    
    var ulId = this._getUlId(this.source);
	
	// Create UL and attach it to the DIV source
    var ul = document.createElement("ul");
    ul.id = ulId;
    this.ul = ul;
    this.source.appendChild(ul);

    // loop for swap targets, to add accept class 
    var acceptClass = new Array();
    for (var i=0; i<targets.length; i++) {
    	var swapTarget = targets[i];
    	var sourceTarget = $(swapTarget.source);
    	if (sourceTarget != null) {
    		// Add className to accept
    		acceptClass.push("JSControlsTags.Swap." + sourceTarget.id  + "_selectedItems");
    		// 
    		var swapAction = swapTarget.swapAction;
    		if (swapAction != null) {
    			swapAction = $(swapAction);
    			Event.observe(swapAction, 'click', this._swapList1ToList2.bind(this, sourceTarget));
    		}
    	}
    }
    Element.addClassName(ul, styleClassList);

    // Create selectable list for the list
    this.selectableList = 
      new Control.SelectableList(ul.id, 'item', 
      {itemTag:'li', 
       arrowNav:true, 
       unSelectNewItemsAfterInsertion:false, 
       htmlSelect:items,
       onFocus:this._onSelectableListFocus.bind(this)});
       
    // Create selectable list for the list   
    SubsSortable.create(ul.id,
           {constraint: false, 
            accept: acceptClass, 
            hoverclass: 'hoverclass', 
            revert:true, 
            isSelected: this._isSelected.bind(this), 
            selectOneItem: this._selectOneItem.bind(this),
            getSelectedItems: this._getSelectedItems.bind(this),
            onFinishDrop: this._swap.bind(this)}); 
            
     // Bind HTML element (Button, href) with selection (All/None) 
     this._attachBehaviour(this.options);
     
     // Create an HREF to set focus
     this.href = document.createElement('a');
     this.href.href = "#";
     this.href.innerHTML = "";
     this.source.parentNode.appendChild(this.href);

     if (this.options.dragDropEnabled != null) 
     	this.setDragDropEnabled(this.options.dragDropEnabled);
     if (this.options.enabled != null) 
     	this.setEnabled(this.options.enabled);
     if(this.options.onSwapComplete == null)
     	this.options.onSwapComplete = this._onSwapComplete;

  },
  
  setOptions: function(options) {
    this.options = Object.extend({ 
		selectAllListAction : options.selectAllListAction ? options.selectAllListAction:  null,
		selectNoneListAction : options.selectNoneListAction ? options.selectNoneListAction:  null,
		enabled : options.enabled ? options.enabled	: null,
		dragDropEnabled : options.dragDropEnabled ? options.dragDropEnabled	: true,
		onSwapComplete : options.onSwapComplete ? options.onSwapComplete : null
    }, options || {});  
  },
  
  setEnabled: function(enabled) {
  	// Enable/Disable Drag/Drop
  	if (this.options.dragDropEnabled == true) {
	  	this.setDragDropEnabled(enabled);
  	}
	else {		
		this.setDragDropEnabled(false);
	}
	this.setAcceptDrop(enabled);
  	// Enable/Disable selectable list (click event,...)
  	if (enabled)
  		this.selectableList.setEnabled();
  	else {
  		this.selectableList.selectNone();
	  	this.selectableList.setDisabled();
  	}
  	if (this.options.onEnable) {
  		this.options.onEnable(enabled, this);
  	}
  },  
  
  setDragDropEnabled: function(enabled) {
	var options = SubsSortable.options(this.ul.id);
  	if (options) {
  		var draggables = options.draggables;
  		if (draggables) {
  			var subsDraggable = draggables[0];  			
  			subsDraggable.setEnabled(enabled);
  		}
  	}  	  	
  },
  
  setAcceptDrop: function(acceptDrop) {
	var options = SubsSortable.options(this.ul.id);
  	if (options) {
  		var draggables = options.draggables;
  		if (draggables) {
  			var subsDraggable = draggables[0];
  			subsDraggable.setAcceptDrop(acceptDrop);
  		}
  	}  	  	
  },  
  
  /* Private methods for the first list */
  
  _getUlId: function(source) {
  	if (source != null)
  		return "JSControlsTags.Swap." + source.id;
  	return null;
  },
  
  _isSelected:function(element) {
    return this.selectableList.isSelected(element);
  },
  
  _selectOneItem: function(element) {
      this.selectableList.selectNone();
      this.selectableList.selectItem(element);
  }, 
  
  _getSelectedItems: function() {
    return this.selectableList.getSelectedItems();
  },
  
   /* Attach behaviour (selection and swap) on click event */  
  _attachBehaviour : function(options) {
     if (options.selectAllListAction) {
     	var selectAllListAction = $(options.selectAllListAction);
     	Event.observe(selectAllListAction, 'click', this._selectAllList.bind(this));
     } 
     if (options.selectNoneListAction) {
     	var selectNoneListAction = $(options.selectNoneListAction);
     	Event.observe(selectNoneListAction, 'click', this._selectNoneList.bind(this));
     }                
  }, 
  
   /* Selection behaviour */    
  _selectAllList: function() {
  	if (!this.selectableList.disabled)
	  	this.selectableList.selectAll();
  },
  _selectNoneList: function() {
  	if (!this.selectableList.disabled)
	  	this.selectableList.selectNone();
  },
 
  /* Swap behaviour */     
  _swap: function(fromList, toList, items) {
      if (items && items.length > 0) {
        var stl1 = Control.SelectableList.selectable(fromList);
        var stl2 = Control.SelectableList.selectable(toList);
        if (!stl1.disabled && !stl2.disabled) {
        	stl2.insertItems(stl1.getSelectedItems());
        	stl1.removeItems(stl1.getSelectedItems());
        	if (this.options.onSwapComplete) 
        		this.options.onSwapComplete(stl1, stl2);        	
        }
      }
  },
     
  _swapList1ToList2 : function() {
  	var div = arguments[0];
	var fromList = div.childNodes[0];
	var stl = Control.SelectableList.selectable(fromList);
	var items = stl.getSelectedItems();
    var toList = this.selectableList.list_container;
    this._swap(fromList, toList, items);  
  },
  
  _onSelectableListFocus:function(e) {
  	Event.stop(e);
  	//this.href.focus();
  },
  
  _onSwapComplete: function(stl1, stl2) {
  	new Effect.Highlight(stl2.list_container, {});
  }
  
});
