// Copyright (c) 2006 Seth Hall <seth@remor.com>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy 
// of this software and associated documentation files (the "Software"), to deal 
// in the Software without restriction, including without limitation the rights 
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
// copies of the Software, and to permit persons to whom the Software is 
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE.
//
// http://www.remor.com/selectable-list/
//
// Example:
// sl = new Control.SelectableList('item_list', 'item', {keyNav:true})

if(!Control) var Control = {};
Control.SelectableList = Class.create();
Control.SelectableList._selectables = {};
Control.SelectableList.selectable = function(element) {
  return Control.SelectableList._selectables[element.id];
}

Control.SelectableList.prototype = {

  lastSelectedTable: {},
  
  initialize: function(container, item_name, options) {
    var list = this;
	
	this.container=container;//omeweb ޸2008-8-24 15 51,һԣ̬LIб
	
    this.options = Object.extend({
      itemTag: 'div',
      keyNav: true,
      jkNav: true,
      arrowNav: false,
      disabledClass: false,
      onChange: false,
      onReturn: false,
      onDelete: false,
      selectByPointer: false,
      pointerClass: 'pointer',
      pointer: false,
      selectMultiple: true,
      clickHandle: false,
      clickToClear: true,
      // Option for insert
      insertBefore: false,
      insertWithSortById: false,
      insertWithSortByInnerHTML: true,
      orderByDesc: true,
      unSelectAllAfterInsertion:false,
      unSelectNewItemsAfterInsertion:true, // unselect ONLY items which must be inserted
      // HTML select
      htmlSelect : null,
      onFocus : null
      //scroll: 'item_list'
    }, options || {});
    
    this.item_name = item_name;
    
    this.list_container = $(container);
    
    if (this.options.htmlSelect) {
      // HTML select is filled, loop for each options of select and generate li
      var htmlSelect = $(this.options.htmlSelect);
      var htmlSelectOptions = htmlSelect.options;
      for (var i=0; i< htmlSelectOptions.length; i++) {
        var htmlSelectOption = htmlSelectOptions[i];
        var id = htmlSelectOption.value;
        var innerHTML = htmlSelectOption.text;
        var item = document.createElement(this.options.itemTag);
        item.id = id;
        item.innerHTML = innerHTML;
        this.list_container.appendChild(item);
      }
      this.htmlSelect = htmlSelect;
      // Select all options of HTML select
      var options = this.htmlSelect.options;
      for (var i=0; i<options.length; i++) {
        options[i].selected = true;
      }
    }
      
    this.item_list = $A($(container).getElementsByTagName(this.options.itemTag));
    //this.box_num_reg = /(........-....-....-....-............)$/; // only create the regex once
    this.box_num_reg = /(\d+)$/; // only create the regex once
    this.lastPointed = this.item_list[0]; // start with the first item
    this.lastSelected = this.lastPointed;
    this._selectedItems = [];
    //if(this.options.scroll) {
    //  this.options.scroll = $(this.options.scroll);
    //  // fix AppleWebKit rendering
    //  if(navigator.appVersion.indexOf('AppleWebKit')>0) window.scrollBy(0,0);
    //}
    this.disabled = true;
    this.setEnabled();
    
    if (this.options.selectByPointer && !this.options.pointer) { 
      alert("SelectableList Error!  You need to supply a 'pointerClass' and a 'pointer' if you want to use selectByPointer.")
    }
    if (this.options.onChange && typeof this.options.onChange != 'function') {
      alert("SelectableList Error!  The onChange option needs to be a function.")
    }
    
    if (this.options.selectByPointer) { 
      this._pointer = document.createElement('SPAN');
      this._pointer.className = this.options.pointerClass;
      this._pointer.innerHTML = this.options.pointer;
      this.pointAt(this.item_list[0]) 
    }
    
    // keep reference
    Control.SelectableList._selectables[this.list_container.id] = this;        
  },
  
  updateList: function(){ this.item_list = $A($(this.container).getElementsByTagName(this.options.itemTag)); },//omeweb ޸2008-8-24 15 51
  
  addItem: function(){},
  
  itemClick: function(event) {	        	  	
    // store last selected table
    this.onFocus(event);    
    var box = Event.findElement(event, this.options.itemTag);
    if (box.tagName) {
      var select_clicked_item = true;
      if (event.shiftKey) {
        // selecting multiple items with the shift key
        var mark_them = false
        var hit_chosen = false
        var stop = false
        this.item_list.each( function(item){
          if ( (item == box && mark_them) ||
               (this.isSelected(item) && mark_them && hit_chosen) ) stop = true
          if(!stop) {
            if (mark_them) this.selectItem(item)
            if (this.isSelected(item) || 
                (item == box && !mark_them && this.countSelected() >0) ) { 
              mark_them = true //start marking boxes
            }
            if (item == box) hit_chosen = true
          }
        }.bind(this))
        
      } else if (event.altKey || event.ctrlKey ||
                 this.options.selectByPointer) {
        // alternating the selection status of the clicked item   
        this.flipItem(box)
        select_clicked_item = false
      } else {
        // clearing all items from the current selection
        this.clearSelections(event)
      }
      if (this.options.clickToClear && !event.ctrlKey && !event.shiftKey) {
        this.clearSelections(event)
      }
      if (select_clicked_item) { this.selectItem(box) }
      this.lastSelected = box;
      this._updateCallback();     
    }
    Event.stop(event) // to prevent event from bubbling to the list container  
  },
  
  clearSelections: function(event) {
    this.selectNone();
  },
    
  keyPress: function(e) {	 
    // Behaviour Key press must manage ONLY the last table clicked
    if (Control.SelectableList.lastSelectedTable ==  this.list_container) {
      // down, j, J
      if ((e.keyCode == Event.KEY_DOWN && this.options.arrowNav) ||
          ((e.charCode == 74 || e.charCode == 106 || e.keyCode == 74) 
            && this.options.jkNav) ) {
        if (this.options.selectByPointer) {
          this.movePointer(e, 1)
        } else {
          this.selectNext(e)
        }
        Event.stop(e)
      }
      // up, k, K
      if ((e.keyCode == Event.KEY_UP && this.options.arrowNav) || 
          ((e.charCode == 75 || e.charCode == 107 || e.keyCode == 75)
            && this.options.jkNav) ) {
        if (this.options.selectByPointer) {
          this.movePointer(e, -1)
        } else {
        
          this.selectPrev(e)
        }
        Event.stop(e)
      }
      // x, X
      if ((e.charCode == 120 || e.charCode == 88 || e.keyCode == 88) &&
          this.options.selectByPointer) {
        this.lastSelected = (this.lastPointed)
        this.flipItem(this.lastPointed)
        this._updateCallback()
        Event.stop(e)
      }
      if ((e.keyCode == Event.KEY_DELETE || e.keyCode == Event.KEY_BACKSPACE) && 
          typeof this.options.onDelete == 'function') {
        try {
          this.options.onDelete(this)
        } catch (e) {}
        Event.stop(e)
      }
      if (e.keyCode == Event.KEY_RETURN && 
          typeof this.options.onReturn == 'function') {
        try {
          this.options.onReturn(this)
        } catch (e) {}
        Event.stop(e)
      }
    }   
  },
  
  // where would be 1 to advance pointer by 1
  // where would be -1 to move pointer back by 1
  movePointer: function(event, where) {
    for(var i=0; this.item_list[i]; i++) {
      if (this.lastPointed == this.item_list[i] &&
          i != this.item_list.length-where &&
          !(i == 0 && where == -1) ) {
        this.pointAt(this.item_list[i+where])
        break
      }
    }
  },
  
  pointAt: function(item) {
    var item = $(item);
    var pointer = document.getElementsByClassName(this.options.pointerClass,
                                                  item)[0];
    var last_pointer = document.getElementsByClassName(this.options.pointerClass,
                                                       this.lastPointed)[0];
    if (this.options.clickHandle) {
      item.handle.insertBefore(this._pointer, item.handle.firstChild)
    } else {
      item.insertBefore(this._pointer, item.firstChild)
    }
    this.lastPointed = item;
  },
  
  isPointingAt: function() {
    return this._getItemNumber(this.lastPointed)
  },
  
  selectNext: function(event) {
    var found=false;

    // If nothing is selected, start at the top.
    if (this.countSelected() == 0 &&
        this.lastSelected == this.item_list[0]) {
                
      this.selectItem(this.lastPointed);
    } else {
      if (!Element.visible(this.lastSelected)) {
        this.clearSelections(event);
      }
     
      for(var i=0; this.item_list[i]; i++) {
        if(!found) {
          if(this.lastSelected == this.item_list[i]) {
            found=true;
          }
        } else {
          if(Element.visible(this.item_list[i])) {
            if (!event.shiftKey) {
              this.clearSelections(event);
            }
            else {
                // Shift key
                if (this.isSelected(this.item_list[i]))
                  this.unselectItem(this.lastSelected);
            }
            this.lastSelected=this.item_list[i];
            this.selectItem(this.lastSelected);
            break;
          }
        }
      }
    }
    // Update scroll top of list container to follow item selected
    if (this.lastSelected) {
      if ((this.lastSelected.offsetTop + this.lastSelected.offsetHeight) > this.list_container.offsetHeight) {
        this.list_container.scrollTop += this.lastSelected.offsetHeight;
      }
    }
    this._updateCallback();
  },
  
  selectPrev: function(event) {
    var found=false;
    var selectedItem = null;
    // If nothing is selected, start at the top.
    if (this.countSelected() == 0 &&
        this.lastSelected == this.item_list[0]) {
      this.selectItem(this.lastPointed);
    } else {

      if (!Element.visible(this.lastSelected)) {
        this.clearSelections(event);
      }

      var last=0;
      for(var i=0; this.item_list[i]; i++) {
        last=i;
      }
      for(var i=last; i>=0; i--) {
        if(!found) {
          if(this.lastSelected == this.item_list[i]) {
            found=true;
          }
        } else {
          if(Element.visible(this.item_list[i])) {
            if (!event.shiftKey) {
              this.clearSelections(event);
            }
            else {
                // Shift key
                if (this.isSelected(this.item_list[i]))
                  this.unselectItem(this.lastSelected);
            }
            this.lastSelected=this.item_list[i];
            this.selectItem(this.lastSelected);
            break;
          }
        }
      }
    }
    // Update scroll top of list container to follow item selected
    if (this.lastSelected) {
      if ((this.lastSelected.offsetTop - this.lastSelected.offsetHeight) < this.list_container.offsetHeight) {
        this.list_container.scrollTop -= this.lastSelected.offsetHeight;
      }    
    }
    this._updateCallback();
  },
    
  // this returns boolean given an item
  isSelected: function(boxid) {
    return Element.visible(boxid) && Element.hasClassName($(boxid), this.item_name + '_selected')
  },

  selectItem: function(itemid) {
    var item = $(itemid);
    if (Element.visible(itemid) && !this.isSelected(item)) {
      if (!this.options.selectMultiple) {
        this.selectNone();
      }
      this._selectedItems.push(item);
      Element.removeClassName(item, this.item_name)
      Element.addClassName(item, this.item_name + '_selected');
      if (item.cb && item.cb.type == 'checkbox') {
        item.cb.checked = true
      }
    }
  },
  
  unselectItem: function(item, notRemove) {
    var item = $(item);
    if (this.isSelected(item)) {
      if (!notRemove)
        this._removeSelectedItem(item);
      Element.removeClassName(item, this.item_name + '_selected')
      Element.addClassName(item, this.item_name)
      if (item.cb && item.cb.type == 'checkbox') {
        item.cb.checked = false;
      }
    }
  },
  
  flipItem: function(box) {
    if (this.isSelected(box)) {
      this.unselectItem(box)
    } else {
      this.selectItem(box)
    }
  },
  
  countSelected: function() {
    return this._selectedItems.length;
  },
  
  // cause all of the items to become selected
  selectAll: function() {
    this.item_list.each( function(item) {
      this.selectItem(item)
    }.bind(this))
    this._updateCallback()
  },
  
  // cause all of the items to become deselected
  selectNone: function() {
    this.getSelectedItems().each( function(item) {
      this.unselectItem(item, true)
    }.bind(this))
    this._selectedItems = [];
    this._updateCallback()
  },
  
  setEnabled: function() {
    if (this.disabled) {
      if (this.options.keyNav) {
        this.keypressListener = this.keyPress.bindAsEventListener(this);
        Event.observe(document, 'keypress', this.keypressListener);
      }
      
      Event.observe(document, 'click', this.lostFocus);
      
      this.itemClickListener = this.itemClick.bindAsEventListener(this);   
      if (this.options.clickHandle) {
          this.handle = document.getElementsByClassName(this.options.clickHandle, this.item_list)[0]
          Event.observe(this.handle, 'click', this.itemClickListener)          
        } else {
          Event.observe(this.list_container, 'click', this.itemClickListener);
      }
        
      if (this.options.disabledClass) {
        Element.removeClassName(this.list_container, this.options.disabledClass)
      }
      this.disabled = false
    }
  },
  
  lostFocus:function() {
    Control.SelectableList.lastSelectedTable = null;
  },
  
  setDisabled: function() {
    if (!this.disabled) {
      if (this.options.keyNav) {
        Event.stopObserving(document, 'keypress', this.keypressListener)
      }
      if (this.options.clickHandle) {
          Event.stopObserving(this.handle, 'click', this.itemClickListener)          
        } else {
          Event.stopObserving(this.list_container, 'click', this.itemClickListener);
        }
    
      if (this.options.disabledClass) {
        Element.addClassName(this.list_container, this.options.disabledClass)
      }
      this.disabled = true
    }
  },
  
  dispose: function() {
    this.setDisabled()
  },
  
  // return the digits from the end of the item's id
  _getItemNumber: function(item) {
    return this.box_num_reg.exec($(item).id)[1];
  },
  
  _updateCallback: function() {
    if (typeof this.options.onChange == 'function') {
      try {
        this.options.onChange(this)
      } catch (e) {}
    }
  },
  
  getSelectedItems: function() {
    return this._selectedItems;
  }, 
  
  insertItems: function(items) {
    var indexSelected = 0;
    for(var i=0; i<items.length; i++) {
      var item = items[i];
      var itemCloned = item.cloneNode(true);      
      Element.makePositioned(itemCloned); // fix IE
      // Insert item switch options
      if (this.options.insertBefore)
        // insert before all existing items
        this.list_container.appendChild(item);
      else {
        if (this.options.insertWithSortById) {
          // Insert with sort by item id
          var itemList = this._getItemOfItemsToInsert(this.item_list, item, false, this.options.orderByDesc);
          if (itemList) {
            if (indexSelected == 0)
		indexSelected = itemList[1];	      
              this.list_container.insertBefore(itemCloned, itemList[0]);
            }
          else {
            // insert after all existing items
            this.list_container.appendChild(itemCloned);  
          }
        }
        else {
          if (this.options.insertWithSortByInnerHTML) {
            var itemList = this._getItemOfItemsToInsert(this.item_list, item, true, this.options.orderByDesc);
            if (itemList) {	    
	      	  if (indexSelected == 0)
			  	indexSelected = itemList[1];	                      
              this.list_container.insertBefore(itemCloned, itemList[0]);           
            }
            else {            
              // insert after all existing items
              this.list_container.appendChild(itemCloned);  
            }
          }
          else {
            // insert after all existing items
            this.list_container.appendChild(itemCloned);
          }
        }
      }
      
      // Test if item must be unselect
      if (this.options.unSelectAllAfterInsertion || 
          this.options.unSelectNewItemsAfterInsertion) {
          this.unselectItem(itemCloned);
      }
      else {
        // select item
		if (this.isSelected(itemCloned))
	    	this._selectedItems.push(itemCloned);
		else
	        this.selectItem(itemCloned);
	    }      
    }
    
//  alert(this.list_container.outerHTML);
    Control.SelectableList.lastSelectedTable=  this.list_container; 
    // Select item
    this.item_list = $A(this.list_container.getElementsByTagName(this.options.itemTag));          
    this.lastPointed = this.item_list[indexSelected];
    this.lastSelected = this.lastPointed;
    this._refreshHTMLSelect();    
  }, 
  
  _getItemOfItemsToInsert: function(list, itemToInsert, sortByInnerHTML, orderByDesc) {
    var length = list.length;
    if(sortByInnerHTML) {c1 = itemToInsert.innerHTML;} else {c1 = itemToInsert.id;}
    if(c1) c1 = this._strip(c1).toUpperCase();
    for(var i=0; i< length; i++) {
      var item = list[i];
      if(sortByInnerHTML) {c2 = item.innerHTML} else {c2 = item.id;}
      if(c2) c2 = this._strip(c2).toUpperCase();
      if (orderByDesc) {
        if (c1 <= c2) return [item, i];
      }
      else {
        if (c1 > c2) return [item, i];
      }
    }
    return null;
  },
  
  removeItems:  function(items) {
  	Element.undoPositioned(this.list_container);

    for(var i=0; i<items.length; i++) {
      var item = items[i];
      this._removeSelectedItem(item);      
      this.list_container.removeChild(item);
    }
    this.item_list = $A(this.list_container.getElementsByTagName(this.options.itemTag));  
    this._refreshHTMLSelect();    
  }, 
  
  _removeSelectedItem:  function(c) {
    var tmparr = new Array();
    for (var i=0; i<this._selectedItems.length; i++) {
      var item = this._selectedItems[i];
      if (item!=c) 
        tmparr[tmparr.length] = item;
    }
    this._selectedItems = tmparr;
   }, 
   
   _refreshHTMLSelect: function() {
    if (this.htmlSelect) {
      // Refresh HTML select
      this.htmlSelect.options.length = 0;  
      for (var i=0; i<this.item_list.length; i++) {
        var item = this.item_list[i];
        var option = new Option(item.innerHTML, item.id);
        this.htmlSelect.options[i] = option;
        option.selected = true;
      }
    }    
   }, 
   
   _strip: function(content) {
    return content.replace(/^\s+/, '').replace(/\s+$/, '');
  }, 
  
  onFocus: function(event) {
	Control.SelectableList.lastSelectedTable = this.list_container;    
  	if (this.options.onFocus) {
  		this.options.onFocus(event);
  	}
  }
  
}


