// extentions for scriptaculous dragdrop.js

if(typeof Draggable == 'undefined')
  throw("subsdraggable.js requires including script.aculo.us' dragdrop.js library");

var SubsDraggableData = Class.create();
SubsDraggableData.prototype = {
  initialize:function() {
  
  }
}

Object.extend(Class, {
    superrise: function(obj, names){
        names.each( function(n){ obj['super_' + n] = obj[n] } )
        return obj;
    }
})

// Draggable that allows substitution of draggable element
var SubsDraggable = Class.create();
SubsDraggable.prototype = Object.extend({}, Draggable.prototype);
Class.superrise(SubsDraggable.prototype, ['initialize', 'initDrag', 'startDrag', 'endDrag'])
Object.extend( SubsDraggable.prototype , {

  initialize: function(element, options) {
    this.super_initialize.apply(this, arguments);    
    this.subsdraggable = false;
    if( typeof(this.options.getDragElement) != 'undefined' ) {
      // customizable getDragElement
      this.subsdraggable = true;
      this.getDragElement = this.options.getDragElement;
    }
    else {
      // default getDragElement
      if (typeof(this.options.isSelected) != 'undefined' && 
          typeof(this.options.getSelectedItems) != 'undefined') {
        this.getDragElement = this._getDragElement;
        this.subsdraggable = true;
      }
    }
    this.options.endeffect = this._endeffect;
    this.options.subsdrag = this;
    if (this.options.revert)
      this.options.revert = this._revert;
    this.staticContainer  = null; 
    Event.observe(window ,'load', this._initializeDivContainer.bind(this));      
    this._staticOriginalElement = this.element;
    this.setEnabled(true);
    this.setAcceptDrop(true);
  },
    
  setOptions:function(options) {
    this.options = Object.extend({ 
      itemTag: options.itemTag ? options.itemTag : 'li' 
    }, options || {});
  },
  
  setEnabled: function(enabled) {
  	this.enabled = enabled;
  },
  
  setAcceptDrop: function(acceptDrop) {
	this.acceptDrop = acceptDrop;
  },
  
  initDrag: function(event) {
  	if (!this.enabled)
  		return;
    if( this.subsdraggable){	
      if(!(typeof Draggable._dragging[this.element] != 'undefined' &&
      	Draggable._dragging[this.element])) {this._originalElement = null};    
      if (this._originalElement != null) {
        // last drag is not finished, initDrag must be stopped
        return;
      }
      var clickedelement = Event.findElement(event, this.options.itemTag);  
      this.clickedelement = clickedelement;
      if (this.options.isSelected) {
        // Test if clicked element is the same type of itemTag
        if (!(clickedelement && clickedelement.tagName &&
            clickedelement.tagName.toUpperCase() == this.options.itemTag.toUpperCase())) {
            return;
        }
      }
      var dragelement = this.getDragElement(this._staticOriginalElement, clickedelement, event);
      if (dragelement == false || dragelement == null) {
        // initDrag must be stopped
        return;
      }

      // intit drag can continue
      this._originalElement = this.element;
      this.element = dragelement;
      // Set dragelement position with clicked element position.
      Element.makePositioned(clickedelement); // fix IE
      Position.relativize(clickedelement);      
      Position.absolutize(this.element);
      if (window.opera) {
	      Position.clone(clickedelement, this.element, {offsetTop:100});
      }
      else
        Position.clone(clickedelement, this.element);
      if (this.options.revert) {
        // re-compute delta (for revert)
        this.delta = this.currentDelta();
      }
      this.super_initDrag(event);
      // Hide element to drag
      this.element.style.display='none';
    }
    else {
      // Standard initDrag draggable
      this.super_initDrag(event);
    }
  },
  
  startDrag: function(event) {
    if(this.subsdraggable){
      // Show element to drag
      this.element.style.display='';
      this.super_startDrag(event);
    }
    else {
      // Standard startDrag draggable
      this.super_startDrag(event);
    }
  },
  
  endDrag: function(event) {
    if(this.subsdraggable){
      if (this.dragging) {  
        // startDrag was called
        this.super_endDrag(event);    
      }
      else {
        // startDrag was not called, remove element
        this._endDragElement();
      }
    }
    else {
      // Standard endDrag draggable
      this.super_endDrag(event);
    }
  }, 
  
  _initializeDivContainer: function() {
 	if (this.staticContainer  == null) {
		this.staticContainer  = document.createElement('div');
		this.staticContainer.style.display = "block";
		this.staticContainer.innerHTML = "&nbsp;";
		document.body.appendChild(this.staticContainer);
    } 
  },
  
  _endDragElement: function() {
      if (this._originalElement) {
        var el = this.element;
        this.element = this._staticOriginalElement;
        Element.remove(el);
        Draggable._dragging[el] = false; 
      }
      this._originalElement = null;
  }, 
  
  _endeffect: function(element) {
    var subsdragOptions = this;
    if(element._dropped) {
      subsdragOptions.subsdrag._endDragElement();	
    }
    else {
      var toOpacity = Element.getOpacity(element)
      new Effect.Opacity(element, {duration:0.5, from:toOpacity, to:0, 
        queue: {scope:'_draggable', position:'end'},
        afterFinish: function(){ 
          subsdragOptions.subsdrag._endDragElement();		
        }
      }); 
    }
    },
    
    _getDragElement:function(element, clickedElement, event) {
      if (event.ctrlKey || event.shiftKey)
        return null;
      if (element.id && element.id.indexOf('_getDragElement_') != -1) {
      	this._originalElement = null;
      	return null;
      }
      
      var isClickedElementSelected = this.options.isSelected(clickedElement);
      if (!isClickedElementSelected) {
        // element clicked is not selected, select it.
        if (this.options.selectOneItem)
          this.options.selectOneItem(clickedElement)
      }
   
      var selectedItems = this.options.getSelectedItems(element);
      if (!selectedItems || selectedItems.length < 1)
        return null;
        
      // There is several items selected, create a div with selected items
      var div = document.createElement("div");
      div.id="_getDragElement_" + element.id; 
      var el = document.createElement("ul");
      Element.addClassName(div, "selectedItems");
      Element.addClassName(div, element.id + "_selectedItems");      
      // Populate div with items selected
      for(var i=0; i<selectedItems.length; i++) {
          var item = selectedItems[i];
          if (this.options.isSelected(item)) {
            var li = document.createElement("li");
            li.innerHTML = item.innerHTML ;
            el.appendChild(li);
          }
      }
      
      // Associate SubsDraggableData with div which will be use when 
      // items selected will be drop
      var transferData = new SubsDraggableData();
      transferData.target = element;
      transferData.selectedItems = selectedItems;
      div.transferData = transferData;
      div.appendChild(el);
      div.style.zIndex = 99999;
      this.staticContainer.appendChild(div);
      return div;    
    },
    
    _revert:function(element) {
      // revert ONLY if element was not dropped.
      return (!element._dropped);
    }
});

/*--------------------------------------------------------------------------*/

var SubsSortable = {
  SERIALIZE_RULE: /^[^_\-](?:[A-Za-z0-9\-\_]*)[_](.*)$/,
  
  sortables: {},
  
  _findRootElement: function(element) {
    while (element.tagName != "BODY") {  
      if(element.id && SubsSortable.sortables[element.id]) return element;
      element = element.parentNode;
    }
  },

  options: function(element) {
    element = SubsSortable._findRootElement($(element));
    if(!element) return;
    return SubsSortable.sortables[element.id];
  },
  
  destroy: function(element){
    var s = SubsSortable.options(element);

    if(s) {
      Draggables.removeObserver(s.element);
      s.droppables.each(function(d){ Droppables.remove(d) });
      s.draggables.invoke('destroy');
      
      delete SubsSortable.sortables[s.element.id];
    }
  },

  create: function(element) {
    element = $(element);
    var options = Object.extend({ 
      element:     element,
      tag:         'li',       // assumes li children, override with tag: 'tagname'
      dropOnEmpty: false,
      tree:        false,
      treeTag:     'ul',
      overlap:     'vertical', // one of 'vertical', 'horizontal'
      constraint:  'vertical', // one of 'vertical', 'horizontal', false
      containment: element,    // also takes array of elements (or id's); or false
      handle:      false,      // or a CSS class
      only:        false,
      delay:       0,
      hoverclass:  null,
      ghosting:    false,
      scroll:      false,
      scrollSensitivity: 20,
      scrollSpeed: 15,
      format:      this.SERIALIZE_RULE,
      onChange:    Prototype.emptyFunction,
      onUpdate:    Prototype.emptyFunction,
      onFinishDrop: Prototype.emptyFunction
    }, arguments[1] || {});

    // clear any old sortable with same element
    this.destroy(element);

    // build options for the draggables
    var options_for_draggable = {
      revert:      options.revert,
      scroll:      options.scroll,
      scrollSpeed: options.scrollSpeed,
      scrollSensitivity: options.scrollSensitivity,
      delay:       options.delay,
      ghosting:    options.ghosting,
      constraint:  options.constraint,
      handle:      options.handle,
      getDragElement: options.getDragElement,
      isSelected: options.isSelected,
      selectOneItem: options.selectOneItem,
      getSelectedItems:options.getSelectedItems,
      itemTag:options.tag};

    if(options.starteffect)
      options_for_draggable.starteffect = options.starteffect;

    if(options.reverteffect)
      options_for_draggable.reverteffect = options.reverteffect;
    else
      if(options.ghosting) options_for_draggable.reverteffect = function(element) {
        element.style.top  = 0;
        element.style.left = 0;
      };

    if(options.endeffect)
      options_for_draggable.endeffect = options.endeffect;

    if(options.zindex)
      options_for_draggable.zindex = options.zindex;

    // build options for the droppables  
    var options_for_droppable = {
      //containment:  options.containment,
      overlap:     options.overlap,
      hoverclass:  options.hoverclass,
      onDrop:     SubsSortable.onDrop,
      accept : options.accept
      //greedy:      !options.dropOnEmpty
    }

    // fix for gecko engine
    Element.cleanWhitespace(element); 

    options.draggables = [];
    options.droppables = [];

    var e = element;
    var handle = options.handle ? 
        Element.childrenWithClassName(e, options.handle)[0] : e;        
    options.draggables.push(
        new SubsDraggable(e, Object.extend(options_for_draggable, { handle: handle })));
    Droppables.add(e, options_for_droppable);    
    
    // keep reference
    this.sortables[element.id] = options;    
  },
  
  onDrop: function(element, dropon, event) {

    var transferData = element.transferData;
    if (transferData) {
      // Test if drop is not into the target
      var target = transferData.target;
      if (target.id == dropon.id)  {
        // items dropped comes from this source 
        return;
      }
      var options = SubsSortable.options(dropon.id);
      // test if subsdraggable is disabled
	  var subsDraggable = options.draggables[0];
	  if (!subsDraggable.acceptDrop)
      	return;
      // Mark element as dropped, in order to avoid to launch revert
      element._dropped = true;
      // get selected items
      var selectedItems = transferData.selectedItems;
      if (options.onFinishDrop) 
        options.onFinishDrop(target, dropon, selectedItems);
    }
  }

}