﻿<%@ Page Language="C#" %>

<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        int uploadSize = Convert.ToInt32(System.Configuration.ConfigurationSettings.AppSettings["upload_chat_maxsize"] ?? "30000");
        string allowExt = (System.Configuration.ConfigurationSettings.AppSettings["upload_chat_allowExt"] ?? "*").ToLower();
        string uploadPath = ConfigurationManager.AppSettings["upload_chat_path"];
        string cb = Request.QueryString["callback"];
        string corpID = Request.QueryString["corpid"];
        string from = Request.QueryString["from"];
        //string to = Request.QueryString["to"];
        string type = Request.QueryString["type"];
        if (string.IsNullOrEmpty(uploadPath))
            uploadPath = string.Format("/upload/{0}/chat/{1}", corpID, from);
        else
            uploadPath = uploadPath.Replace("CorpID", corpID).Replace("UserID", from);
        if (string.IsNullOrEmpty(corpID)) return;
        try
        {
            HttpFileCollection files = Context.Request.Files;
            if (files.Count == 0)
            {
                Response.Write("no file!");
                return;
            }
            HttpPostedFile postedFile = files[0];
            if (postedFile.ContentLength <= 0) return;
            string originalFileName = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf("\\") + 1);//上传源文件全名称

            //判断文件大小是否超出允许上传的最大限制	
            if (postedFile.ContentLength / 1024 > uploadSize)
            {
                OutScript(type, corpID, from, cb, "File size limited", "", uploadSize, 1);
                return;
            }
            //文件扩展名
            string ext = originalFileName.Substring(originalFileName.LastIndexOf(".") + 1).ToLower();
            if (allowExt.IndexOf("*") == -1 && allowExt.IndexOf(ext) == -1)
            {
                OutScript(type, corpID, from, cb, "Extension limited", "", postedFile.ContentLength, 2);
                return;
            }
            string nowDate = DateTime.Now.ToString("yyyy-MM-dd");
            string saveRelativePath = string.Format("{0}/{1}{2}"
                , uploadPath
                , nowDate.Substring(0, 4)
                , nowDate.Substring(5, 2)
                );
            string physicalPath = Server.MapPath(saveRelativePath);
            if (!System.IO.Directory.Exists(physicalPath)) System.IO.Directory.CreateDirectory(physicalPath);
            //if (!physicalPath.EndsWith("/")) physicalPath += "/";
            
            //按特定的本地上传文件命名规则取文件名
            string saveFileName = string.Format("{0}.{1}",this.GetRndFileName(),ext);
            //要保存的路径 + 文件名
            string saveRelativePathFileName = System.IO.Path.Combine(saveRelativePath, saveFileName).Replace("\\","/");
            string savePhysicalPathFileName = System.IO.Path.Combine(physicalPath, saveFileName);
            postedFile.SaveAs(savePhysicalPathFileName);

            OutScript(type,corpID, from, cb, saveRelativePath, saveFileName, postedFile.ContentLength, 0);
        }
        catch (System.Exception ex)
        {
            OutScript(type,corpID,from,cb, ex.Message.ToString().Replace("\\", "\\\\"), "", 0, 4);
        }
    }
    /// <summary>
    /// 输出客户端脚本
    /// </summary>
    /// <param name="msg">脚本消息</param>
    /// <param name="context">请求的HTTP特定信息</param>
    private void OutScript(string type, string corpID, string from, string callback, string dir, string filename, int fileSize, int result)
    {
        //跨域不能访问
        //Context.Response.Write(string.Format("<script type=\"text/javascript\">{0}('{1}','{2}',{3},{4});<" + "/script>", callback, dir, filename, fileSize, result));
           
        EA.IM.Message msg = new EA.IM.Message();
        msg.Cmd = "upload";
        msg.From = from;
        msg.To = from;
        msg.Time = DateTime.Now;
        msg.Content = string.Format("dir={0}&filename={1}&filesize={2}&result={3}" , dir, filename, fileSize, result);
        msg.Index = Convert.ToInt64(DateTime.Now.ToString("yyMMddHHmmssfff"));
        EA.IM.MessageBuffer.AddMessage(msg); 
    }

    void wc_DownloadDataCompleted(object sender, System.Net.DownloadDataCompletedEventArgs e)
    {
        //throw new NotImplementedException();
    }
	private string GetRndFileName()
	{       
        Random rd = new Random();
        return DateTime.Now.ToString("yyyyMMddHHmm")+rd.Next(8999).ToString() ;
    }
</script>
