﻿<%@ Page Language="C#" ValidateRequest="false" %>
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        string act = Request.QueryString["act"];
        switch (act)
        {
            case "save":
                Save();
                break;
            case "reset":
                Reset();
                break;
            case "email":
                SendEmail();
                break;
            default:
                InitControl();
                break;
        }
    }
    private void InitControl()
    {
        int corpID = Nd.Webs.EaLogin.EaUser.Instance.CorpID;       
        MUI.Components.Database.DbOperator objDB = MUI.Components.Database.DbBridge.GetDbOperator();
        //string content = MUI.Components.Database.StaticSqlDbOperator.ExecuteScalarForNotNull(string.Format("SELECT 表格 FROM JXC_出库单 T WHERE 单号='{0}'", Request.QueryString["id"]));
        //if (!string.IsNullOrEmpty(content))
        //{
        //    objDB.Dispose();
        //    Response.Write(content);
        //    Response.End();
        //    return;
        //}
        
        System.Data.DataRow drTemplate = null;
        string tid = Request.QueryString["t"];
        if (!string.IsNullOrEmpty(tid))
        {
            drTemplate = objDB.ExecSqlForDataRow(string.Format("SELECT * FROM CO_表单模板 WHERE AI={0}", tid));
        }
        else
        {
            drTemplate = objDB.ExecSqlForDataRow(string.Format("SELECT * FROM CO_表单模板 WHERE 模板类型=27 AND f=1 AND CorpID={0}", corpID));
            if (drTemplate == null)
                drTemplate = objDB.ExecSqlForDataRow("SELECT * FROM CO_表单模板 WHERE 模板类型=27 AND f=0 AND CorpID=0");
        }
        if (drTemplate == null)
        {
            objDB.Dispose();
            Response.Write(string.Format("<div style=\"padding:100px 100px;\">请设定模板  *^_^*</div>"));
            Response.End();
            return;
        }

        System.Data.DataRow drOrder = objDB.ExecSqlForDataRow(string.Format("SELECT * FROM JXC_出库单 WHERE 单号={0}", Request.QueryString["id"]));
        System.Data.DataTable dtOrderList = objDB.ExecSqlForTable(string.Format("SELECT * FROM JXC_出库单明细 WHERE 单号='{0}'", Request.QueryString["id"]));
        objDB.Dispose();
        
        string html = "";
        string html0 = MUI.Components.FormPrint.GetReplaceEditable(drTemplate["末页模板内容"].ToString());
        string html1 = MUI.Components.FormPrint.GetReplaceEditable(drTemplate["分页模板内容"].ToString());
        string listHTML = drTemplate["项目清单模板"].ToString();
        string listHTML2 = drTemplate["项目清单模板2"].ToString();
        int idx = html0.IndexOf("[ItemName]");
        if (string.IsNullOrEmpty(html0.Trim()) || (html0.IndexOf("[DataList]") == -1 && idx == -1))
        {
            Response.Write(string.Format("<div style=\"padding:100px 100px;\">请设定模板  *^_^*</div>"));
            Response.End();
            return;
        }
        //使用[DataList]替代项目清单
        MUI.Components.FormPrint.GetDataListHTML(ref html0, ref html1, ref listHTML, ref listHTML2, idx);
        html = MUI.Components.FormPrint.GetFormHTML(drTemplate, drOrder, dtOrderList, html0, html1, listHTML, listHTML2);  
        
        //string dateFormat = string.IsNullOrEmpty(drTemplate["日期格式"].ToString()) ? "yyyy-MM-dd" : drTemplate["日期格式"].ToString();//日期格式
        //html = html.Replace("[ReceiptDate]", string.IsNullOrEmpty(drOrder["收款日期"].ToString()) ? "" : dateFormat.IndexOf("/") != -1 ? Convert.ToDateTime(drOrder["收款日期"]).ToString(dateFormat).Replace("-", "/") : Convert.ToDateTime(drOrder["收款日期"]).ToString(dateFormat));

        if (html.IndexOf("<html") == -1) Response.Write(MUI.Components.FormPrint.HtmlEditorCSS);
        Response.Write(MUI.Components.FormPrint.PrintStyle);
        //Response.Write(MUI.Components.FormPrint.BizFormBtnBarHTML);
        Response.Write(MUI.Components.FormPrint.PrintBtnBarHTML);
        Response.Write(html);
        Response.End();
    }

    private void Save()
    {
        string sql = string.Format("UPDATE JXC_出库单 SET 表格=@表格 WHERE 单号='{0}'", Request.QueryString["id"]);
        System.Data.SqlClient.SqlParameter[] parameters ={
            new System.Data.SqlClient.SqlParameter("@表格",Request.Form["content"])                              
                };
        bool ok = MUI.Components.Database.StaticSqlDbOperator.ExecSqlCommandForAffectRow(sql, parameters) > 0;
        if (ok)
            Response.Write(Nd.Webs.FrameWork.Utility.Lang.Get("Com_保存成功"));
        else
            Response.Write(Nd.Webs.FrameWork.Utility.Lang.Get("Com_保存失败"));
        Response.End();
    }
    private void Reset()
    {
        string sql = string.Format("UPDATE JXC_出库单 SET 表格=NULL WHERE 单号='{0}' AND CorpID={1}", Request.QueryString["id"], Nd.Webs.EaLogin.EaUser.Instance.CorpID);
        bool ok = MUI.Components.Database.StaticSqlDbOperator.ExecSqlCommandForAffectRow(sql) > 0;
        if (ok)
            Response.Write(Nd.Webs.FrameWork.Utility.Lang.Get("Com_重置成功"));
        else
            Response.Write(Nd.Webs.FrameWork.Utility.Lang.Get("Com_重置失败"));
        Response.End();
    }
    private void SendEmail()
    {
        string sql = string.Format("UPDATE JXC_出库单 SET 表格=@表格 WHERE 单号='{0}'", Request.QueryString["id"]);
        System.Data.SqlClient.SqlParameter[] parameters ={
            new System.Data.SqlClient.SqlParameter("@表格",Request.Form["content"])                              
                };
        bool ok = MUI.Components.Database.StaticSqlDbOperator.ExecSqlCommandForAffectRow(sql, parameters) > 0;
        if (ok)
            Response.Write(EA.JXC.Lib.Util.GetSendEmailUrl("JXC_出库单", "表格", string.Format("单号='{0}'", Request.QueryString["id"])));
        else
            Response.Write("");
        Response.End();
    }
</script>