﻿<%@ WebHandler Language="C#" Class="login_inv" %>

using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using Nd.Webs.FrameWork.Utility;

public class login_inv : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        string action = context.Request.QueryString["act"];
        switch (action)
        {
            case "login":
                context.Response.Write(userLogin(context));
                break;
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }
    #region
    private string userLogin(HttpContext context)
    {
        string userName = context.Request.Form["userName"];
        string pwd = context.Request.Form["pwd"];
        string checkCode = context.Request.Form["CheckCode"];
        string nowTime = context.Request.Form["NowTime"];
        bool isRemember = context.Request.Form["IsRemember"] == "true";

        int sessionDay = isRemember ? 365 : 0;
        DateTime dt = DateTime.Now;
        string validate = String.Empty;
        int isPass;
        long userID = 0;
        int corpID = 0;
        string err = "";
        //if (HttpContext.Current.Request.Cookies["CwmCheckCode"] == null)
        //    err = "4$您的浏览器设置已被禁用 Cookies，您必须设置浏览器允许使用 Cookies 选项后才能使用本系统。";

        //else if (String.Compare(HttpContext.Current.Request.Cookies["CwmCheckCode"].Value, checkCode, true) != 0)
        //    err = "3$验证码错误，请输入正确的验证码。";
        //else 
        if (userName == "")
            err = "1$请输入用户名！";
        else if (pwd == "")
            err = "2$请输入密码！";
        else
        {
            if (new System.Text.RegularExpressions.Regex(@"^(\d+)$").IsMatch(userName))
            {
                userID = Convert.ToInt64(userName);
                //if (Common.IsMultiUser && userName.Length>6)
                //{
                //    Corp.SetCorpCookie(userName.Substring(1, userName.Length - 6));
                //}
                isPass = Nd.Webs.EaLogin.UserHandle.LoginCheck(userID, pwd, dt, sessionDay, ref validate);
            }
            else
            {
                string sql = "";
                sql = "SELECT userid,corpid FROM CO_User WHERE username=@username";// AND pwd=@pwd";
                SqlParameter[] parameters = {
		                        new SqlParameter("@username", userName)
                                //,new SqlParameter("@pwd", Nd.Webs.ClassLib.StrLib.Encrypt_MD5(pwd))
                                                    };
                DataRow dr = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForDataRow(Nd.Webs.FrameWork.Utility.Common.EACommonConnStr, sql, parameters);
                if (dr == null) isPass = 2;
                else
                {
                    userID = Convert.ToInt64(dr["userid"]);
                    corpID = Convert.ToInt32(dr["corpid"]);
                    isPass = Nd.Webs.EaLogin.UserHandle.LoginCheck(userID, pwd, dt, sessionDay, ref validate);
                    //if (isPass == 1) {

                    //    HttpCookie cookie = HttpContext.Current.Request.Cookies["Cashier_ValidateCode"];
                    //    string key = cookie.Value;
                    //    string yyyIDs = MUI.Components.Database.StaticSqlDbOperator.ExecuteScalarForNotNull(string.Format("SELECT 营业员编号 FROM JXC_仓库信息 WHERE 合法验证码='{0}'", key));
                    //    if (string.IsNullOrEmpty(yyyIDs))
                    //    {
                    //        isPass = 5;//未授权的机器
                    //    }
                    //    else
                    //    {
                    //        if (yyyIDs.IndexOf(userID.ToString()) == -1)
                    //        {
                    //            isPass = 6;//未设置商店收银员，或者说，你不是此商店的收银员
                    //        }
                    //    }
                    //}
                }
            }
            switch (isPass)
            {
                case 1:
                    //HttpContext.Current.Session["IsLogin"] = true;
                    err = "0$登录成功";
                    break;
                case 2:
                    err = "1$用户名不存在，请重新输入！";
                    break;
                case 0:
                    err = "2$密码输入错误！";
                    break;
                case 3:
                    err = "5$"+corpID.ToString();
                    break;
                case 4:
                    err = "6$你不是此商店的收银员，请联系管理员设置！";
                    break;
                case 9:
                    err = "9$数据库连接异常，请联系管理员！";
                    break;
                default:
                    err = "44$登录失败，请联系管理员！";
                    break;
            }
        }
        return err;
    }
    #endregion
}