﻿<%@ WebHandler Language="C#" Class="SavePhoto" %>

using System;
using System.Web;
using System.IO;
using System.Drawing;

public class SavePhoto : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        
        if (context.Request.Form["PHeight"] != null && context.Request.Form["PWidth"] != null && context.Request.Form["strBMP"] != null)
        {
            try
            {
                int height = int.Parse(context.Request.Form["PHeight"].ToString());
                int width = int.Parse(context.Request.Form["PWidth"].ToString());
                string strBmp = context.Request.Form["strBMP"].ToString();
                string savePath=SaveBmp(BuildBitmap(width, height, strBmp), context);

                context.Response.Write("RetMsg=true" + "&path=" + savePath);
            }
            catch (Exception)
            {
                context.Response.Write("RetMsg=false" + "&path=");
            }
        }
        
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    private System.Drawing.Bitmap BuildBitmap(int width, int height, string strBmp)
    {
        System.Drawing.Bitmap tmpBmp = new Bitmap(width, height, System.Drawing.Imaging.PixelFormat.Format32bppRgb);
        string[] StmpBmp = strBmp.Split(',');
        int pos = 0;
        for (int y = 0; y < height; y++)
        {
            for (int x = 0; x < width; x++)
            {
                tmpBmp.SetPixel(x, y, Color.FromArgb(int.Parse(StmpBmp[pos], System.Globalization.NumberStyles.HexNumber)));
                pos++;
            }
        }
        return tmpBmp;
    }
    private string SaveBmp(System.Drawing.Bitmap bmp,HttpContext context)
    {
        //string FileName = filePath + "\\" + System.Guid.NewGuid().ToString() + ".bmp";
        string reldir=GetSaveDir();
        string fileName= GetRndFileName("jpg");
        string phydir = context.Server.MapPath(reldir);
        string savePath = phydir + "\\" + fileName;
        if (!System.IO.Directory.Exists(phydir)) System.IO.Directory.CreateDirectory(phydir);
        bmp.Save(savePath, System.Drawing.Imaging.ImageFormat.Jpeg);
        return reldir + "/" + fileName;
    }
    private string GetSaveDir()
    {
        Nd.Webs.EaLogin.EaUser ea = Nd.Webs.EaLogin.EaUser.Instance;
        return System.String.Concat("/upload/",ea.CorpID,"/Kaoqin/",ea.UserID);
    }
    private string GetRndFileName(string ext)
    {
        if (ext.StartsWith(".")) ext = ext.Substring(1);
        //return System.String.Concat(DateTime.Now.Year.ToString(), DateTime.Now.Month.ToString("00"), DateTime.Now.Day.ToString("00"), DateTime.Now.Hour.ToString("00"), DateTime.Now.Minute.ToString("00"), ".", ext);
        return System.String.Concat(DateTime.Now.ToString("yyyyMMddHHmm"), ".", ext);
    }
}