unit CaiLiaoXuQiuQuyFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Mask, RzEdit, RzLabel, ExtCtrls, RzPanel,
  cxGraphics, cxCustomData, cxStyles, cxTL, cxTextEdit, cxDropDownEdit,
  cxCalc, cxInplaceContainer, RzTabs, cxControls, cxSplitter, cxCheckBox,
  DB, ADODB, cxCalendar, cxHyperLinkEdit, cxCurrencyEdit, Series, TeEngine, StrUtils, dateutils,
  TeeProcs, RzButton, cxImageComboBox, cxButtonEdit, Menus, RzRadChk,
  cxBlobEdit;

type
  TCaiLiaoXuQiuQuyF = class(TForm)
    RzPanel1: TRzPanel;
    RzLabel1: TRzLabel;
    ScdhEdit: TRzEdit;
    SelKhmcBtn: TSpeedButton;
    FindBtn: TBitBtn;
    cxSplitter2: TcxSplitter;
    YuanLiaoQuy: TADOQuery;
    MxQuy: TADOQuery;
    CLCGHistoryQuy: TADOQuery;
    GysBJQuy: TADOQuery;
    SelXMMCListEdit: TRzEdit;
    RzMenuButton1: TRzMenuButton;
    PopupMenu1: TPopupMenu;
    BuildCaiGouDingHuoDanMn: TMenuItem;
    BuildCaiGouRuKuDanMn: TMenuItem;
    RzPanel2: TRzPanel;
    RzLabel2: TRzLabel;
    RzRadioButton1: TRzRadioButton;
    RzRadioButton2: TRzRadioButton;
    ExportBtn: TBitBtn;
    PopupMenu2: TPopupMenu;
    N1: TMenuItem;
    MenuItem1: TMenuItem;
    Mx2Quy: TADOQuery;
    Mx3Quy: TADOQuery;
    RzBitBtn2: TRzBitBtn;
    RzBitBtn1: TRzBitBtn;
    RzGroupBox1: TRzGroupBox;
    cxTreeList1: TcxTreeList;
    cxTreeList1cxTreeList_BH: TcxTreeListColumn;
    cxTreeList1cxTreeList_DL: TcxTreeListColumn;
    cxTreeList1cxTreeList_clmc: TcxTreeListColumn;
    cxTreeList1cxTreeList_gg: TcxTreeListColumn;
    cxTreeList1cxTreeList_dw: TcxTreeListColumn;
    cxTreeList1cxTreeList_AutoID: TcxTreeListColumn;
    cxTreeList1cxTreeList_MainID: TcxTreeListColumn;
    cxTreeList1cxTreeList_PP: TcxTreeListColumn;
    cxTreeList1cxTreeList_XYSL: TcxTreeListColumn;
    cxTreeList1cxTreeList_KCSL: TcxTreeListColumn;
    cxTreeList1cxTreeList_SLCE: TcxTreeListColumn;
    cxTreeList1cxTreeList_FirstDate: TcxTreeListColumn;
    cxTreeList1cxTreeList_xz: TcxTreeListColumn;
    RzPanel3: TRzPanel;
    YCLInfoPanel: TRzPanel;
    RzPageControl1: TRzPageControl;
    TabSheet1: TRzTabSheet;
    cxTreeListInfo: TcxTreeList;
    cxTreeListInfocxTreeList_KHDD: TcxTreeListColumn;
    cxTreeListInfocxTreeList_khmc: TcxTreeListColumn;
    cxTreeListInfocxTreeList_CPSL: TcxTreeListColumn;
    cxTreeListInfocxTreeList_YCLSL: TcxTreeListColumn;
    cxTreeListInfocxTreeList_AutoID: TcxTreeListColumn;
    cxTreeListInfocxTreeList_xgccp: TcxTreeListColumn;
    cxTreeListInfocxTreeList_CCPlevelpathkey: TcxTreeListColumn;
    TabSheet2: TRzTabSheet;
    cxTreeList2: TcxTreeList;
    cxTreeList2cxTreeList_WLDW: TcxTreeListColumn;
    cxTreeList2cxTreeList_FSRQ: TcxTreeListColumn;
    cxTreeList2cxTreeList_JBR: TcxTreeListColumn;
    cxTreeList2cxTreeList_LB: TcxTreeListColumn;
    cxTreeList2cxTreeList_SL: TcxTreeListColumn;
    cxTreeList2cxTreeList_DJ: TcxTreeListColumn;
    cxTreeList2cxTreeList_PP: TcxTreeListColumn;
    TabSheet3: TRzTabSheet;
    GysBJcxTreeList: TcxTreeList;
    GysBJcxTreeListcxTreeList_BJRQ: TcxTreeListColumn;
    GysBJcxTreeListcxTreeList_DJ: TcxTreeListColumn;
    GysBJcxTreeListcxTreeList_Gys: TcxTreeListColumn;
    GysBJcxTreeListcxTreeList_PP: TcxTreeListColumn;
    cxTreeList1cxTreeList_LastDJ: TcxTreeListColumn;
    cxTreeList1cxTreeList_LastGYS: TcxTreeListColumn;
    LastDJQuy: TADOQuery;
    cxTreeList1cxTreeList_LastCGRQ: TcxTreeListColumn;
    RzPanel4: TRzPanel;
    Label1: TLabel;
    CLCB_YXQLEdit: TRzEdit;
    CLCB_YXQL_JKCEdit: TRzEdit;
    Label2: TLabel;
    FocusColumnColorEdit: TEdit;
    procedure SelKhmcBtnClick(Sender: TObject);
    procedure FindBtnClick(Sender: TObject);
    procedure cxTreeList1FocusedNodeChanged(Sender: TObject;
      APrevFocusedNode, AFocusedNode: TcxTreeListNode);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure BuildCaiGouDingHuoDanMnClick(Sender: TObject);
    procedure BuildCaiGouRuKuDanMnClick(Sender: TObject);
    procedure RzRadioButton1Click(Sender: TObject);
    procedure RzRadioButton2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExportBtnClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure cxTreeList1CustomDrawCell(Sender: TObject;
      ACanvas: TcxCanvas; AViewInfo: TcxTreeListEditCellViewInfo;
      var ADone: Boolean);
    procedure cxTreeListInfoCustomDrawCell(Sender: TObject;
      ACanvas: TcxCanvas; AViewInfo: TcxTreeListEditCellViewInfo;
      var ADone: Boolean);
    procedure cxTreeList1Edited(Sender: TObject;
      AColumn: TcxTreeListColumn);
  private
    { Private declarations }
  public
    Function FindFirstDateByCl(mc,gg,pp,dw:String):TDatetime;
    procedure RefreshXuQiuCaiLiaoRow(ANode:TcxTreeListNode;ADataSet:TDataSet);
    Procedure RefreshHisChengJiaoTreeList;
    Procedure RefreshGysHisBaoJiaTreeList;
    procedure GenerateCGJH(Atype:Integer);
   // procedure RefreshSLCE;
    function getyll(ANode:TcxTreeListNode):Double;
    Procedure CalcRelaChanChengPingInfo(ANode:TcxTreeListNode);
    Procedure GetLastCaiGouInfo(ANode:TcxTreeListNode);
    Procedure CalcCaiGouChengBenHJ;
    { Public declarations }
  end;

var
  CaiLiaoXuQiuQuyF: TCaiLiaoXuQiuQuyF;

implementation

uses  MainFrm, SysPublicSetFrm, CaiLiaoXuanZeFrm,
    ExportExcelSetFrm,  DingDanDetailFrm, CaiGouRuKuDanDetailFrm, SelKeHuDingDanFrm;

{$R *.dfm}

procedure TCaiLiaoXuQiuQuyF.SelKhmcBtnClick(Sender: TObject);
var
  APoint:TPoint;
begin
  APoint:= Self.SelXMMCListEdit.ClientToScreen(Point(0,Self.SelXMMCListEdit.Height));
  SelKeHuDingDanF:=TSelKeHuDingDanF.Create(Self);
  //SelKeHuDingDanF.cxTreeList1.OnDblClick:=Nil;
  SelKeHuDingDanF.ydcRadioButton.Checked :=True;
  SelKeHuDingDanF.IsMultiSelect:=True;
  SelKeHuDingDanF.Position :=poDesigned;
  SelKeHuDingDanF.Left :=APoint.X ;
  SelKeHuDingDanF.Top  :=APoint.Y;
  IF SysPublicSetF.ReadPowerSet(SysPublicSetF.RzCheckBox4.Caption  )  then
    SelKeHuDingDanF.SetStateOnly_YiDaCheng ;

  IF SelKeHuDingDanF.ShowModal<>MrOk Then Exit;
  Self.SelXMMCListEdit.Text:=SelKeHuDingDanF.ViewXm;
  IF Self.SelXMMCListEdit.Text<>'' Then Self.FindBtnClick(nil);
end;




procedure TCaiLiaoXuQiuQuyF.FindBtnClick(Sender: TObject);
Var
  ANode:TCxTreeListNode;
  sql,sql2:String;
  Flist:TStringList;
  i:integer;
begin
  IF Self.SelXMMCListEdit.Text='' Then
    Exit; 
  Self.cxTreeList1.Clear;
  sql2:='';
  Flist:=TStringList.Create ;
  FList.Text :=StrUtils.AnsiReplaceText (Self.SelXMMCListEdit.Text,';',#13#10)  ;
  For i:=0 To FList.Count-1 Do
  Begin
    IF FList[i]='' Then Continue;
    sql2:=sql2+' or ͻ='''+FList[i]+''' ';
  End;
  FList.Free;

  Sql:='select ,,,,Ʒ,λ,Sum(Ҫ) As Ҫ from Ŀϸԭϱ Where XmID in (Select AutoID from Ŀܱ Where (1=2 '+sql2+') ) And IsƷ=0 ';
  Sql:=Sql+' group by ,,,Ʒ,λ, ';

  MainF.OpenQuery(Self.YuanLiaoQuy,sql);
  While Not Self.YuanLiaoQuy.Eof Do
  Begin
    ANode:=Self.cxTreeList1.Add;
    Self.RefreshXuQiuCaiLiaoRow(ANode,Self.YuanLiaoQuy);
    Self.GetLastCaiGouInfo(ANode);
    Self.YuanLiaoQuy.Next;
  End;
  //Self.RefreshSLCE;

  Sql:='Select ,,,,Ʒ,λ,Sum() As Ҫ from Ŀϸ Where MainID In (Select AutoID from Ŀܱ Where (1=2 '+sql2+') ) And AutoID Not In (Select MainID From Ŀϸԭϱ  ) ';
  Sql:=Sql+' group by ,,,Ʒ,λ, ';

  MainF.OpenQuery(Self.YuanLiaoQuy,sql);
  While Not Self.YuanLiaoQuy.Eof Do
  Begin
    ANode:=Self.cxTreeList1.Add;
    Self.RefreshXuQiuCaiLiaoRow(ANode,Self.YuanLiaoQuy);
    Self.GetLastCaiGouInfo(ANode);
    Self.YuanLiaoQuy.Next;
  End;
 


  Self.cxTreeListInfo.Clear;
  Self.cxTreeList2.Clear;
  Self.GysBJcxTreeList.Clear;

  Self.CalcCaiGouChengBenHJ;
end;

procedure TCaiLiaoXuQiuQuyF.RefreshXuQiuCaiLiaoRow(ANode: TcxTreeListNode; ADataSet: TDataSet);
Var
  bh,dl,mc,gg,pp,dw:String;
  kcsl,xyl,yll,kcl:Double;
  FirstDate:Tdatetime;
begin
  bh:=ADataSet.FieldByName('').AsString;
  dl:=ADataSet.FieldByName('').AsString;
  mc:=ADataSet.FieldByName('').AsString;
  gg:=ADataSet.FieldByName('').AsString;
  pp:=ADataSet.FieldByName('Ʒ').AsString;
  dw:=ADataSet.FieldByName('λ').AsString;
  xyl:=ADataSet.FieldByName('Ҫ').AsFloat;
  //yll:=MainF.GetYll(mc,gg,pp,dw,Self.SelXMMCListEdit.Text,True);
  YLL:=0;
  kcsl:=MainF.GetCaiLiaoKuCunSL(mc,gg,pp,dw);
  Self.cxTreeList1cxTreeList_BH.Values[ANode.RecordIndex]:=ADataSet.FieldByName('').AsString;
  Self.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex]:=ADataSet.FieldByName('').AsString;
  Self.cxTreeList1cxTreeList_CLMC.Values[ANode.RecordIndex]:=mc;
  Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex]:=gg;
  Self.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex]:=pp;
  Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex]:=dw;
  Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex]:=xyl;
  Self.cxTreeList1cxTreeList_KCSL.Values[ANode.RecordIndex]:=kcsl;
  Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex]:=True;

  xyl:=Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex];
  kcl:=Self.cxTreeList1cxTreeList_KCSL.Values[ANode.RecordIndex];
  Self.cxTreeList1cxTreeList_SLCE.Values[ANode.RecordIndex]:=xyl-yll-kcl;

  FirstDate:=Self.FindFirstDateByCl(mc,gg,pp,dw);
  IF Yearof(firstDate)>1990 Then
   Self.cxTreeList1cxTreeList_FirstDate.Values[ANode.RecordIndex]:=firstDate;
end;



procedure TCaiLiaoXuQiuQuyF.cxTreeList1FocusedNodeChanged(Sender: TObject;
  APrevFocusedNode, AFocusedNode: TcxTreeListNode);
begin

  Self.CalcRelaChanChengPingInfo(AFocusedNode);

  Self.RefreshHisChengJiaoTreeList;
  Self.RefreshGysHisBaoJiaTreeList;

end;



function TCaiLiaoXuQiuQuyF.FindFirstDateByCl(mc, gg, pp,dw: String): TDatetime;
Var
  sql:String;
  XMMCListStr:String;
begin
  result:=-1;
  XMMCListStr:=';'+Self.SelXMMCListEdit.Text;
  sql:='select top 1  from Ŀܱ Where AutoID in (select MainID from Ŀϸ Where ='''+mc+''' And ='''+gg+''' And Ʒ='''+pp+''' And λ='''+dw+''' )  ';
  sql:=sql+' And CharIndex('';''+ͻ+'';'','''+XMMCListStr +''')>0 ';
  sql:=sql+ ' order by  ';
  MainF.OpenQuery(MainF.CheckDataQuy,sql);
  result:=MainF.CheckDataQuy.FieldByName('').AsDateTime;
end;

procedure TCaiLiaoXuQiuQuyF.RefreshGysHisBaoJiaTreeList;
Var
  Sql:String;
  ANode,CurNode:TcxTreeListNode;
  CurMC,CurGG,CurDW,CurPP:String;
begin
  Self.cxTreeList2.Clear;
  CurNode:=Self.cxTreeList1.FocusedNode;
  IF CurNode=nil Then Exit;
  CurMC:=Self.cxTreeList1cxTreeList_clmc.Values[CurNode.RecordIndex];
  CurGG:=Self.cxTreeList1cxTreeList_gg.Values[CurNode.RecordIndex];
  CurDW:=Self.cxTreeList1cxTreeList_dw.Values[CurNode.RecordIndex];
  CurPP:=Self.cxTreeList1cxTreeList_pp.Values[CurNode.RecordIndex];

  Sql:='Select Top 20 * From ϸ where =''ɹⵥ'' And =0 '+MainF.HasDanJuQuyByIsShenHe+' And ='''+CurMC+''' And ='''+CurGG+''' And λ='''+CurDW+''' And Ʒ='''+CurPP+''' ';  //='''+GZ+''' And

  Sql:=Sql+' order by ';

  Self.CLCGHistoryQuy.Close ;
  Self.CLCGHistoryQuy.SQL.Text :=Sql;
  Self.CLCGHistoryQuy.Open ;
  While Not Self.CLCGHistoryQuy.Eof do
  Begin
    ANode:=Self.cxTreeList2.Add;
    Self.cxTreeList2cxTreeList_FSRQ.Values[ANode.RecordIndex ]:=FormatDateTime('YYYY''''MM''''DD''''',Self.CLCGHistoryQuy.FieldByName('').AsDateTime );
    Self.cxTreeList2cxTreeList_SL.Values[ANode.RecordIndex ]:=Self.CLCGHistoryQuy.FieldByName('').AsFloat ;
    Self.cxTreeList2cxTreeList_DJ.Values[ANode.RecordIndex ]:=Self.CLCGHistoryQuy.FieldByName('').AsString ;
    Self.cxTreeList2cxTreeList_PP.Values[ANode.RecordIndex ]:=Self.CLCGHistoryQuy.FieldByName('Ʒ').AsString ;
    Self.cxTreeList2cxTreeList_JBR.Values[ANode.RecordIndex ]:=Self.CLCGHistoryQuy.FieldByName('').AsString  ;
    Self.cxTreeList2cxTreeList_WLDW.Values[ANode.RecordIndex ]:=Self.CLCGHistoryQuy.FieldByName('λ').AsString  ; 
    Self.CLCGHistoryQuy.Next;
  End;
end;

procedure TCaiLiaoXuQiuQuyF.RefreshHisChengJiaoTreeList;
Var
  Sql:String;
  ANode,CurNode:TcxTreeListNode;
  CurMC,CurGG,CurDW,CurPP:String;
begin
  Self.GysBJcxTreeList.Clear;
  CurNode:=Self.cxTreeList1.FocusedNode;
  IF CurNode=nil Then Exit;
  CurMC:=Self.cxTreeList1cxTreeList_clmc.Values[CurNode.RecordIndex];
  CurGG:=Self.cxTreeList1cxTreeList_gg.Values[CurNode.RecordIndex];
  CurDW:=Self.cxTreeList1cxTreeList_dw.Values[CurNode.RecordIndex];
  CurPP:=Self.cxTreeList1cxTreeList_pp.Values[CurNode.RecordIndex];
  Sql:='Select * From Ӧԭϼ۸ñ where ='''+CurMC+''' And ='''+CurGG+''' And λ='''+CurDW+''' And Ʒ='''+CurPP+''' ';
  Self.GysBJQuy.Close ;
  Self.GysBJQuy.SQL.Text :=Sql;
  Self.GysBJQuy.Open ;
  While Not Self.GysBJQuy.Eof do
  Begin
    ANode:=Self.GysBJcxTreeList.Add;
    Self.GysBJcxTreeListcxTreeList_BJRQ.Values[ANode.RecordIndex ]:=FormatDateTime('YYYY''''MM''''DD''''',Self.GysBJQuy.FieldByName('').AsDateTime );
    Self.GysBJcxTreeListcxTreeList_DJ.Values[ANode.RecordIndex ]:=Self.GysBJQuy.FieldByName('۸').AsFloat ;
    Self.GysBJcxTreeListcxTreeList_Gys.Values[ANode.RecordIndex ]:=Self.GysBJQuy.FieldByName('Ӧ').AsString ;
    Self.GysBJcxTreeListcxTreeList_PP.Values[ANode.RecordIndex ]:=Self.GysBJQuy.FieldByName('Ʒ').AsString ;
    Self.GysBJQuy.Next;
  End;
end;



procedure TCaiLiaoXuQiuQuyF.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:=CaFree;
  CaiLiaoXuQiuQuyF:=nil;

end;

procedure TCaiLiaoXuQiuQuyF.FormShow(Sender: TObject);
begin
  IF Not MainF.IsUserdPP Then
  Begin
    Self.cxTreeList1cxTreeList_PP.Visible:=false; 
  End;
  Self.RzPageControl1.TabIndex:=0;
end;



procedure TCaiLiaoXuQiuQuyF.GenerateCGJH(Atype: Integer);
Var
  i,j:integer;
  xyl,kcl,slce:Double;
  ANode,AddNode:TcxTreeListNode;
  IsXz:Boolean;
begin
  IF Self.SelXMMCListEdit.Text='' Then
  Begin
    Application.MessageBox('ѡĿ!','ʾ',48);
    Exit;
  End;
  IsXz:=false;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      IsXz:=True;
      Break;
    End;
  End;
  IF Not IsXz Then
  Begin
    Application.MessageBox('ѡһֲ!','ʾ',48);
    Exit;
  End;

  DingDanDetailF:=TDingDanDetailF.Create(Self);
  DingDanDetailF.Caption:='ɹ';
  DingDanDetailF.KHDDEdit.Text:=Self.SelXMMCListEdit.Text;
  DingDanDetailF.FormState:=1;
  DingDanDetailF.AutoID:=-1;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      xyl:= Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex];
      kcl:= Self.cxTreeList1cxTreeList_KCSL.Values[ANode.RecordIndex];
      slce:=Self.cxTreeList1cxTreeList_SLCE.Values[ANode.RecordIndex];
      AddNode:=DingDanDetailF.cxTreeList1.Add ;
      DingDanDetailF.cxTreeList1cxTreeList_ZT.Values[AddNode.RecordIndex ]:= 1;
      DingDanDetailF.cxTreeList1cxTreeList_DL.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_BH.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_BH.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_MC.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_CLMC.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_GG.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_DW.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_PP.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_DJ.Values[AddNode.RecordIndex ]:= 0;
      IF Atype=1 Then
        DingDanDetailF.cxTreeList1cxTreeList_SL.Values[AddNode.RecordIndex ]:=slce
      Else
        DingDanDetailF.cxTreeList1cxTreeList_SL.Values[AddNode.RecordIndex ]:= 0;

    End;
  End;

  DingDanDetailF.GetAllLastDJ;
  DingDanDetailF.SetLastDJ;
  DingDanDetailF.CalcTreeListJE;

  DingDanDetailF.ShowModal;
  {

  JiHuaDanF:=TJiHuaDanF.Create(Self);
  JiHuaDanF.Caption:='ɹƻ';
  JiHuaDanF.Formstate:=1;
  JiHuaDanF.AutoID:=-1;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    CurNode:=Self.cxTreeList1.Items[i];
    CurNode.Focused:=true;
    CurNode.MakeVisible;
    xyl:= Self.cxTreeList1cxTreeList_XYSL.Values[CurNode.RecordIndex];
    kcl:= Self.cxTreeList1cxTreeList_KCSL.Values[CurNode.RecordIndex];
    yll:= Self.cxTreeList1cxTreeList_YLL.Values[CurNode.RecordIndex];
    slce:=Self.cxTreeList1cxTreeList_SLCE.Values[CurNode.RecordIndex];
    ANode:=JiHuaDanF.cxTreeList1.Add ;
    JiHuaDanF.cxTreeList1cxTreeList_ZT.Values[ANode.RecordIndex ]:= 1;
    JiHuaDanF.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DL.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_BH.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_BH.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_MC.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_CLMC.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_GG.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DW.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex ]:= Self.cxTreeList1cxTreeList_PP.Values[CurNode.RecordIndex];
    JiHuaDanF.cxTreeList1cxTreeList_DJ.Values[ANode.RecordIndex ]:= 0;
    IF Atype=1 Then
      JiHuaDanF.cxTreeList1cxTreeList_SBL.Values[ANode.RecordIndex ]:=slce
    Else
      JiHuaDanF.cxTreeList1cxTreeList_SBL.Values[ANode.RecordIndex ]:= 0;


    JiHuaDanF.cxTreeList1cxTreeList_SDL.Values[ANode.RecordIndex ]:=0;
    JiHuaDanF.cxTreeList1cxTreeList_JE.Values[ANode.RecordIndex ]:= 0;
    JiHuaDanF.cxTreeList1cxTreeList_Gys.Values[ANode.RecordIndex ]:= '';
    JiHuaDanF.cxTreeList1cxTreeList_BZ.Values[ANode.RecordIndex ]:= '';
    JiHuaDanF.cxTreeList1cxTreeList_JHDCSJ.Values[ANode.RecordIndex ]:= JiHuaDanF.DateTimePicker1.DateTime ;
    JIHuaDanF.cxTreeList1cxTreeList_KCL.Values[ANode.RecordIndex]:=kcl;
    JIHuaDanF.cxTreeList1cxTreeList_SCXYL.Values[ANode.RecordIndex]:=xyl;
    JIHuaDanF.cxTreeList1cxTreeList_YLL.Values[ANode.RecordIndex]:=YLL;
    JiHuaDanF.cxTreeList1cxTreeList_DJSX.Values[ANode.RecordIndex]:=JiHuaDanF.GetMaxDJXS;
    scdh:='';
    For J:=0 To Self.cxTreeListInfo.Count-1 Do
    Begin
      scdh:=scdh+Self.cxTreeListInfocxTreeList_Scdh.Values[j]+';';
    End;
    JiHuaDanF.cxTreeList1cxTreeList_SCDH.Values[ANode.RecordIndex]:=scdh;
    JiHuaDanF.CalcTreeListJE ;
    JiHuaDanF.CalcYanSe(ANode);
    ANode.Focused :=True;
    IF JiHuaDanF.AddFirstNode =Nil then JiHuaDanF.AddFirstNode:=ANode;
  End;
  JiHuaDanF.ShowModal;   }
end;




procedure TCaiLiaoXuQiuQuyF.BuildCaiGouDingHuoDanMnClick(Sender: TObject);
Var
  i,j:integer;
  xyl,kcl,slce:Double;
  ANode,AddNode:TcxTreeListNode;
  IsXz:Boolean;
begin
  IF Self.SelXMMCListEdit.Text='' Then
  Begin
    Application.MessageBox('ѡĿ!','ʾ',48);
    Exit;
  End;
  IsXz:=false;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      IsXz:=True;
      Break;
    End;
  End;
  IF Not IsXz Then
  Begin
    Application.MessageBox('ѡһֲ!','ʾ',48);
    Exit;
  End;

  DingDanDetailF:=TDingDanDetailF.Create(Self);
  DingDanDetailF.Caption:='ɹ';
  DingDanDetailF.KHDDEdit.Text:=Self.SelXMMCListEdit.Text;
  DingDanDetailF.FormState:=1;
  DingDanDetailF.AutoID:=-1;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      xyl:= Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex];
      kcl:= Self.cxTreeList1cxTreeList_KCSL.Values[ANode.RecordIndex];
      IF Self.RzRadioButton1.Checked then
         slce:=Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex]
      Else
         slce:=Self.cxTreeList1cxTreeList_SLCE.Values[ANode.RecordIndex];

      AddNode:=DingDanDetailF.cxTreeList1.Add ;
      DingDanDetailF.cxTreeList1cxTreeList_ZT.Values[AddNode.RecordIndex ]:= 1;
      DingDanDetailF.cxTreeList1cxTreeList_DL.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_BH.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_BH.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_MC.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_CLMC.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_GG.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_DW.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_PP.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex];
      DingDanDetailF.cxTreeList1cxTreeList_DJ.Values[AddNode.RecordIndex ]:= 0;
      DingDanDetailF.cxTreeList1cxTreeList_SL.Values[AddNode.RecordIndex ]:=slce;
    End;
  End;

  DingDanDetailF.GetAllLastDJ;
  DingDanDetailF.SetLastDJ;
  DingDanDetailF.CalcTreeListJE;

  DingDanDetailF.ShowModal;
end;




procedure TCaiLiaoXuQiuQuyF.BuildCaiGouRuKuDanMnClick(Sender: TObject);
Var
  I:integer;
  xyl,kcl,slce:Double;
  ANode,AddNode:TcxTreeListNode;
  IsXz:Boolean;
begin
  IF Self.SelXMMCListEdit.Text='' Then
  Begin
    Application.MessageBox('ѡĿ!','ʾ',48);
    Exit;
  End;
  IsXz:=false;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      IsXz:=True;
      Break;
    End;
  End;
  IF Not IsXz Then
  Begin
    Application.MessageBox('ѡһֲ!','ʾ',48);
    Exit;
  End;

  CaiGouRuKuDanDetailF:=TCaiGouRuKuDanDetailF.Create(Self);
  CaiGouRuKuDanDetailF.Caption:='ɹ';
  CaiGouRuKuDanDetailF.KHDDEdit.Text:=Self.SelXMMCListEdit.Text;
  CaiGouRuKuDanDetailF.State:=1;
  CaiGouRuKuDanDetailF.AutoID:=-1;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    IF Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex] Then
    Begin
      xyl:= Self.cxTreeList1cxTreeList_XYSL.Values[ANode.RecordIndex];
      kcl:= Self.cxTreeList1cxTreeList_KCSL.Values[ANode.RecordIndex];
      IF Self.RzRadioButton1.Checked then
         slce:=xyl
      Else
         slce:=Self.cxTreeList1cxTreeList_SLCE.Values[ANode.RecordIndex];

      AddNode:=CaiGouRuKuDanDetailF.cxTreeList1.Add ;
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_ZT.Values[AddNode.RecordIndex ]:= 1;
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_DL.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_BH.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_BH.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_CLMC.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_CLMC.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_GG.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_DW.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_PP.Values[AddNode.RecordIndex ]:= Self.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex];
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_DJ.Values[AddNode.RecordIndex ]:= 0;
      CaiGouRuKuDanDetailF.cxTreeList1cxTreeList_SL.Values[AddNode.RecordIndex ]:=slce;
    End;
  End;

  CaiGouRuKuDanDetailF.CalcTreeListJE;
  CaiGouRuKuDanDetailF.ShowModal;

end;

function TCaiLiaoXuQiuQuyF.getyll(ANode:TcxTreeListNode): Double;
begin
  result:=0;
end;

procedure TCaiLiaoXuQiuQuyF.RzRadioButton1Click(Sender: TObject);
begin
  //Self.RefreshSLCE;
  Self.cxTreeList1.Refresh;
end;

procedure TCaiLiaoXuQiuQuyF.RzRadioButton2Click(Sender: TObject);
begin
  //Self.RefreshSLCE;
  Self.cxTreeList1.Refresh;  
end;
{
procedure TCaiLiaoXuQiuQuyF.RefreshSLCE;
Var
  I:Integer;
  CurNode:TCxTreeListNode;
  xyl,yll,kcl:Double;
begin
  IF Self.cxTreeList1.Count=0 Then Exit;
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    CurNode:=Self.cxTreeList1.Items[i];
    xyl:=Self.cxTreeList1cxTreeList_XYSL.Values[CurNode.RecordIndex];
    kcl:=Self.cxTreeList1cxTreeList_KCSL.Values[CurNode.RecordIndex];
    IF Self.RzRadioButton1.Checked Then
      Self.cxTreeList1cxTreeList_SLCE.Values[CurNode.RecordIndex]:=xyl-yll
    Else
      Self.cxTreeList1cxTreeList_SLCE.Values[CurNode.RecordIndex]:=xyl-yll-kcl;
  End;

end; }

procedure TCaiLiaoXuQiuQuyF.FormCreate(Sender: TObject);
Var
  CanNew,CanModify,CanView,CanChongXiao,CanExport: Boolean  ;
begin
  MainF.GetListFormPower('ԭ',CanNew, CanModify,CanView, CanChongXiao,CanExport);
  Self.SelKhmcBtn.Enabled :=CanNew;
  Self.RzMenuButton1.Enabled :=CanNew;

  IF MainF.IsNoCaiLiaoDJView Then
  Begin
    Self.RzPageControl1.Pages[1].TabVisible:=false;
    Self.RzPageControl1.Pages[2].TabVisible:=false;
  End;
  
end;

procedure TCaiLiaoXuQiuQuyF.ExportBtnClick(Sender: TObject);
begin
  IF Self.cxTreeList1.Count=0 Then
  Begin
    Application.MessageBox('޵!','ʾ',48);
    Exit;
  End;
  ExportExcelSetF:=TExportExcelSetF.Create(Self);
  ExportExcelSetF.Title:='ԭ';
  ExportExcelSetF.CurTreeList :=Self.cxTreeList1 ;
  ExportExcelSetF.CurExportGridPath :=MainF.ExportGridPath +'ԭ\';
  ExportExcelSetF.ShowModal ;
end;

procedure TCaiLiaoXuQiuQuyF.N1Click(Sender: TObject);
Var
  ANode:TcxTreeListNode;
  i:Integer;
begin
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex]:=True;
  End;

  Self.CalcCaiGouChengBenHJ();
end;

procedure TCaiLiaoXuQiuQuyF.MenuItem1Click(Sender: TObject);
Var
  ANode:TcxTreeListNode;
  i:Integer;
begin
  For i:=0 To Self.cxTreeList1.Count-1 Do
  Begin
    ANode:=Self.cxTreeList1.Items[i];
    Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex]:=Not Self.cxTreeList1cxTreeList_xz.Values[ANode.RecordIndex];
  End;
  Self.CalcCaiGouChengBenHJ();
end;

procedure TCaiLiaoXuQiuQuyF.cxTreeList1CustomDrawCell(Sender: TObject;
  ACanvas: TcxCanvas; AViewInfo: TcxTreeListEditCellViewInfo;
  var ADone: Boolean);
begin
  IF (AViewInfo.Column=Self.cxTreeList1cxTreeList_XYSL) And Self.RzRadioButton1.Checked then
     ACanvas.Brush.Color:=Self.FocusColumnColorEdit.Color;

  IF (AViewInfo.Column=Self.cxTreeList1cxTreeList_SLCE) And Self.RzRadioButton2.Checked then
     ACanvas.Brush.Color:=Self.FocusColumnColorEdit.Color;

  IF AViewInfo.Column=Self.cxTreeList1cxTreeList_XZ Then
    ACanvas.Brush.Color:=MainF.XzColorEdit.Color;
end;




procedure TCaiLiaoXuQiuQuyF.CalcRelaChanChengPingInfo(
  ANode: TcxTreeListNode);
Var
  sql,sql2,sql3:String;
  mc,gg,pp,dw:String;
  CCPAutoID,XMAutoID:Integer;
  TopNode,CNode:TCxTreeListNode;
  XMMCList:string;
begin
  Self.cxTreeListInfo.Clear;
  IF ANode=nil Then Exit;

  mc:=Self.cxTreeList1cxTreeList_clmc.Values[ANode.RecordIndex];
  dw:=Self.cxTreeList1cxTreeList_dw.Values[ANode.RecordIndex]; 
  gg:='';
  IF Self.cxTreeList1cxTreeList_gg.Values[ANode.RecordIndex]<>NULL then
     gg:=Self.cxTreeList1cxTreeList_gg.Values[ANode.RecordIndex];
  pp:='';
  IF Self.cxTreeList1cxTreeList_pp.Values[ANode.RecordIndex]<>NULL then
     pp:=Self.cxTreeList1cxTreeList_pp.Values[ANode.RecordIndex];

  XMMCList:=Self.SelXMMCListEdit.Text ;

  sql:='select AutoID,ͻ,׷ from Ŀܱ where CharIndex('';''+ͻ+'';'','';'+XMMCList+''')>0 And AutoID in (select XMID from Ŀϸԭϱ where ='''+mc+''' And ='''+gg+''' And Ʒ='''+pp+''' And λ='''+dw+''') Order by ׷,ͻ';
  MainF.OpenQuery(Self.MxQuy,sql);
  Try
    Self.cxTreeListInfo.BeginUpdate;
    While Not Self.MxQuy.Eof do
    Begin
      XMAutoID:=Self.MxQuy.FieldByName('AutoID').AsInteger;

      TopNode:=Self.cxTreeListInfo.Add;
      Self.cxTreeListInfocxTreeList_KHDD.Values[TopNode.RecordIndex]:=Self.MxQuy.FieldByName('ͻ').AsString;
      Self.cxTreeListInfocxTreeList_khmc.Values[TopNode.RecordIndex]:=Self.MxQuy.FieldByName('׷').AsString;
      Self.cxTreeListInfocxTreeList_AutoID.Values[TopNode.RecordIndex]:=XMAutoID;
      Self.cxTreeListInfocxTreeList_YCLSL.Values[TopNode.RecordIndex]:=0;

      sql2:='select AutoID, As AMC, As AGG,λ As ADW, from Ŀϸ As MainTB where MainID='+IntToStr(XMAutoID) ;  //Ʒ
      sql2:=sql2+' And AutoID In ( Select MainID From Ŀϸԭϱ As DetailTB where XMID='+IntToStr(XMAutoID)+' And ='''+mc+''' And ='''+gg+''' And Ʒ='''+pp+''' And λ='''+dw+''' ) ';
      MainF.OpenQuery(Self.Mx2Quy,sql2);
      While Not Self.Mx2Quy.Eof do
      Begin
        CNode:=TopNode.AddChild;
        Self.cxTreeListInfocxTreeList_xgccp.Values[CNode.RecordIndex]:=Self.Mx2Quy.FieldByName('AMC').AsString+','+Self.Mx2Quy.FieldByName('AGG').AsString+','+Self.Mx2Quy.FieldByName('ADW').AsString;
        Self.cxTreeListInfocxTreeList_CPSL.Values[CNode.RecordIndex]:=Self.Mx2Quy.FieldByName('').AsFloat;
        CCPAutoID :=Self.Mx2Quy.FieldByName('AutoID').AsInteger;

        Sql3:='select SUM(Ҫ) as sl from Ŀϸԭϱ where MainID='+IntToStr(CCPAutoID) +' And ='''+mc+''' And ='''+gg+''' And Ʒ='''+pp+''' And λ='''+dw+''' ';
        MainF.OpenQuery(Self.Mx3Quy,sql3);
        IF Self.Mx3Quy.RecordCount>0 Then
        Begin
          Self.cxTreeListInfocxTreeList_YCLSL.Values[CNode.RecordIndex]:=Self.Mx3Quy.FieldByName('sl').AsFloat;
          Self.cxTreeListInfocxTreeList_YCLSL.Values[TopNode.RecordIndex]:=Self.cxTreeListInfocxTreeList_YCLSL.Values[TopNode.RecordIndex]+Self.Mx3Quy.FieldByName('sl').AsFloat;
        End;
        Self.Mx2Quy.Next;
      End;

      Self.MxQuy.Next;
    End;

  Finally
    Self.cxTreeListInfo.EndUpdate;
  End;

  Self.cxTreeListInfo.FullExpand ;

end;

procedure TCaiLiaoXuQiuQuyF.cxTreeListInfoCustomDrawCell(Sender: TObject;
  ACanvas: TcxCanvas; AViewInfo: TcxTreeListEditCellViewInfo;
  var ADone: Boolean);
begin
  IF AViewInfo.Node.Level=1 Then
     ACanvas.Brush.Color:=clinfobk;

  IF AViewInfo.Node.Selected  then
  Begin
    ACanvas.Brush.Color := clHighLight ;
    ACanvas.Font.Color :=clWindow;
  End;

end;


procedure TCaiLiaoXuQiuQuyF.GetLastCaiGouInfo(ANode: TcxTreeListNode);
Var
  WLDW:String;
  DL,MC,GG,DW,PP:string;
  DJ:Double;
  CGRQ:TDateTime;
begin
  IF ANode=Nil Then Exit;
  DL:=Self.cxTreeList1cxTreeList_DL.Values[ANode.RecordIndex];
  MC:=Self.cxTreeList1cxTreeList_clmc.Values[ANode.RecordIndex];
  GG:='';PP:='';DW:='';

  IF Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex]<>NULL then
     GG:=Self.cxTreeList1cxTreeList_GG.Values[ANode.RecordIndex];
  IF Self.cxTreeList1cxTreeList_PP.Values[ANode.RecordIndex]<>NULL then
     pp:=Self.cxTreeList1cxTreeList_pp.Values[ANode.RecordIndex];
  IF Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex]<>NULL then
     DW:=Self.cxTreeList1cxTreeList_DW.Values[ANode.RecordIndex];

  Self.cxTreeList1cxTreeList_LastDJ.Values[ANode.RecordIndex]:=0;
  Self.cxTreeList1cxTreeList_LastGYS.Values[ANode.RecordIndex]:='';
  Self.cxTreeList1cxTreeList_LastCGRQ.Values[ANode.RecordIndex]:=NULL;
  
  IF MainF.GetLastCaiGouInfo(WLDW,DL,MC,GG,DW,PP,DJ,CGRQ) then
  Begin
    Self.cxTreeList1cxTreeList_LastDJ.Values[ANode.RecordIndex]:=DJ;
    Self.cxTreeList1cxTreeList_LastGYS.Values[ANode.RecordIndex]:=WLDW;
    Self.cxTreeList1cxTreeList_LastCGRQ.Values[ANode.RecordIndex]:=CGRQ;
  End;
  
end;

procedure TCaiLiaoXuQiuQuyF.CalcCaiGouChengBenHJ;
Var
  I:Integer;
  ANode:TcxTreeListNode;
  CGDJ,YXQL,YXQL_JKC,HJ,HJ_JKC:Double;
begin
  HJ:=0;HJ_JKC:=0;
  For I:=0 to Self.cxTreeList1.Count -1 do
  Begin
    ANode:=Self.cxTreeList1.Items [I];
    IF Self.cxTreeList1cxTreeList_xz.Values [ANode.RecordIndex] then
    Begin
      CGDJ:=0;
      IF Self.cxTreeList1cxTreeList_LastDJ.Values [ANode.RecordIndex]<>NULL then
         CGDJ:=Self.cxTreeList1cxTreeList_LastDJ.Values [ANode.RecordIndex];
      YXQL:=0;YXQL_JKC:=0;
      IF Self.cxTreeList1cxTreeList_XYSL.Values [ANode.RecordIndex]<>NULL then
         YXQL:=Self.cxTreeList1cxTreeList_XYSL.Values [ANode.RecordIndex];

      IF Self.cxTreeList1cxTreeList_SLCE.Values [ANode.RecordIndex]<>NULL then
         YXQL_JKC:=Self.cxTreeList1cxTreeList_SLCE.Values [ANode.RecordIndex];

      HJ:=HJ+StrToFloat(FormatFloat('0.00',CGDJ*YXQL));
      HJ_JKC:=HJ_JKC+StrToFloat(FormatFloat('0.00',CGDJ*YXQL_JKC));
    End;

  End;

  Self.CLCB_YXQLEdit.Text :=FloatToStr( HJ);
  Self.CLCB_YXQL_JKCEdit.Text :=FloatToStr( HJ_JKC);

end;

procedure TCaiLiaoXuQiuQuyF.cxTreeList1Edited(Sender: TObject;
  AColumn: TcxTreeListColumn);
begin
  Self.CalcCaiGouChengBenHJ();
end;

end.
