/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.ConsumerImpl;
import expect4j.IOPair;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;

public class PollingConsumer
extends ConsumerImpl {
    boolean dirtyBuffer = false;
    Boolean callerProcessing = Boolean.FALSE;
    boolean foundMore = false;

    public PollingConsumer(IOPair pair) {
        super(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        char[] cs = new char[256];
        int ioErrorCount = 0;
        Reader reader = this.pair.getReader();
        ConsumerImpl.log.fine("Starting primary loop");
        while (!this.stopRequested && !this.foundEOF && ioErrorCount < 4) {
            try {
                boolean ready;
                block24: {
                    ConsumerImpl.log.finest("Checking ready");
                    ready = false;
                    try {
                        ready = reader.ready();
                        if (!reader.markSupported()) break block24;
                        ConsumerImpl.log.fine("Mark Supported");
                    }
                    catch (Exception ioe) {
                        ConsumerImpl.log.log(Level.FINE, "While checking ready", ioe);
                        this.foundEOF = true;
                        break;
                    }
                }
                if (ready) {
                    ConsumerImpl.log.finest("Is Ready");
                    PollingConsumer ioe = this;
                    synchronized (ioe) {
                        while (this.callerProcessing.booleanValue()) {
                            ConsumerImpl.log.finer("Waiting for caller to finish");
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                ConsumerImpl.log.info("Woken up early");
                            }
                        }
                        ConsumerImpl.log.finer("About to wait for buffer lock");
                        StringBuffer stringBuffer = this.buffer;
                        synchronized (stringBuffer) {
                            int length = reader.read(cs);
                            if (length == -1) {
                                ConsumerImpl.log.fine("Found the EOF");
                                ConsumerImpl.log.fine("Current buffer: " + this.buffer.toString());
                                this.foundEOF = true;
                                this.dirtyBuffer = true;
                                break;
                            }
                            String print = new String(cs, 0, length);
                            print = print.replaceAll("\n", "\\\\n");
                            print = print.replaceAll("\r", "\\\\r");
                            ConsumerImpl.log.finer("Appending >>>" + print + "<<<");
                            this.buffer.append(cs, 0, length);
                            ConsumerImpl.log.finer("Current Buffer: " + this.buffer.toString());
                            this.dirtyBuffer = true;
                            ConsumerImpl.log.finest("Waking up who ever if listening");
                            this.buffer.notify();
                        }
                    }
                }
                ConsumerImpl.log.finest("Not Ready, sleeping");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ConsumerImpl.log.finest("Done sleeping");
            }
            catch (IOException ioe) {
                ConsumerImpl.log.log(Level.WARNING, "Exception in loop body", ioe);
                ++ioErrorCount;
            }
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.notify();
        }
        if (this.stopRequested) {
            ConsumerImpl.log.info("Stop Requested");
            this.pair.close();
        }
        if (this.foundEOF) {
            ConsumerImpl.log.info("Found EOF to stop while loop");
        }
        if (ioErrorCount >= 4) {
            ConsumerImpl.log.info("ioErrorCount at " + ioErrorCount);
        }
        ConsumerImpl.log.fine("Leaving primary loop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBuffer(long timeoutMilli) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (this.dirtyBuffer) {
                return;
            }
            if (!this.foundEOF()) {
                ConsumerImpl.log.fine("Waiting for things to come in, or until timeout");
                try {
                    if (timeoutMilli > 0L) {
                        this.buffer.wait(timeoutMilli);
                    } else {
                        this.buffer.wait();
                    }
                }
                catch (InterruptedException ie) {
                    ConsumerImpl.log.info("Woken up, while waiting for buffer");
                }
                ConsumerImpl.log.fine("Waited");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pause() {
        String currentBuffer;
        PollingConsumer pollingConsumer = this;
        synchronized (pollingConsumer) {
            currentBuffer = this.buffer.toString();
            this.dirtyBuffer = false;
            this.callerProcessing = Boolean.TRUE;
        }
        return currentBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(int offset) {
        PollingConsumer pollingConsumer = this;
        synchronized (pollingConsumer) {
            if (offset >= 0) {
                ConsumerImpl.log.fine("Moving buffer up by " + offset);
                StringBuffer smaller = this.buffer.delete(0, offset + 1);
                ConsumerImpl.log.fine("New size: " + this.buffer.length() + " vs " + smaller.length());
            }
            this.callerProcessing = Boolean.FALSE;
            this.notify();
        }
    }

    public static void main(String[] args) throws Exception {
        final StringBuffer buffer = new StringBuffer("The lazy fox");
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StringBuffer stringBuffer = buffer;
                synchronized (stringBuffer) {
                    buffer.delete(0, 4);
                    buffer.append(" in the middle");
                    System.err.println("Middle");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    buffer.append(" of fall");
                    System.err.println("Fall");
                }
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(" jump over the fence");
                System.err.println("Fence");
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.err.println(buffer);
    }
}

