/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.BreakIterator;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import sun.awt.InputMethodSupport;

public class TextComponent
extends Component
implements Accessible {
    String text;
    boolean editable = true;
    int selectionStart;
    int selectionEnd;
    boolean backgroundSetByClientCode = false;
    private transient boolean canAccessClipboard;
    protected transient TextListener textListener;
    private static final long serialVersionUID = -2214773872412987419L;
    private int textComponentSerializedDataVersion = 1;
    private boolean checkForEnableIM = true;

    TextComponent(String string) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.text = string != null ? string : "";
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.checkSystemClipboardAccess();
    }

    private void enableInputMethodsIfNecessary() {
        if (this.checkForEnableIM) {
            this.checkForEnableIM = false;
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                boolean bl = false;
                if (toolkit instanceof InputMethodSupport) {
                    bl = ((InputMethodSupport)((Object)toolkit)).enableInputMethodsForTextComponent();
                }
                this.enableInputMethods(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void enableInputMethods(boolean bl) {
        this.checkForEnableIM = false;
        super.enableInputMethods(bl);
    }

    @Override
    boolean areInputMethodsEnabled() {
        if (this.checkForEnableIM) {
            this.enableInputMethodsIfNecessary();
        }
        return (this.eventMask & 0x1000L) != 0L;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            return textComponentPeer.getInputMethodRequests();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.enableInputMethodsIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
            if (textComponentPeer != null) {
                this.text = textComponentPeer.getText();
                this.selectionStart = textComponentPeer.getSelectionStart();
                this.selectionEnd = textComponentPeer.getSelectionEnd();
            }
            super.removeNotify();
        }
    }

    public synchronized void setText(String string) {
        this.text = string != null ? string : "";
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setText(this.text);
        }
    }

    public synchronized String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    public synchronized String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl);
        }
    }

    @Override
    public Color getBackground() {
        if (!this.editable && !this.backgroundSetByClientCode) {
            return SystemColor.control;
        }
        return super.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundSetByClientCode = true;
        super.setBackground(color);
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionStart = textComponentPeer.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public synchronized void select(int n, int n2) {
        String string = this.getText();
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        this.selectionStart = n;
        this.selectionEnd = n2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(n, n2);
        }
    }

    public synchronized void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.getText().length();
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(this.selectionStart, this.selectionEnd);
        }
    }

    public synchronized void setCaretPosition(int n) {
        TextComponentPeer textComponentPeer;
        if (n < 0) {
            throw new IllegalArgumentException("position less than zero.");
        }
        int n2 = this.getText().length();
        if (n > n2) {
            n = n2;
        }
        if ((textComponentPeer = (TextComponentPeer)this.peer) != null) {
            textComponentPeer.setCaretPosition(n);
        } else {
            this.select(n, n);
        }
    }

    public synchronized int getCaretPosition() {
        int n;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        int n2 = 0;
        n2 = textComponentPeer != null ? textComponentPeer.getCaretPosition() : this.selectionStart;
        if (n2 > (n = this.getText().length())) {
            n2 = n;
        }
        return n2;
    }

    public synchronized void addTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    public synchronized TextListener[] getTextListeners() {
        return (TextListener[])this.getListeners(TextListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        TextListener textListener = null;
        if (clazz != TextListener.class) {
            return super.getListeners(clazz);
        }
        textListener = this.textListener;
        return AWTEventMulticaster.getListeners((EventListener)textListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 900) {
            return (this.eventMask & 0x400L) != 0L || this.textListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processTextEvent(TextEvent textEvent) {
        TextListener textListener = this.textListener;
        if (textListener != null) {
            int n = textEvent.getID();
            switch (n) {
                case 900: {
                    textListener.textValueChanged(textEvent);
                }
            }
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString() + ",text=" + this.getText();
        if (this.editable) {
            string = string + ",editable";
        }
        return string + ",selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd();
    }

    private void checkSystemClipboardAccess() {
        this.canAccessClipboard = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                this.canAccessClipboard = false;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selectionStart = textComponentPeer.getSelectionStart();
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "textL", this.textListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        this.text = this.text != null ? this.text : "";
        this.select(this.selectionStart, this.selectionEnd);
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("textL" == string) {
                this.addTextListener((TextListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        this.enableInputMethodsIfNecessary();
        this.checkSystemClipboardAccess();
    }

    int getIndexAtPoint(Point point) {
        return -1;
    }

    Rectangle getCharacterBounds(int n) {
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextComponent();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTTextComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleText,
    TextListener {
        private static final long serialVersionUID = 3631432373506317811L;
        private static final boolean NEXT = true;
        private static final boolean PREVIOUS = false;

        public AccessibleAWTTextComponent() {
            TextComponent.this.addTextListener(this);
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            Integer n = TextComponent.this.getCaretPosition();
            this.firePropertyChange("AccessibleText", null, n);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (TextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this;
        }

        @Override
        public int getIndexAtPoint(Point point) {
            return TextComponent.this.getIndexAtPoint(point);
        }

        @Override
        public Rectangle getCharacterBounds(int n) {
            return TextComponent.this.getCharacterBounds(n);
        }

        @Override
        public int getCharCount() {
            return TextComponent.this.getText().length();
        }

        @Override
        public int getCaretPosition() {
            return TextComponent.this.getCaretPosition();
        }

        @Override
        public AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        @Override
        public int getSelectionStart() {
            return TextComponent.this.getSelectionStart();
        }

        @Override
        public int getSelectionEnd() {
            return TextComponent.this.getSelectionEnd();
        }

        @Override
        public String getSelectedText() {
            String string = TextComponent.this.getSelectedText();
            if (string == null || string.equals("")) {
                return null;
            }
            return string;
        }

        @Override
        public String getAtIndex(int n, int n2) {
            if (n2 < 0 || n2 >= TextComponent.this.getText().length()) {
                return null;
            }
            switch (n) {
                case 1: {
                    return TextComponent.this.getText().substring(n2, n2 + 1);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n3);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n4);
                }
            }
            return null;
        }

        private int findWordLimit(int n, BreakIterator breakIterator, boolean bl, String string) {
            int n2;
            int n3 = bl ? breakIterator.following(n) : breakIterator.preceding(n);
            int n4 = n2 = bl ? breakIterator.next() : breakIterator.previous();
            while (n2 != -1) {
                for (int i = Math.min(n3, n2); i < Math.max(n3, n2); ++i) {
                    if (!Character.isLetter(string.charAt(i))) continue;
                    return n3;
                }
                n3 = n2;
                n2 = bl ? breakIterator.next() : breakIterator.previous();
            }
            return -1;
        }

        @Override
        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 >= TextComponent.this.getText().length()) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 + 1 >= TextComponent.this.getText().length()) {
                        return null;
                    }
                    return TextComponent.this.getText().substring(n2 + 1, n2 + 2);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = this.findWordLimit(n2, breakIterator, true, string);
                    if (n3 == -1 || n3 >= string.length()) {
                        return null;
                    }
                    int n4 = breakIterator.following(n3);
                    if (n4 == -1 || n4 >= string.length()) {
                        return null;
                    }
                    return string.substring(n3, n4);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    if (n5 == -1 || n5 >= string.length()) {
                        return null;
                    }
                    int n6 = breakIterator.following(n5);
                    if (n6 == -1 || n6 >= string.length()) {
                        return null;
                    }
                    return string.substring(n5, n6);
                }
            }
            return null;
        }

        @Override
        public String getBeforeIndex(int n, int n2) {
            if (n2 < 0 || n2 > TextComponent.this.getText().length() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 == 0) {
                        return null;
                    }
                    return TextComponent.this.getText().substring(n2 - 1, n2);
                }
                case 2: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n3 = this.findWordLimit(n2, breakIterator, false, string);
                    if (n3 == -1) {
                        return null;
                    }
                    int n4 = breakIterator.preceding(n3);
                    if (n4 == -1) {
                        return null;
                    }
                    return string.substring(n4, n3);
                }
                case 3: {
                    String string = TextComponent.this.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    n5 = breakIterator.previous();
                    int n6 = breakIterator.previous();
                    if (n6 == -1) {
                        return null;
                    }
                    return string.substring(n6, n5);
                }
            }
            return null;
        }
    }
}

