/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final String uiClassID = "DesktopPaneUI";
    transient DesktopManager desktopManager;
    private transient JInternalFrame selectedFrame = null;
    public static final int LIVE_DRAG_MODE = 0;
    public static final int OUTLINE_DRAG_MODE = 1;
    private int dragMode = 0;
    private boolean dragModeSet = false;
    private transient List<JInternalFrame> framesCache;
    private boolean componentOrderCheckingEnabled = true;
    private boolean componentOrderChanged = false;

    public JDesktopPane() {
        this.setUIProperty("opaque", Boolean.TRUE);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container container) {
                JInternalFrame jInternalFrame;
                JInternalFrame[] jInternalFrameArray = JDesktopPane.this.getAllFrames();
                Component component = null;
                JInternalFrame[] jInternalFrameArray2 = jInternalFrameArray;
                int n = jInternalFrameArray2.length;
                for (int i = 0; i < n && (component = (jInternalFrame = jInternalFrameArray2[i]).getFocusTraversalPolicy().getDefaultComponent(jInternalFrame)) == null; ++i) {
                }
                return component;
            }
        });
        this.updateUI();
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI desktopPaneUI) {
        super.setUI(desktopPaneUI);
    }

    public void setDragMode(int n) {
        int n2 = this.dragMode;
        this.dragMode = n;
        this.firePropertyChange("dragMode", n2, this.dragMode);
        this.dragModeSet = true;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        DesktopManager desktopManager2 = this.desktopManager;
        this.desktopManager = desktopManager;
        this.firePropertyChange("desktopManager", desktopManager2, this.desktopManager);
    }

    @Override
    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JInternalFrame[] getAllFrames() {
        return JDesktopPane.getAllFrames(this).toArray(new JInternalFrame[0]);
    }

    private static Collection<JInternalFrame> getAllFrames(Container container) {
        ArrayList<JInternalFrame> arrayList = new ArrayList<JInternalFrame>();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JInternalFrame) {
                arrayList.add((JInternalFrame)component);
                continue;
            }
            if (component instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
                if (jInternalFrame == null) continue;
                arrayList.add(jInternalFrame);
                continue;
            }
            if (!(component instanceof Container)) continue;
            arrayList.addAll(JDesktopPane.getAllFrames((Container)component));
        }
        return arrayList;
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        this.selectedFrame = jInternalFrame;
    }

    public JInternalFrame[] getAllFramesInLayer(int n) {
        Collection<JInternalFrame> collection = JDesktopPane.getAllFrames(this);
        Iterator<JInternalFrame> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLayer() == n) continue;
            iterator.remove();
        }
        return collection.toArray(new JInternalFrame[0]);
    }

    private List<JInternalFrame> getFrames() {
        TreeSet<ComponentPosition> treeSet = new TreeSet<ComponentPosition>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component instanceof JInternalFrame) {
                treeSet.add(new ComponentPosition((JInternalFrame)component, this.getLayer(component), i));
                continue;
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon)) continue;
            component = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
            treeSet.add(new ComponentPosition((JInternalFrame)component, this.getLayer(component), i));
        }
        ArrayList<JInternalFrame> arrayList = new ArrayList<JInternalFrame>(treeSet.size());
        for (ComponentPosition componentPosition : treeSet) {
            arrayList.add(componentPosition.component);
        }
        return arrayList;
    }

    private JInternalFrame getNextFrame(JInternalFrame jInternalFrame, boolean bl) {
        this.verifyFramesCache();
        if (jInternalFrame == null) {
            return this.getTopInternalFrame();
        }
        int n = this.framesCache.indexOf(jInternalFrame);
        if (n == -1 || this.framesCache.size() == 1) {
            return null;
        }
        if (bl) {
            if (++n == this.framesCache.size()) {
                n = 0;
            }
        } else if (--n == -1) {
            n = this.framesCache.size() - 1;
        }
        return this.framesCache.get(n);
    }

    JInternalFrame getNextFrame(JInternalFrame jInternalFrame) {
        return this.getNextFrame(jInternalFrame, true);
    }

    private JInternalFrame getTopInternalFrame() {
        if (this.framesCache.size() == 0) {
            return null;
        }
        return this.framesCache.get(0);
    }

    private void updateFramesCache() {
        this.framesCache = this.getFrames();
    }

    private void verifyFramesCache() {
        if (this.componentOrderChanged) {
            this.componentOrderChanged = false;
            this.updateFramesCache();
        }
    }

    public JInternalFrame selectFrame(boolean bl) {
        JInternalFrame jInternalFrame = this.getSelectedFrame();
        JInternalFrame jInternalFrame2 = this.getNextFrame(jInternalFrame, bl);
        if (jInternalFrame2 == null) {
            return null;
        }
        this.setComponentOrderCheckingEnabled(false);
        if (bl && jInternalFrame != null) {
            jInternalFrame.moveToBack();
        }
        try {
            jInternalFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setComponentOrderCheckingEnabled(true);
        return jInternalFrame2;
    }

    void setComponentOrderCheckingEnabled(boolean bl) {
        this.componentOrderCheckingEnabled = bl;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (this.componentOrderCheckingEnabled && (component instanceof JInternalFrame || component instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
    }

    @Override
    public void remove(int n) {
        Component component;
        if (this.componentOrderCheckingEnabled && ((component = this.getComponent(n)) instanceof JInternalFrame || component instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
        super.remove(n);
    }

    @Override
    public void removeAll() {
        if (this.componentOrderCheckingEnabled) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JInternalFrame) && !(component instanceof JInternalFrame.JDesktopIcon)) continue;
                this.componentOrderChanged = true;
                break;
            }
        }
        super.removeAll();
    }

    @Override
    public void setComponentZOrder(Component component, int n) {
        super.setComponentZOrder(component, n);
        if (this.componentOrderCheckingEnabled && (component instanceof JInternalFrame || component instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    void setUIProperty(String string, Object object) {
        if (string == "dragMode") {
            if (!this.dragModeSet) {
                this.setDragMode((Integer)object);
                this.dragModeSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    @Override
    protected String paramString() {
        String string = this.desktopManager != null ? this.desktopManager.toString() : "";
        return super.paramString() + ",desktopManager=" + string;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJDesktopPane() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }

    private static class ComponentPosition
    implements Comparable<ComponentPosition> {
        private final JInternalFrame component;
        private final int layer;
        private final int zOrder;

        ComponentPosition(JInternalFrame jInternalFrame, int n, int n2) {
            this.component = jInternalFrame;
            this.layer = n;
            this.zOrder = n2;
        }

        @Override
        public int compareTo(ComponentPosition componentPosition) {
            int n = componentPosition.layer - this.layer;
            if (n == 0) {
                return this.zOrder - componentPosition.zOrder;
            }
            return n;
        }
    }
}

