/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.annotations.Conversion;
import com.opensymphony.xwork2.conversion.annotations.ConversionRule;
import com.opensymphony.xwork2.conversion.annotations.ConversionType;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import com.opensymphony.xwork2.conversion.impl.XWorkBasicConverter;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.XWorkTypeConverterWrapper;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWorkConverter
extends DefaultTypeConverter {
    protected static final Logger LOG = LoggerFactory.getLogger(XWorkConverter.class);
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    public static final String LAST_BEAN_CLASS_ACCESSED = "last.bean.accessed";
    public static final String LAST_BEAN_PROPERTY_ACCESSED = "last.property.accessed";
    public static final String MESSAGE_INDEX_PATTERN = "\\[\\d+\\]\\.";
    public static final String MESSAGE_INDEX_BRACKET_PATTERN = "[\\[\\]\\.]";
    public static final String PERIOD = ".";
    public static final Pattern messageIndexPattern = Pattern.compile("\\[\\d+\\]\\.");
    protected HashMap<Class, Map<String, Object>> mappings = new HashMap();
    protected HashSet<Class> noMapping = new HashSet();
    protected HashMap<String, TypeConverter> defaultMappings = new HashMap();
    protected HashSet<String> unknownMappings = new HashSet();
    private TypeConverter defaultTypeConverter;
    private ObjectFactory objectFactory;

    protected XWorkConverter() {
    }

    @Inject
    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
        this.loadConversionProperties("xwork-default-conversion.properties");
        this.loadConversionProperties("xwork-conversion.properties");
    }

    @Inject
    public void setDefaultTypeConverter(XWorkBasicConverter conv) {
        this.defaultTypeConverter = conv;
    }

    public static String getConversionErrorMessage(String propertyName, ValueStack stack) {
        String defaultMessage = LocalizedTextUtil.findDefaultText("xwork.default.invalid.fieldvalue", ActionContext.getContext().getLocale(), new Object[]{propertyName});
        List<String> indexValues = XWorkConverter.getIndexValues(propertyName);
        propertyName = XWorkConverter.removeAllIndexesInProperyName(propertyName);
        String getTextExpression = "getText('invalid.fieldvalue." + propertyName + "','" + defaultMessage + "')";
        String message = (String)stack.findValue(getTextExpression);
        message = message == null ? defaultMessage : MessageFormat.format(message, indexValues.toArray());
        return message;
    }

    private static String removeAllIndexesInProperyName(String propertyName) {
        return propertyName.replaceAll(MESSAGE_INDEX_PATTERN, PERIOD);
    }

    private static List<String> getIndexValues(String propertyName) {
        Matcher matcher = messageIndexPattern.matcher(propertyName);
        ArrayList<String> indexes = new ArrayList<String>();
        while (matcher.find()) {
            Integer index = new Integer(matcher.group().replaceAll(MESSAGE_INDEX_BRACKET_PATTERN, "")) + 1;
            indexes.add(Integer.toString(index));
        }
        return indexes;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        return className.replace('.', '/') + "-conversion.properties";
    }

    @Override
    public Object convertValue(Map<String, Object> map, Object o, Class aClass) {
        return this.convertValue(map, null, null, null, o, aClass);
    }

    @Override
    public Object convertValue(Map<String, Object> context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (value != null && toClass == value.getClass()) {
            return value;
        }
        if (target != null) {
            Class clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            tc = (TypeConverter)this.getConverter(clazz, property);
            if (LOG.isDebugEnabled()) {
                LOG.debug("field-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc), new String[0]);
            }
        }
        if (tc == null && context != null) {
            Object lastPropertyPath = context.get("current.property.path");
            Class clazz = (Class)context.get(LAST_BEAN_CLASS_ACCESSED);
            if (lastPropertyPath != null && clazz != null) {
                String path = lastPropertyPath + PERIOD + property;
                tc = (TypeConverter)this.getConverter(clazz, path);
            }
        }
        if (tc == null) {
            tc = toClass.equals(String.class) && value != null && !value.getClass().equals(String.class) && !value.getClass().equals(String[].class) ? this.lookup(value.getClass()) : this.lookup(toClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("global-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc), new String[0]);
            }
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable to convert value using type converter [#0]", e, tc.getClass().getName());
                }
                this.handleConversionException(context, property, value, target);
                return TypeConverter.NO_CONVERSION_POSSIBLE;
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("falling back to default type converter [" + this.defaultTypeConverter + "]", new String[0]);
                }
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable to convert value using type converter [#0]", e, this.defaultTypeConverter.getClass().getName());
                }
                this.handleConversionException(context, property, value, target);
                return TypeConverter.NO_CONVERSION_POSSIBLE;
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("falling back to Ognl's default type conversion", new String[0]);
            }
            return super.convertValue(value, toClass);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to convert value using type converter [#0]", e, super.getClass().getName());
            }
            this.handleConversionException(context, property, value, target);
            return TypeConverter.NO_CONVERSION_POSSIBLE;
        }
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className) && !this.defaultMappings.containsKey(className)) {
            return null;
        }
        TypeConverter result = this.defaultMappings.get(className);
        if (result == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Property: " + property, new String[0]);
            LOG.debug("Class: " + clazz.getName(), new String[0]);
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (property != null && !this.noMapping.contains(clazz)) {
                try {
                    Map<String, Object> mapping = this.mappings.get(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    Object converter = mapping.get(property);
                    if (LOG.isDebugEnabled() && converter == null) {
                        LOG.debug("converter is null for property " + property + ". Mapping size: " + mapping.size(), new String[0]);
                        for (String next : mapping.keySet()) {
                            LOG.debug(next + ":" + mapping.get(next), new String[0]);
                        }
                    }
                    return converter;
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz);
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map<String, Object> context, String property, Object value, Object object) {
        if (context != null && Boolean.TRUE.equals(context.get(REPORT_CONVERSION_ERRORS))) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork2.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork2.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    public synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
        if (this.unknownMappings.contains(className)) {
            this.unknownMappings.remove(className);
        }
    }

    public synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    private Object[] getClassProperty(Map<String, Object> context) {
        return (Object[])context.get("__link");
    }

    protected void addConverterMapping(Map<String, Object> mapping, Class clazz) {
        Method[] methods;
        Annotation[] annotations;
        try {
            String converterFilename = XWorkConverter.buildConverterFilename(clazz);
            InputStream is = FileManager.loadFile(converterFilename, clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing conversion file [" + converterFilename + "] [class=" + clazz + "]", new String[0]);
                }
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> i$ = prop.entrySet().iterator();
                while (i$.hasNext() && !mapping.containsKey(key = (String)(entry = i$.next()).getKey())) {
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as String]", new String[0]);
                        }
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith(CONVERSION_COLLECTION_PREFIX))) {
                        TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]", new String[0]);
                        }
                        mapping.put(key, _typeConverter);
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]", new String[0]);
                            }
                            mapping.put(key, _typeConverter);
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as Class " + converterClass + "]", new String[0]);
                        }
                        mapping.put(key, converterClass);
                        continue;
                    }
                    Class<?> _c = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as Class " + _c + "]", new String[0]);
                    }
                    mapping.put(key, _c);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Problem loading properties for " + clazz.getName(), ex, new String[0]);
        }
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            TypeConversion tc;
            String key;
            if (!(annotation instanceof Conversion)) continue;
            Conversion conversion = (Conversion)annotation;
            Annotation[] arr$ = conversion.conversions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !mapping.containsKey(key = (tc = arr$[i$]).key()); ++i$) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(key + ":" + key, new String[0]);
                }
                if (key == null) continue;
                try {
                    if (tc.type() == ConversionType.APPLICATION) {
                        this.defaultMappings.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals((Object)ConversionRule.KEY_PROPERTY) || tc.rule().toString().equals((Object)ConversionRule.CREATE_IF_NULL)) {
                        mapping.put(key, tc.value());
                        continue;
                    }
                    if (!tc.rule().toString().equals(ConversionRule.ELEMENT.toString()) || tc.rule().toString().equals(ConversionRule.KEY.toString()) || tc.rule().toString().equals(ConversionRule.COLLECTION.toString())) {
                        mapping.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals(ConversionRule.KEY.toString())) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass(tc.converter());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Converter class: " + converterClass, new String[0]);
                        }
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            mapping.put(key, this.createTypeConverter(tc.converter()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Object placed in mapping for key " + key + " is " + mapping.get(key), new String[0]);
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass(tc.converter()));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        block9: for (Method method : methods = clazz.getMethods()) {
            annotations = method.getAnnotations();
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof TypeConversion)) continue;
                TypeConversion tc = (TypeConversion)annotation;
                String key = tc.key();
                if (mapping.containsKey(key)) continue block9;
                if (key != null && key.length() == 0) {
                    key = AnnotationUtils.resolvePropertyName(method);
                    LOG.debug("key from method name... " + key + " - " + method.getName(), new String[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(key + ":" + key, new String[0]);
                }
                if (key == null) continue;
                try {
                    if (tc.type() == ConversionType.APPLICATION) {
                        this.defaultMappings.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals((Object)ConversionRule.KEY_PROPERTY)) {
                        mapping.put(key, tc.value());
                        continue;
                    }
                    if (!tc.rule().toString().equals(ConversionRule.ELEMENT.toString()) || tc.rule().toString().equals(ConversionRule.KEY.toString()) || tc.rule().toString().equals(ConversionRule.COLLECTION.toString())) {
                        mapping.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals(ConversionRule.KEY.toString())) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass(tc.converter());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Converter class: " + converterClass, new String[0]);
                        }
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            mapping.put(key, this.createTypeConverter(tc.converter()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Object placed in mapping for key " + key + " is " + mapping.get(key), new String[0]);
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass(tc.converter()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected Map<String, Object> buildConverterMapping(Class clazz) throws Exception {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Class curClazz = clazz;
        while (!curClazz.equals(Object.class)) {
            Class<?>[] interfaces;
            this.addConverterMapping(mapping, curClazz);
            for (Class<?> anInterface : interfaces = curClazz.getInterfaces()) {
                this.addConverterMapping(mapping, anInterface);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.mappings.put(clazz, mapping);
        } else {
            this.noMapping.add(clazz);
        }
        return mapping;
    }

    private Map<String, Object> conditionalReload(Class clazz, Map<String, Object> oldValues) throws Exception {
        Map<String, Object> mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading(XWorkConverter.buildConverterFilename(clazz), clazz)) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    TypeConverter createTypeConverter(String className) throws Exception {
        Object obj = this.objectFactory.buildBean(className, null);
        if (obj instanceof TypeConverter) {
            return (TypeConverter)obj;
        }
        if (obj instanceof ognl.TypeConverter) {
            return new XWorkTypeConverterWrapper((ognl.TypeConverter)obj);
        }
        throw new IllegalArgumentException("Type converter class " + obj.getClass() + " doesn't implement com.opensymphony.xwork2.conversion.TypeConverter");
    }

    public void loadConversionProperties(String propsName) {
        this.loadConversionProperties(propsName, false);
    }

    public void loadConversionProperties(String propsName, boolean require) {
        try {
            Iterator<URL> resources = ClassLoaderUtil.getResources(propsName, this.getClass(), true);
            while (resources.hasNext()) {
                URL url = resources.next();
                Properties props = new Properties();
                props.load(url.openStream());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing conversion file [" + propsName + "]", new String[0]);
                }
                Iterator<Map.Entry<Object, Object>> i$ = props.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<Object, Object> o;
                    Map.Entry<Object, Object> entry = o = i$.next();
                    String key = (String)entry.getKey();
                    try {
                        TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t" + key + ":" + entry.getValue() + " [treated as TypeConverter " + _typeConverter + "]", new String[0]);
                        }
                        this.defaultMappings.put(key, _typeConverter);
                    }
                    catch (Exception e) {
                        LOG.error("Conversion registration error", e, new String[0]);
                    }
                }
            }
        }
        catch (IOException ex) {
            if (require) {
                throw new XWorkException("Cannot load conversion properties file: " + propsName, ex);
            }
            LOG.debug("Cannot load conversion properties file: " + propsName, ex, new String[0]);
        }
    }

    TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = this.defaultMappings.get(clazz.getName())) == null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                if (!this.defaultMappings.containsKey(anInterface.getName())) continue;
                result = this.defaultMappings.get(anInterface.getName());
                break;
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }
}

