/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;

public class DHG14
extends KeyExchange {
    static final byte[] g = new byte[]{2};
    static final byte[] p;
    private static final int SSH_MSG_KEXDH_INIT = 30;
    private static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int RSA = 0;
    static final int DSS = 1;
    private int type = 0;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    byte[] e;
    private Buffer buf;
    private Packet packet;

    static {
        byte[] byArray = new byte[257];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -55;
        byArray[10] = 15;
        byArray[11] = -38;
        byArray[12] = -94;
        byArray[13] = 33;
        byArray[14] = 104;
        byArray[15] = -62;
        byArray[16] = 52;
        byArray[17] = -60;
        byArray[18] = -58;
        byArray[19] = 98;
        byArray[20] = -117;
        byArray[21] = -128;
        byArray[22] = -36;
        byArray[23] = 28;
        byArray[24] = -47;
        byArray[25] = 41;
        byArray[26] = 2;
        byArray[27] = 78;
        byArray[28] = 8;
        byArray[29] = -118;
        byArray[30] = 103;
        byArray[31] = -52;
        byArray[32] = 116;
        byArray[33] = 2;
        byArray[34] = 11;
        byArray[35] = -66;
        byArray[36] = -90;
        byArray[37] = 59;
        byArray[38] = 19;
        byArray[39] = -101;
        byArray[40] = 34;
        byArray[41] = 81;
        byArray[42] = 74;
        byArray[43] = 8;
        byArray[44] = 121;
        byArray[45] = -114;
        byArray[46] = 52;
        byArray[47] = 4;
        byArray[48] = -35;
        byArray[49] = -17;
        byArray[50] = -107;
        byArray[51] = 25;
        byArray[52] = -77;
        byArray[53] = -51;
        byArray[54] = 58;
        byArray[55] = 67;
        byArray[56] = 27;
        byArray[57] = 48;
        byArray[58] = 43;
        byArray[59] = 10;
        byArray[60] = 109;
        byArray[61] = -14;
        byArray[62] = 95;
        byArray[63] = 20;
        byArray[64] = 55;
        byArray[65] = 79;
        byArray[66] = -31;
        byArray[67] = 53;
        byArray[68] = 109;
        byArray[69] = 109;
        byArray[70] = 81;
        byArray[71] = -62;
        byArray[72] = 69;
        byArray[73] = -28;
        byArray[74] = -123;
        byArray[75] = -75;
        byArray[76] = 118;
        byArray[77] = 98;
        byArray[78] = 94;
        byArray[79] = 126;
        byArray[80] = -58;
        byArray[81] = -12;
        byArray[82] = 76;
        byArray[83] = 66;
        byArray[84] = -23;
        byArray[85] = -90;
        byArray[86] = 55;
        byArray[87] = -19;
        byArray[88] = 107;
        byArray[89] = 11;
        byArray[90] = -1;
        byArray[91] = 92;
        byArray[92] = -74;
        byArray[93] = -12;
        byArray[94] = 6;
        byArray[95] = -73;
        byArray[96] = -19;
        byArray[97] = -18;
        byArray[98] = 56;
        byArray[99] = 107;
        byArray[100] = -5;
        byArray[101] = 90;
        byArray[102] = -119;
        byArray[103] = -97;
        byArray[104] = -91;
        byArray[105] = -82;
        byArray[106] = -97;
        byArray[107] = 36;
        byArray[108] = 17;
        byArray[109] = 124;
        byArray[110] = 75;
        byArray[111] = 31;
        byArray[112] = -26;
        byArray[113] = 73;
        byArray[114] = 40;
        byArray[115] = 102;
        byArray[116] = 81;
        byArray[117] = -20;
        byArray[118] = -28;
        byArray[119] = 91;
        byArray[120] = 61;
        byArray[121] = -62;
        byArray[123] = 124;
        byArray[124] = -72;
        byArray[125] = -95;
        byArray[126] = 99;
        byArray[127] = -65;
        byArray[128] = 5;
        byArray[129] = -104;
        byArray[130] = -38;
        byArray[131] = 72;
        byArray[132] = 54;
        byArray[133] = 28;
        byArray[134] = 85;
        byArray[135] = -45;
        byArray[136] = -102;
        byArray[137] = 105;
        byArray[138] = 22;
        byArray[139] = 63;
        byArray[140] = -88;
        byArray[141] = -3;
        byArray[142] = 36;
        byArray[143] = -49;
        byArray[144] = 95;
        byArray[145] = -125;
        byArray[146] = 101;
        byArray[147] = 93;
        byArray[148] = 35;
        byArray[149] = -36;
        byArray[150] = -93;
        byArray[151] = -83;
        byArray[152] = -106;
        byArray[153] = 28;
        byArray[154] = 98;
        byArray[155] = -13;
        byArray[156] = 86;
        byArray[157] = 32;
        byArray[158] = -123;
        byArray[159] = 82;
        byArray[160] = -69;
        byArray[161] = -98;
        byArray[162] = -43;
        byArray[163] = 41;
        byArray[164] = 7;
        byArray[165] = 112;
        byArray[166] = -106;
        byArray[167] = -106;
        byArray[168] = 109;
        byArray[169] = 103;
        byArray[170] = 12;
        byArray[171] = 53;
        byArray[172] = 78;
        byArray[173] = 74;
        byArray[174] = -68;
        byArray[175] = -104;
        byArray[176] = 4;
        byArray[177] = -15;
        byArray[178] = 116;
        byArray[179] = 108;
        byArray[180] = 8;
        byArray[181] = -54;
        byArray[182] = 24;
        byArray[183] = 33;
        byArray[184] = 124;
        byArray[185] = 50;
        byArray[186] = -112;
        byArray[187] = 94;
        byArray[188] = 70;
        byArray[189] = 46;
        byArray[190] = 54;
        byArray[191] = -50;
        byArray[192] = 59;
        byArray[193] = -29;
        byArray[194] = -98;
        byArray[195] = 119;
        byArray[196] = 44;
        byArray[197] = 24;
        byArray[198] = 14;
        byArray[199] = -122;
        byArray[200] = 3;
        byArray[201] = -101;
        byArray[202] = 39;
        byArray[203] = -125;
        byArray[204] = -94;
        byArray[205] = -20;
        byArray[206] = 7;
        byArray[207] = -94;
        byArray[208] = -113;
        byArray[209] = -75;
        byArray[210] = -59;
        byArray[211] = 93;
        byArray[212] = -16;
        byArray[213] = 111;
        byArray[214] = 76;
        byArray[215] = 82;
        byArray[216] = -55;
        byArray[217] = -34;
        byArray[218] = 43;
        byArray[219] = -53;
        byArray[220] = -10;
        byArray[221] = -107;
        byArray[222] = 88;
        byArray[223] = 23;
        byArray[224] = 24;
        byArray[225] = 57;
        byArray[226] = -107;
        byArray[227] = 73;
        byArray[228] = 124;
        byArray[229] = -22;
        byArray[230] = -107;
        byArray[231] = 106;
        byArray[232] = -27;
        byArray[233] = 21;
        byArray[234] = -46;
        byArray[235] = 38;
        byArray[236] = 24;
        byArray[237] = -104;
        byArray[238] = -6;
        byArray[239] = 5;
        byArray[240] = 16;
        byArray[241] = 21;
        byArray[242] = 114;
        byArray[243] = -114;
        byArray[244] = 90;
        byArray[245] = -118;
        byArray[246] = -84;
        byArray[247] = -86;
        byArray[248] = 104;
        byArray[249] = -1;
        byArray[250] = -1;
        byArray[251] = -1;
        byArray[252] = -1;
        byArray[253] = -1;
        byArray[254] = -1;
        byArray[255] = -1;
        byArray[256] = -1;
        p = byArray;
    }

    @Override
    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        Class<?> c;
        this.session = session;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        try {
            c = Class.forName(session.getConfig("sha-1"));
            this.sha = (HASH)c.newInstance();
            this.sha.init();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        c = Class.forName(session.getConfig("dh"));
        this.dh = (DH)c.newInstance();
        this.dh.init();
        this.dh.setP(p);
        this.dh.setG(g);
        this.e = this.dh.getE();
        this.packet.reset();
        this.buf.putByte((byte)30);
        this.buf.putMPInt(this.e);
        if (V_S == null) {
            return;
        }
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEXDH_INIT sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEXDH_REPLY");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                int j = _buf.getInt();
                j = _buf.getByte();
                j = _buf.getByte();
                if (j != 31) {
                    System.err.println("type: must be 31 " + j);
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] f = _buf.getMPInt();
                byte[] sig_of_H = _buf.getString();
                this.dh.setF(f);
                this.K = this.normalize(this.dh.getK());
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(f);
                this.buf.putMPInt(this.K);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.H = this.sha.digest();
                int i = 0;
                j = 0;
                j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                String alg = Util.byte2str(this.K_S, i, j);
                i += j;
                boolean result = false;
                if (alg.equals("ssh-rsa")) {
                    this.type = 0;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    byte[] tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] ee = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] n = tmp;
                    SignatureRSA sig = null;
                    try {
                        Class<?> c = Class.forName(this.session.getConfig("signature.rsa"));
                        sig = (SignatureRSA)c.newInstance();
                        sig.init();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                    sig.setPubKey(ee, n);
                    sig.update(this.H);
                    result = sig.verify(sig_of_H);
                    if (JSch.getLogger().isEnabled(1)) {
                        JSch.getLogger().log(1, "ssh_rsa_verify: signature " + result);
                    }
                } else if (alg.equals("ssh-dss")) {
                    byte[] q = null;
                    this.type = 1;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    byte[] tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] p = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    q = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    byte[] g = tmp;
                    j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                    tmp = new byte[j];
                    System.arraycopy(this.K_S, i, tmp, 0, j);
                    i += j;
                    f = tmp;
                    SignatureDSA sig = null;
                    try {
                        Class<?> c = Class.forName(this.session.getConfig("signature.dss"));
                        sig = (SignatureDSA)c.newInstance();
                        sig.init();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                    sig.setPubKey(f, p, q, g);
                    sig.update(this.H);
                    result = sig.verify(sig_of_H);
                    if (JSch.getLogger().isEnabled(1)) {
                        JSch.getLogger().log(1, "ssh_dss_verify: signature " + result);
                    }
                } else {
                    System.err.println("unknown alg");
                }
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    @Override
    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        return "RSA";
    }

    @Override
    public int getState() {
        return this.state;
    }
}

