/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jsch) {
        this.jsch = jsch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector getIdentities() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.identities.size()) {
            v.addElement(this.identities.elementAt(i));
            ++i;
        }
        return v;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] identity) {
        try {
            IdentityFile _identity = IdentityFile.newInstance("from remote:", identity, null, this.jsch);
            this.identities.addElement(_identity);
            return true;
        }
        catch (JSchException e) {
            return false;
        }
    }

    synchronized void remove(Identity identity) {
        this.identities.removeElement(identity);
    }

    @Override
    public synchronized boolean remove(byte[] blob) {
        if (blob == null) {
            return false;
        }
        int i = 0;
        while (i < this.identities.size()) {
            Identity _identity = (Identity)this.identities.elementAt(i);
            byte[] _blob = _identity.getPublicKeyBlob();
            if (_blob != null && Util.array_equals(blob, _blob)) {
                this.identities.removeElement(_identity);
                _identity.clear();
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        int i = 0;
        while (i < this.identities.size()) {
            Identity identity = (Identity)this.identities.elementAt(i);
            identity.clear();
            ++i;
        }
        this.identities.removeAllElements();
    }
}

