/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class OpenSSHConfig
implements ConfigRepository {
    private final Hashtable config = new Hashtable();
    private final Vector hosts = new Vector();
    private static final Hashtable keymap = new Hashtable();

    static {
        keymap.put("kex", "KexAlgorithms");
        keymap.put("server_host_key", "HostKeyAlgorithms");
        keymap.put("cipher.c2s", "Ciphers");
        keymap.put("cipher.s2c", "Ciphers");
        keymap.put("mac.c2s", "Macs");
        keymap.put("mac.s2c", "Macs");
        keymap.put("compression.s2c", "Compression");
        keymap.put("compression.c2s", "Compression");
        keymap.put("compression_level", "CompressionLevel");
        keymap.put("MaxAuthTries", "NumberOfPasswordPrompts");
    }

    public static OpenSSHConfig parse(String conf) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(Util.str2byte(conf));
        try {
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(in);
            return openSSHConfig;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static OpenSSHConfig parseFile(String file) throws IOException {
        byte[] conf = Util.fromFile(file);
        ByteArrayInputStream in = new ByteArrayInputStream(conf);
        try {
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(in);
            return openSSHConfig;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    OpenSSHConfig(InputStream in) throws IOException {
        this._parse(in);
    }

    private void _parse(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String host = "";
        Vector<String[]> kv = new Vector<String[]>();
        String l = null;
        while ((l = br.readLine()) != null) {
            if ((l = l.trim()).length() == 0 || l.startsWith("#")) continue;
            String[] key_value = l.split("[= \t]", 2);
            int i = 0;
            while (i < key_value.length) {
                key_value[i] = key_value[i].trim();
                ++i;
            }
            if (key_value.length <= 1) continue;
            if (key_value[0].equals("Host")) {
                this.config.put(host, kv);
                this.hosts.addElement(host);
                host = key_value[1];
                kv = new Vector();
                continue;
            }
            kv.addElement(key_value);
        }
        this.config.put(host, kv);
        this.hosts.addElement(host);
    }

    @Override
    public ConfigRepository.Config getConfig(String host) {
        return new MyConfig(host);
    }

    class MyConfig
    implements ConfigRepository.Config {
        private String host;
        private Vector _configs = new Vector();

        MyConfig(String host) {
            this.host = host;
            this._configs.addElement(OpenSSHConfig.this.config.get(""));
            byte[] _host = Util.str2byte(host);
            if (OpenSSHConfig.this.hosts.size() > 1) {
                int i = 1;
                while (i < OpenSSHConfig.this.hosts.size()) {
                    String[] patterns = ((String)OpenSSHConfig.this.hosts.elementAt(i)).split("[ \t]");
                    int j = 0;
                    while (j < patterns.length) {
                        boolean negate = false;
                        String foo = patterns[j].trim();
                        if (foo.startsWith("!")) {
                            negate = true;
                            foo = foo.substring(1).trim();
                        }
                        if (Util.glob(Util.str2byte(foo), _host)) {
                            if (!negate) {
                                this._configs.addElement(OpenSSHConfig.this.config.get((String)OpenSSHConfig.this.hosts.elementAt(i)));
                            }
                        } else if (negate) {
                            this._configs.addElement(OpenSSHConfig.this.config.get((String)OpenSSHConfig.this.hosts.elementAt(i)));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }

        private String find(String key) {
            if (keymap.get(key) != null) {
                key = (String)keymap.get(key);
            }
            String value = null;
            int i = 0;
            while (i < this._configs.size()) {
                Vector v = (Vector)this._configs.elementAt(i);
                int j = 0;
                while (j < v.size()) {
                    String[] kv = (String[])v.elementAt(j);
                    if (kv[0].equals(key)) {
                        value = kv[1];
                        break;
                    }
                    ++j;
                }
                if (value != null) break;
                ++i;
            }
            return value;
        }

        private String[] multiFind(String key) {
            Vector<String> value = new Vector<String>();
            int i = 0;
            while (i < this._configs.size()) {
                Vector v = (Vector)this._configs.elementAt(i);
                int j = 0;
                while (j < v.size()) {
                    String foo;
                    String[] kv = (String[])v.elementAt(j);
                    if (kv[0].equals(key) && (foo = kv[1]) != null) {
                        value.remove(foo);
                        value.addElement(foo);
                    }
                    ++j;
                }
                ++i;
            }
            String[] result = new String[value.size()];
            value.toArray(result);
            return result;
        }

        @Override
        public String getHostname() {
            return this.find("Hostname");
        }

        @Override
        public String getUser() {
            return this.find("User");
        }

        @Override
        public int getPort() {
            String foo = this.find("Port");
            int port = -1;
            try {
                port = Integer.parseInt(foo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return port;
        }

        @Override
        public String getValue(String key) {
            if (key.equals("compression.s2c") || key.equals("compression.c2s")) {
                String foo = this.find(key);
                if (foo == null || foo.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.find(key);
        }

        @Override
        public String[] getValues(String key) {
            return this.multiFind(key);
        }
    }
}

