/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.sshxcute.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Logger {
    private static Logger instance = null;
    private static String pathToFiles;
    private static String instanceName;
    private static String logFile;
    private static String dbgFile;
    private static Map<String, String> classNames;
    private static int classCount;
    private static int logThreshold;
    public static final int DIVIDER = 0;
    public static final int DEEP_DBUG = 1;
    public static final int MID_DBUG = 2;
    public static final int LITE_DBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final int OFF = 99;

    static {
        logThreshold = 4;
    }

    public static Logger getLogger() {
        try {
            instance = new Logger(Logger.getCaller());
        }
        catch (Exception e) {
            return null;
        }
        instance.setThreshold(4);
        return instance;
    }

    public void setThreshold(int newThreshold) {
        this.setThreshold(Logger.getCaller(), newThreshold);
    }

    public void setThreshold(String caller, int newThreshold) {
        DateCalendar d = new DateCalendar();
        logThreshold = newThreshold;
    }

    public String getLogpath() {
        return pathToFiles;
    }

    public void close() {
        if (logThreshold < 4) {
            this.printDbg("----Classes----------------------", true);
            Set<String> keys = classNames.keySet();
            for (String k : keys) {
                String v = classNames.get(k);
                this.printDbg(String.valueOf(v) + " = " + k, true);
            }
        }
    }

    public void clearLogger() {
        this.clearLogger(Logger.getCaller());
    }

    public void clearLogger(String caller) {
        DateCalendar d = new DateCalendar();
        String outp = "\n--------------- [" + d.toTimeStamp() + ", " + caller + "] --- CLEARED ----------\n";
        this.printLog(outp, false);
        if (logThreshold < 4) {
            this.printDbg(outp, false);
        } else {
            File f = new File(dbgFile);
            f.delete();
        }
    }

    public void putMsg(int level, String msg) {
        if (level == 7) {
            DateCalendar d = new DateCalendar();
            String t = String.valueOf(Logger.levelToString(level)) + ":       ";
            String outp = "[" + d.timeString() + "] " + t.substring(0, 9) + msg;
            this.printLog(outp, true);
            if (logThreshold < 4) {
                this.printDbg(outp, true);
            }
        } else if (level >= logThreshold || level == 0) {
            this.putMsg(Logger.getCaller(), level, msg);
        }
    }

    public void putMsg(String caller, int level, String msg) {
        if (level >= logThreshold || level == 0) {
            DateCalendar d = new DateCalendar();
            if (level == 0) {
                String outp = "\n=============== [" + d.toTimeStamp() + ", " + caller + "] ====================\n";
                this.printLog(outp, true);
                if (logThreshold < 4) {
                    this.printDbg(outp, true);
                }
            } else if (level < 4) {
                caller = this.shortHandCaller(caller);
                String outp = "[" + d.timeString() + " - " + caller + "] " + msg;
                this.printDbg(outp, true);
            } else {
                String t = String.valueOf(Logger.levelToString(level)) + ":       ";
                String outp = "[" + d.timeString() + "] " + t.substring(0, 9) + msg;
                this.printLog(outp, true);
                if (level != 7) {
                    System.out.println(msg);
                    System.out.flush();
                }
            }
        }
    }

    public static synchronized String getCaller() {
        String[] callStack = Logger.getCallStackAsStringArray();
        int i = 0;
        while (i < callStack.length) {
            if (callStack[i].contains("getCaller:")) {
                return callStack[i + 2];
            }
            ++i;
        }
        return callStack[callStack.length - 1];
    }

    public static int levelFmString(String level) {
        int lvl = level.equals("DEEP_DBUG") ? 1 : (level.equals("MID_DBUG") ? 2 : (level.equals("LITE_DBUG") ? 3 : (level.equals("INFO") ? 4 : (level.equals("WARN") ? 5 : (level.equals("FATAL") ? 7 : (level.equals("OFF") ? 99 : 6))))));
        return lvl;
    }

    public static String levelToString(int level) {
        String result;
        switch (level) {
            case 1: {
                result = "DEEP_DBUG";
                break;
            }
            case 2: {
                result = "MID_DBUG";
                break;
            }
            case 3: {
                result = "LITE_DBUG";
                break;
            }
            case 4: {
                result = "INFO";
                break;
            }
            case 5: {
                result = "WARN";
                break;
            }
            case 7: {
                result = "FATAL";
                break;
            }
            case 99: {
                result = "OFF";
                break;
            }
            default: {
                result = "ERROR:   ";
            }
        }
        return result;
    }

    private Logger(String caller) throws Exception {
        if (instance != null) {
            instance.close();
            instance = null;
        }
        classNames = new HashMap<String, String>();
        classCount = 0;
        instanceName = "sshxcute";
        pathToFiles = System.getProperty("user.dir");
        logFile = String.valueOf(pathToFiles) + "/" + "sshxcute" + ".log";
        dbgFile = String.valueOf(pathToFiles) + "/" + "sshxcute" + ".dbg";
        this.putMsg(caller, 0, "");
    }

    private String shortHandCaller(String inp) {
        String shortName;
        String prefix;
        int pos = inp.lastIndexOf("/");
        if (pos == -1) {
            pos = inp.lastIndexOf(".");
            prefix = inp.substring(0, pos);
            pos = prefix.lastIndexOf(".");
        }
        if ((shortName = classNames.get(prefix = inp.substring(0, pos))) == null) {
            shortName = "#" + ++classCount;
            classNames.put(prefix, shortName);
        }
        String caller = String.valueOf(shortName) + "/" + inp.substring(pos + 1);
        return caller;
    }

    private synchronized void printLog(String msg, boolean append) {
        try {
            FileWriter w = new FileWriter(logFile, append);
            w.write(String.valueOf(msg) + "\n");
            w.flush();
            w.close();
        }
        catch (IOException e) {
            System.out.println("IOException in Logger, message: " + e.getMessage());
            System.out.println(msg);
        }
    }

    private synchronized void printDbg(String msg, boolean append) {
        try {
            FileWriter w = new FileWriter(dbgFile, append);
            w.write(String.valueOf(msg) + "\n");
            w.flush();
            w.close();
        }
        catch (IOException e) {
            System.out.println("IOException on debug message: " + e.getMessage());
            System.out.println("DEBUG: " + msg);
        }
    }

    private static synchronized String[] getCallStackAsStringArray() {
        ArrayList<String> list = new ArrayList<String>();
        String[] array = new String[1];
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stackTraceElements.length) {
            StackTraceElement element = stackTraceElements[i];
            String classname = element.getClassName();
            String methodName = element.getMethodName();
            int lineNumber = element.getLineNumber();
            String entry = String.valueOf(classname) + "." + methodName + ":" + lineNumber;
            list.add(entry);
            ++i;
        }
        return list.toArray(array);
    }

    private class DateCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -98734585L;

        @Override
        public int get(int field) {
            int result = field == 2 ? super.get(field) + 1 : super.get(field);
            return result;
        }

        @Override
        public String toString() {
            int year = this.get(1);
            int month = this.get(2);
            int day = this.get(5);
            int hour24 = this.get(11);
            int min = this.get(12);
            int sec = this.get(13);
            String datetimeString = String.valueOf(String.valueOf(year)) + "." + String.valueOf(month) + "." + String.valueOf(day) + "." + String.valueOf(hour24) + "." + String.valueOf(min) + "." + String.valueOf(sec);
            return datetimeString;
        }

        public String timeString() {
            return this.toTimeStamp().substring(11);
        }

        public String toTimeStamp() {
            String year = String.valueOf(this.get(1));
            String month = String.valueOf(this.get(2));
            String day = String.valueOf(this.get(5));
            String hour24 = String.valueOf(this.get(11));
            String min = String.valueOf(this.get(12));
            String sec = String.valueOf(this.get(13));
            if (month.length() == 1) {
                month = "0" + month;
            }
            if (day.length() == 1) {
                day = "0" + day;
            }
            if (hour24.length() == 1) {
                hour24 = "0" + hour24;
            }
            if (min.length() == 1) {
                min = "0" + min;
            }
            if (sec.length() == 1) {
                sec = "0" + sec;
            }
            String datetimeString = String.valueOf(year) + "/" + month + "/" + day + " " + hour24 + ":" + min + ":" + sec;
            return datetimeString;
        }
    }
}

