/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.sshxcute.core;

import cn.security.security.service.mon.utils.DefaultUserInfo;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Properties;
import net.neoremind.sshxcute.core.ConnBean;
import net.neoremind.sshxcute.core.Result;
import net.neoremind.sshxcute.core.SSHExecUtil;
import net.neoremind.sshxcute.core.SysConfigOption;
import net.neoremind.sshxcute.task.CustomTask;
import org.apache.commons.io.FileUtils;

public class SSH {
    private Session session;
    private ConnBean conn;
    private JSch jsch;

    public SSH(ConnBean conn) {
        try {
            this.jsch = new JSch();
            this.conn = conn;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public Boolean connect() {
        try {
            this.session = this.jsch.getSession(this.conn.getUser(), this.conn.getHost(), this.conn.getPort());
            this.session.setPassword(this.conn.getPassword());
            DefaultUserInfo defaultUserInfo = new DefaultUserInfo(this.conn.getPassword());
            this.session.setUserInfo((UserInfo)defaultUserInfo);
            Properties prop = new Properties();
            prop.setProperty("StrictHostKeyChecking", "no");
            this.session.setConfig(prop);
            this.session.connect(3600000);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void disconnectSession() {
        try {
            this.session.disconnectEX();
            this.session = null;
        }
        catch (Exception e) {
            return;
        }
    }

    public String shell(List<String> cmds, String outputFileName, List<String> prompts, int waitseconds) throws Exception {
        ChannelShell channelShell = (ChannelShell)this.session.openChannel("shell");
        channelShell.setPtyType("VT100");
        channelShell.setPty(true);
        PipedInputStream pipeIn = new PipedInputStream();
        PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
        File outFile = new File(outputFileName);
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        FileOutputStream fileOut = new FileOutputStream(outputFileName);
        channelShell.setInputStream(pipeIn);
        channelShell.setOutputStream(fileOut);
        channelShell.connect(3600000);
        for (String cmd : cmds) {
            try {
                pipeOut.write((String.valueOf(cmd) + "\n").getBytes());
                pipeOut.flush();
            }
            catch (Exception e) {
                try {
                    channelShell.disconnect();
                    pipeOut.close();
                    pipeIn.close();
                    fileOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "\u8fde\u63a5\u4e2d\u65ad\uff0c\u8bf7\u91cd\u8bd5\uff01";
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int seconds = waitseconds;
        if (waitseconds > 120) {
            seconds = 120;
        }
        int i = 0;
        while (i < seconds) {
            Thread.sleep(1000L);
            String result = FileUtils.readFileToString((File)new File(outputFileName), (String)"GBK");
            boolean canQuit = false;
            for (String prompt : prompts) {
                if (!result.trim().endsWith(prompt) || result.trim().length() <= 20) continue;
                canQuit = true;
                break;
            }
            if (canQuit) break;
            ++i;
        }
        try {
            this.disconnectSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            channelShell.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pipeOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pipeIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FileUtils.readFileToString((File)new File(outputFileName), (String)"GBK");
    }

    public synchronized Result exec(CustomTask task, String outputFileName, int waitSeconds) {
        Result r = new Result();
        try {
            ChannelExec channelExec = (ChannelExec)this.session.openChannel("exec");
            if (channelExec == null) {
                r.sysout = "";
                r.error_msg = "";
                return r;
            }
            String command = task.getCommand();
            channelExec.setCommand(command);
            channelExec.setInputStream(null);
            File outFile = new File(outputFileName);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FileOutputStream fileOut = new FileOutputStream(outputFileName);
            channelExec.setOutputStream(fileOut);
            FileOutputStream fileOutErr = new FileOutputStream(SysConfigOption.ERROR_MSG_BUFFER_TEMP_FILE_PATH);
            channelExec.setErrStream(fileOutErr);
            channelExec.connect();
            while (!channelExec.isClosed()) {
            }
            r.error_msg = SSHExecUtil.getErrorMsg(SysConfigOption.ERROR_MSG_BUFFER_TEMP_FILE_PATH);
            int seconds = waitSeconds;
            if (waitSeconds == 10) {
                seconds = 1;
            } else if (waitSeconds > 120) {
                seconds = 120;
            }
            if (seconds == 1) {
                Thread.sleep(100L);
            } else {
                int i = 0;
                while (i < seconds) {
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            try {
                this.disconnectSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                channelExec.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOutErr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            r.sysout = FileUtils.readFileToString((File)outFile, (String)"GBK");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return r;
    }
}

