/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.InternetHeaders;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEConfig;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEEvent;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class MIMEParser
implements Iterable<MIMEEvent> {
    private static final Logger LOGGER = Logger.getLogger(MIMEParser.class.getName());
    private static final String HEADER_ENCODING = "ISO8859-1";
    private static final int NO_LWSP = 1000;
    private STATE state = STATE.START_MESSAGE;
    private final InputStream in;
    private final byte[] bndbytes;
    private final int bl;
    private final MIMEConfig config;
    private final int[] bcs = new int[128];
    private final int[] gss;
    private boolean parsed;
    private boolean done = false;
    private boolean eof;
    private final int capacity;
    private byte[] buf;
    private int len;
    private boolean bol;

    MIMEParser(InputStream inputStream, String string, MIMEConfig mIMEConfig) {
        this.in = inputStream;
        this.bndbytes = MIMEParser.getBytes("--" + string);
        this.bl = this.bndbytes.length;
        this.config = mIMEConfig;
        this.gss = new int[this.bl];
        this.compileBoundaryPattern();
        this.capacity = mIMEConfig.chunkSize + 2 + this.bl + 4 + 1000;
        this.createBuf(this.capacity);
    }

    @Override
    public Iterator<MIMEEvent> iterator() {
        return new MIMEEventIterator();
    }

    private InternetHeaders readHeaders() {
        if (!this.eof) {
            this.fillBuf();
        }
        return new InternetHeaders(new LineInputStream());
    }

    private ByteBuffer readBody() {
        int n;
        if (!this.eof) {
            this.fillBuf();
        }
        if ((n = this.match(this.buf, 0, this.len)) == -1) {
            int n2;
            assert (this.eof || this.len >= this.config.chunkSize);
            int n3 = n2 = this.eof ? this.len : this.config.chunkSize;
            if (this.eof) {
                this.done = true;
                throw new MIMEParsingException("Reached EOF, but there is no closing MIME boundary.");
            }
            return this.adjustBuf(n2, this.len - n2);
        }
        int n4 = n;
        if (!this.bol || n != 0) {
            if (n > 0 && (this.buf[n - 1] == 10 || this.buf[n - 1] == 13)) {
                --n4;
                if (this.buf[n - 1] == 10 && n > 1 && this.buf[n - 2] == 13) {
                    --n4;
                }
            } else {
                return this.adjustBuf(n + 1, this.len - n - 1);
            }
        }
        if (n + this.bl + 1 < this.len && this.buf[n + this.bl] == 45 && this.buf[n + this.bl + 1] == 45) {
            this.state = STATE.END_PART;
            this.done = true;
            return this.adjustBuf(n4, 0);
        }
        int n5 = 0;
        for (int i = n + this.bl; i < this.len && (this.buf[i] == 32 || this.buf[i] == 9); ++i) {
            ++n5;
        }
        if (n + this.bl + n5 < this.len && this.buf[n + this.bl + n5] == 10) {
            this.state = STATE.END_PART;
            return this.adjustBuf(n4, this.len - n - this.bl - n5 - 1);
        }
        if (n + this.bl + n5 + 1 < this.len && this.buf[n + this.bl + n5] == 13 && this.buf[n + this.bl + n5 + 1] == 10) {
            this.state = STATE.END_PART;
            return this.adjustBuf(n4, this.len - n - this.bl - n5 - 2);
        }
        if (n + this.bl + n5 + 1 < this.len) {
            return this.adjustBuf(n4 + 1, this.len - n4 - 1);
        }
        if (this.eof) {
            this.done = true;
            throw new MIMEParsingException("Reached EOF, but there is no closing MIME boundary.");
        }
        return this.adjustBuf(n4, this.len - n4);
    }

    private ByteBuffer adjustBuf(int n, int n2) {
        assert (this.buf != null);
        assert (n >= 0);
        assert (n2 >= 0);
        byte[] byArray = this.buf;
        this.createBuf(n2);
        System.arraycopy(byArray, this.len - n2, this.buf, 0, n2);
        this.len = n2;
        return ByteBuffer.wrap(byArray, 0, n);
    }

    private void createBuf(int n) {
        this.buf = new byte[n < this.capacity ? this.capacity : n];
    }

    private void skipPreamble() {
        while (true) {
            int n;
            if (!this.eof) {
                this.fillBuf();
            }
            if ((n = this.match(this.buf, 0, this.len)) == -1) {
                if (this.eof) {
                    throw new MIMEParsingException("Missing start boundary");
                }
                this.adjustBuf(this.len - this.bl + 1, this.bl - 1);
                continue;
            }
            if (n > this.config.chunkSize) {
                this.adjustBuf(n, this.len - n);
                continue;
            }
            int n2 = 0;
            for (int i = n + this.bl; i < this.len && (this.buf[i] == 32 || this.buf[i] == 9); ++i) {
                ++n2;
            }
            if (n + this.bl + n2 < this.len && (this.buf[n + this.bl + n2] == 10 || this.buf[n + this.bl + n2] == 13)) {
                if (this.buf[n + this.bl + n2] == 10) {
                    this.adjustBuf(n + this.bl + n2 + 1, this.len - n - this.bl - n2 - 1);
                    break;
                }
                if (n + this.bl + n2 + 1 < this.len && this.buf[n + this.bl + n2 + 1] == 10) {
                    this.adjustBuf(n + this.bl + n2 + 2, this.len - n - this.bl - n2 - 2);
                    break;
                }
            }
            this.adjustBuf(n + 1, this.len - n - 1);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Skipped the preamble. buffer len={0}", this.len);
        }
    }

    private static byte[] getBytes(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2++];
        }
        return byArray;
    }

    private void compileBoundaryPattern() {
        int n;
        for (n = 0; n < this.bndbytes.length; ++n) {
            this.bcs[this.bndbytes[n] & 0x7F] = n + 1;
        }
        block1: for (n = this.bndbytes.length; n > 0; --n) {
            int n2;
            for (n2 = this.bndbytes.length - 1; n2 >= n; --n2) {
                if (this.bndbytes[n2] != this.bndbytes[n2 - n]) continue block1;
                this.gss[n2 - 1] = n;
            }
            while (n2 > 0) {
                this.gss[--n2] = n;
            }
        }
        this.gss[this.bndbytes.length - 1] = 1;
    }

    private int match(byte[] byArray, int n, int n2) {
        int n3 = n2 - this.bndbytes.length;
        block0: while (n <= n3) {
            for (int i = this.bndbytes.length - 1; i >= 0; --i) {
                byte by = byArray[n + i];
                if (by == this.bndbytes[i]) continue;
                n += Math.max(i + 1 - this.bcs[by & 0x7F], this.gss[i]);
                continue block0;
            }
            return n;
        }
        return -1;
    }

    private void fillBuf() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Before fillBuf() buffer len={0}", this.len);
        }
        assert (!this.eof);
        while (this.len < this.buf.length) {
            int n;
            try {
                n = this.in.read(this.buf, this.len, this.buf.length - this.len);
            }
            catch (IOException iOException) {
                throw new MIMEParsingException(iOException);
            }
            if (n == -1) {
                this.eof = true;
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Closing the input stream.");
                    }
                    this.in.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new MIMEParsingException(iOException);
                }
            }
            this.len += n;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "After fillBuf() buffer len={0}", this.len);
        }
    }

    private void doubleBuf() {
        byte[] byArray = new byte[2 * this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        this.buf = byArray;
        if (!this.eof) {
            this.fillBuf();
        }
    }

    class LineInputStream {
        private int offset;

        LineInputStream() {
        }

        public String readLine() throws IOException {
            int n = 0;
            int n2 = 0;
            while (this.offset + n < MIMEParser.this.len) {
                if (MIMEParser.this.buf[this.offset + n] == 10) {
                    n2 = 1;
                    break;
                }
                if (this.offset + n + 1 == MIMEParser.this.len) {
                    MIMEParser.this.doubleBuf();
                }
                if (this.offset + n + 1 >= MIMEParser.this.len) {
                    assert (MIMEParser.this.eof);
                    return null;
                }
                if (MIMEParser.this.buf[this.offset + n] == 13 && MIMEParser.this.buf[this.offset + n + 1] == 10) {
                    n2 = 2;
                    break;
                }
                ++n;
            }
            if (n == 0) {
                MIMEParser.this.adjustBuf(this.offset + n2, MIMEParser.this.len - this.offset - n2);
                return null;
            }
            String string = new String(MIMEParser.this.buf, this.offset, n, MIMEParser.HEADER_ENCODING);
            this.offset += n + n2;
            return string;
        }
    }

    class MIMEEventIterator
    implements Iterator<MIMEEvent> {
        MIMEEventIterator() {
        }

        @Override
        public boolean hasNext() {
            return !MIMEParser.this.parsed;
        }

        @Override
        public MIMEEvent next() {
            switch (MIMEParser.this.state) {
                case START_MESSAGE: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.START_MESSAGE);
                    }
                    MIMEParser.this.state = STATE.SKIP_PREAMBLE;
                    return MIMEEvent.START_MESSAGE;
                }
                case SKIP_PREAMBLE: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.SKIP_PREAMBLE);
                    }
                    MIMEParser.this.skipPreamble();
                }
                case START_PART: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.START_PART);
                    }
                    MIMEParser.this.state = STATE.HEADERS;
                    return MIMEEvent.START_PART;
                }
                case HEADERS: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.HEADERS);
                    }
                    InternetHeaders internetHeaders = MIMEParser.this.readHeaders();
                    MIMEParser.this.state = STATE.BODY;
                    MIMEParser.this.bol = true;
                    return new MIMEEvent.Headers(internetHeaders);
                }
                case BODY: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.BODY);
                    }
                    ByteBuffer byteBuffer = MIMEParser.this.readBody();
                    MIMEParser.this.bol = false;
                    return new MIMEEvent.Content(byteBuffer);
                }
                case END_PART: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.END_PART);
                    }
                    if (MIMEParser.this.done) {
                        MIMEParser.this.state = STATE.END_MESSAGE;
                    } else {
                        MIMEParser.this.state = STATE.START_PART;
                    }
                    return MIMEEvent.END_PART;
                }
                case END_MESSAGE: {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "MIMEParser state={0}", (Object)STATE.END_MESSAGE);
                    }
                    MIMEParser.this.parsed = true;
                    return MIMEEvent.END_MESSAGE;
                }
            }
            throw new MIMEParsingException("Unknown Parser state = " + (Object)((Object)MIMEParser.this.state));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum STATE {
        START_MESSAGE,
        SKIP_PREAMBLE,
        START_PART,
        HEADERS,
        BODY,
        END_PART,
        END_MESSAGE;

    }
}

