/*
 * Decompiled with CFR 0.152.
 */
package com.ckeditor;

import com.ckeditor.CKEditorConfig;
import com.ckeditor.CKEditorTag;
import com.ckeditor.TagHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CKEditorInsertTag
extends CKEditorTag {
    private static final long serialVersionUID = 1316780332328233835L;
    private static final String DEFAULT_TEXTAREA_ROWS = "8";
    private static final String DEFAULT_TEXTAREA_COLS = "60";
    private static final String[] CHARS_FROM = new String[]{"&", "\"", "<", ">"};
    private static final String[] CHARS_TO = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    private String editor = "";
    private String value = "";
    private Map<String, String> textareaAttributes = new HashMap<String, String>();

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write(this.createTextareaTag());
        }
        catch (Exception e) {
            try {
                HttpServletResponse resp = (HttpServletResponse)this.pageContext.getResponse();
                resp.reset();
                resp.sendError(500, "Problem with tag creation.");
            }
            catch (IOException e1) {
                throw new JspException((Throwable)e1);
            }
        }
        return 6;
    }

    @Override
    protected String getTagOutput(CKEditorConfig config) {
        if (config != null && !config.isEmpty()) {
            return "CKEDITOR.replace('" + this.editor + "', " + TagHelper.jsEncode(config) + ");";
        }
        return "CKEDITOR.replace('" + this.editor + "');";
    }

    private String createTextareaTag() {
        StringBuilder sb = new StringBuilder();
        sb.append("<textarea name=\"");
        sb.append(this.editor);
        sb.append("\" ");
        sb.append(this.createTextareaAttributesText());
        sb.append(" >");
        sb.append(this.escapeHtml(this.value));
        sb.append("</textarea>");
        sb.append("\n");
        return sb.toString();
    }

    private Object escapeHtml(String text) {
        String result = text;
        if (text.equals("")) {
            return "";
        }
        for (int i = 0; i < CHARS_FROM.length; ++i) {
            result = result.replaceAll(CHARS_FROM[i], CHARS_TO[i]);
        }
        return result;
    }

    private String createTextareaAttributesText() {
        if (this.textareaAttributes.isEmpty()) {
            this.textareaAttributes.put("rows", DEFAULT_TEXTAREA_ROWS);
            this.textareaAttributes.put("cols", DEFAULT_TEXTAREA_COLS);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.textareaAttributes.keySet()) {
            sb.append(" ");
            sb.append(s + "=\"" + this.textareaAttributes.get(s) + "\"");
        }
        return sb.toString();
    }

    public final void setEditor(String editor) {
        this.editor = editor;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final void setTextareaAttributes(Map<String, String> textareaAttr) {
        this.textareaAttributes = textareaAttr;
    }

    @Override
    protected String getCKEditorName() {
        return this.editor;
    }
}

