/*
 * Decompiled with CFR 0.152.
 */
package com.ckeditor;

import com.ckeditor.CKEditorConfig;
import com.ckeditor.EventHandler;
import com.ckeditor.GlobalEventHandler;
import com.ckeditor.TagHelper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CKEditorTag
extends TagSupport {
    private static final String TIMESTAMP = "B37D54V";
    private static final long serialVersionUID = -5642419066547779817L;
    private String basePath = "";
    private String timestamp = "B37D54V";
    private boolean initialized = false;
    private CKEditorConfig config = null;
    private EventHandler events = null;
    private GlobalEventHandler globalEvents;

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        this.configureContextParams();
        try {
            String output = "";
            if (!this.initialized && !this.isInitializedParam()) {
                out.write(this.init());
            }
            if (this.globalEvents != null) {
                output = output + this.globalEvents.returnGlobalEvents();
            }
            CKEditorConfig cfg = null;
            if (this.config != null) {
                cfg = this.config.configSettings(this.events);
            }
            output = output + this.getTagOutput(cfg);
            out.write(TagHelper.script(output));
        }
        catch (Exception e) {
            try {
                HttpServletResponse resp = (HttpServletResponse)this.pageContext.getResponse();
                resp.reset();
                resp.sendError(500, "Problem with tag creation.");
                e.printStackTrace();
            }
            catch (IOException e1) {
                throw new JspException((Throwable)e1);
            }
        }
        return 6;
    }

    private void configureContextParams() {
        if (this.pageContext.getAttribute("ckeditor-params") != null) {
            Map map = (Map)this.pageContext.getAttribute("ckeditor-params");
            if (map.get(this.getCKEditorName()) != null) {
                this.parseParamsFromContext((Map)map.get(this.getCKEditorName()));
            } else if (map.get("*") != null) {
                this.parseParamsFromContext((Map)map.get("*"));
            }
        }
    }

    private void parseParamsFromContext(Map<String, String> map) {
        if (!map.isEmpty() && this.config == null) {
            this.config = new CKEditorConfig();
        }
        for (String key : map.keySet()) {
            this.config.addConfigValue(key, map.get(key));
        }
    }

    private boolean isInitializedParam() {
        if ("initialized".equals(this.pageContext.getAttribute("ckeditor-initialized"))) {
            return true;
        }
        this.pageContext.setAttribute("ckeditor-initialized", (Object)"initialized");
        return false;
    }

    protected abstract String getTagOutput(CKEditorConfig var1);

    protected String init() {
        String out = "";
        String args = "";
        String ckeditorPath = this.getBasePath();
        if (this.timestamp != null) {
            args = args + "?t=" + this.timestamp;
        }
        if (ckeditorPath.contains("..")) {
            out = out + TagHelper.script("window.CKEDITOR_BASEPATH='" + ckeditorPath + "';");
        }
        out = out + TagHelper.createCKEditorIncJS(ckeditorPath, args);
        String extraCode = "";
        if (this.timestamp != TIMESTAMP) {
            extraCode = extraCode + (extraCode.length() > 0 ? "\n" : "".concat("CKEDITOR.timestamp = '").concat(this.timestamp).concat("';"));
        }
        if (extraCode.length() > 0) {
            out = out + TagHelper.script(extraCode);
        }
        return out;
    }

    private String getBasePath() {
        if (this.basePath.equals("") || this.basePath.charAt(this.basePath.length() - 1) != '/') {
            return this.basePath.concat("/");
        }
        return this.basePath;
    }

    public final void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public final String getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public final GlobalEventHandler getGlobalEvents() {
        return this.globalEvents;
    }

    public final void setGlobalEvents(GlobalEventHandler globalEvents) {
        this.globalEvents = globalEvents;
    }

    public final CKEditorConfig getConfig() {
        return this.config;
    }

    public final void setConfig(CKEditorConfig config) {
        this.config = config;
    }

    public final EventHandler getEvents() {
        return this.events;
    }

    public final void setEvents(EventHandler events) {
        this.events = events;
    }

    protected abstract String getCKEditorName();
}

