/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.Expect4j;
import expect4j.ExpectUtils;
import expect4j.TclClosure;
import expect4j.matches.EofMatch;
import expect4j.matches.GlobMatch;
import expect4j.matches.Match;
import expect4j.matches.RegExpMatch;
import expect4j.matches.TimeoutMatch;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.SubstCrCommand;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class ExpectEmulation
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(ExpectEmulation.class);

    public void init(Interp interp) {
        interp.createCommand("exp_continue", (Command)new ExpContinueCommand());
        interp.createCommand("exp_internal", (Command)new ExpInternalCommand());
        interp.createCommand("expect", (Command)new ExpectCommand());
        interp.createCommand("log_user", (Command)new LogUserCommand());
        interp.createCommand("send", (Command)new SendCommand());
        interp.createCommand("sleep", (Command)new SleepCommand());
        interp.createCommand("spawn", (Command)new SpawnCommand());
        interp.createCommand("stty", (Command)new SttyCommand());
        interp.createCommand("timestamp", (Command)new TimestampCommand());
        interp.createCommand("substcr", (Command)new SubstCrCommand());
        try {
            interp.pkgProvide("expect", "2.0");
        }
        catch (TclException te) {
            logger.warn(te.getMessage());
        }
    }

    public static Expect4j expStateCurrent(Interp interp) throws TclException {
        TclObject spawnObj = interp.getVar("spawn_id", 0);
        Map spawnIds = (Map)interp.getAssocData("spawnIds");
        if (spawnIds == null) {
            throw new TclException(interp, "spawn not called yet");
        }
        String spawnId = spawnObj.toString();
        if (!spawnIds.containsKey(spawnId)) {
            throw new TclException(interp, "Unable to find spawn_id of " + spawnId);
        }
        Expect4j expect4j = (Expect4j)spawnIds.get(spawnId);
        if (expect4j == null) {
            throw new TclException(interp, "Unable to find Expect context from " + spawnId);
        }
        return expect4j;
    }

    public static boolean isVar(Interp interp, String varname) throws TclException {
        TclObject obj = null;
        try {
            obj = interp.getVar(varname, null, 1);
        }
        catch (Exception e) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        return TclBoolean.get((Interp)interp, (TclObject)obj);
    }

    public static void setBooleanVar(Interp interp, String varname, boolean value) throws TclException {
        if (ExpectEmulation.isVar(interp, varname) == value) {
            return;
        }
        TclObject obj = TclBoolean.newInstance((boolean)value);
        logger.debug("Setting " + varname + " to " + Boolean.toString(value));
        interp.setVar(varname, obj, 1);
    }

    public static boolean isEcho(Interp interp) throws TclException {
        return ExpectEmulation.isVar(interp, "exp_tty_echo");
    }

    public static void setEcho(Interp interp, boolean setEcho) throws TclException {
        ExpectEmulation.setBooleanVar(interp, "exp_tty_echo", setEcho);
    }

    public static boolean isLogUser(Interp interp) throws TclException {
        return ExpectEmulation.isVar(interp, "exp_log_user");
    }

    public static void setLogUser(Interp interp, boolean setLogUser) throws TclException {
        ExpectEmulation.setBooleanVar(interp, "exp_log_user", setLogUser);
    }

    public static boolean isExpDebug(Interp interp) throws TclException {
        return ExpectEmulation.isVar(interp, "exp_debug");
    }

    public static void setExpDebug(Interp interp, boolean setExpDebug) throws TclException {
        ExpectEmulation.setBooleanVar(interp, "exp_debug", setExpDebug);
    }

    public static boolean isExpContinue(Interp interp) throws TclException {
        return ExpectEmulation.isVar(interp, "exp_continue_set");
    }

    public static void setExpContinue(Interp interp, boolean setExpContinue) throws TclException {
        ExpectEmulation.setBooleanVar(interp, "exp_continue_set", setExpContinue);
    }

    public static String escape(String value) {
        String raw = value;
        boolean isString = false;
        if (value.indexOf(34) == 0 && value.lastIndexOf(34) == value.length() - 1) {
            isString = true;
            raw = value.substring(1, value.length() - 1);
        }
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(raw);
        char character = iterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '\"': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    result.append("\\");
                }
            }
            result.append(character);
            character = iterator.next();
        }
        String clean = result.toString();
        if (isString) {
            clean = '\"' + clean + '\"';
        }
        return clean;
    }

    public class MapAssocData
    extends HashMap<String, Expect4j>
    implements AssocData {
        public void disposeAssocData(Interp interp) {
        }
    }

    public class IntegerAssocData
    implements AssocData {
        public Integer _i;

        public IntegerAssocData(int value) {
            this._i = new Integer(value);
        }

        public IntegerAssocData(String s) {
            this._i = new Integer(s);
        }

        public void disposeAssocData(Interp interp) {
        }
    }

    public class SttyCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length > 2) {
                throw new TclNumArgsException(interp, 0, argv, "[echo|-echo]");
            }
            String cmd = argv[1].toString();
            logger.debug("stty cmd is " + cmd);
            if (cmd.equals("echo")) {
                ExpectEmulation.setEcho(interp, true);
            } else if (cmd.equals("-echo")) {
                ExpectEmulation.setEcho(interp, false);
            } else {
                throw new TclException(interp, "Only echo is supported");
            }
        }
    }

    public class TimestampCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length > 1) {
                throw new TclNumArgsException(interp, 0, argv, "");
            }
            long epoch = new Date().getTime();
            if ((double)epoch >= Double.MAX_VALUE) {
                throw new TclException(interp, "Epoch is too large to convert to double");
            }
            double epochd = new Long(epoch).doubleValue();
            TclObject result = TclDouble.newInstance((double)epochd);
            interp.setResult(result);
        }
    }

    public class SpawnCommand
    implements Command,
    VarTrace {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            String[] cmdarray;
            Expect4j expect4j;
            String program;
            int i;
            if (argv.length == 1) {
                throw new TclNumArgsException(interp, 0, argv, "[args] program [args]");
            }
            for (i = 1; i < argv.length && argv[i].toString().indexOf(45) == 0; ++i) {
            }
            if (i == argv.length) {
                throw new TclNumArgsException(interp, i, argv, "[args] program [args]");
            }
            if ((program = argv[i++].toString().trim()).indexOf("ssh") != -1) {
                String username = null;
                String password = null;
                while (argv[i].toString().indexOf(45) == 0) {
                    logger.debug("ssh arg: " + argv[i].toString());
                    if (argv[i].toString().equals("-l") && i + 1 < argv.length - 1) {
                        username = argv[++i].toString();
                    }
                    if (argv[i].toString().equals("-P") && i + 1 < argv.length - 1) {
                        password = argv[++i].toString();
                    }
                    ++i;
                }
                if (username == null) {
                    throw new TclException(interp, "Username needs to be provided");
                }
                logger.debug("Username: " + username);
                if (i >= argv.length) {
                    throw new TclNumArgsException(interp, i - 1, argv, "[-l username] [-P password] hostname");
                }
                String hostname = argv[i].toString().trim();
                try {
                    expect4j = ExpectUtils.SSH(hostname, username, password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TclException(interp, "Unable to connect using SSH");
                }
            }
            if (program.indexOf("telnet") == 0) {
                String hostname = null;
                String portStr = null;
                if (i >= argv.length) {
                    throw new TclNumArgsException(interp, i, argv, "hostname port");
                }
                hostname = argv[i++].toString().trim();
                if (i < argv.length) {
                    portStr = argv[i++].toString().trim();
                }
                int port = 23;
                if (portStr != null) {
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new TclException(interp, "Unable to parse the port number");
                    }
                }
                try {
                    expect4j = ExpectUtils.telnet(hostname, port);
                }
                catch (Exception e) {
                    throw new TclException(interp, "Unable to connect using Telnet");
                }
            }
            int cmdidx = 0;
            int addlargs = argv.length - i + 1;
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.indexOf("windows 9") > -1) {
                cmdarray = new String[addlargs + 2];
                cmdarray[cmdidx++] = "command.com";
                cmdarray[cmdidx++] = "/c";
            } else if (OS.indexOf("windows") > -1) {
                cmdarray = new String[addlargs + 2];
                cmdarray[cmdidx++] = "cmd.exe";
                cmdarray[cmdidx++] = "/c";
            } else {
                cmdarray = new String[addlargs];
            }
            cmdarray[cmdidx++] = program;
            while (i < argv.length) {
                cmdarray[cmdidx++] = argv[i].toString().trim();
                ++i;
            }
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                expect4j = new Expect4j(process);
            }
            catch (Exception e) {
                throw new TclException(interp, "Unable to start arbitary process");
            }
            int nextId = 1;
            IntegerAssocData lastSpawnId = (IntegerAssocData)interp.getAssocData("lastSpawnId");
            if (lastSpawnId != null) {
                nextId = lastSpawnId._i + 1;
            }
            lastSpawnId = new IntegerAssocData(nextId);
            interp.setAssocData("lastSpawnId", (AssocData)lastSpawnId);
            MapAssocData spawnIds = (MapAssocData)interp.getAssocData("spawnIds");
            if (spawnIds == null) {
                spawnIds = new MapAssocData();
            }
            String spawnId = lastSpawnId._i.toString();
            logger.debug("Putting id in " + spawnId);
            spawnIds.put(spawnId, expect4j);
            interp.setAssocData("spawnIds", (AssocData)spawnIds);
            TclObject spawnIdObj = TclInteger.newInstance((int)nextId);
            interp.setVar("spawn_id", spawnIdObj, 0);
            interp.traceVar("spawn_id", (VarTrace)this, 0);
            interp.setResult(spawnIdObj);
        }

        public void traceProc(Interp interp, String name1, String name2, int flags) {
            logger.debug("Tracing");
            if ((flags & 0x80) != 0) {
                logger.warn("Trace Destroyed");
            }
            if ((flags & 0x100) != 0) {
                logger.warn("Interp Destroyed");
            }
        }
    }

    public class SleepCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length > 2) {
                throw new TclNumArgsException(interp, 0, argv, "seconds");
            }
            int seconds = TclInteger.get((Interp)interp, (TclObject)argv[1]);
            try {
                Thread.sleep(seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class SendCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            int i;
            logger.debug("Send Command arg # " + argv.length);
            if (argv.length == 1) {
                throw new TclNumArgsException(interp, 1, argv, "[-flags] [--] string");
            }
            boolean checkingFlags = true;
            String arg = null;
            for (i = 1; i < argv.length; ++i) {
                arg = argv[i].toString();
                if (checkingFlags && arg.equals("--")) {
                    checkingFlags = false;
                    continue;
                }
                if (checkingFlags && !arg.startsWith("-")) continue;
            }
            if (i - 1 == argv.length) {
                throw new TclNumArgsException(interp, 1, argv, "[-flags] [--] string");
            }
            String pattern1 = "\r(?=[^\n])";
            String pattern2 = "\r$";
            arg = arg.replaceAll(pattern1, "\r\n");
            arg = arg.replaceAll(pattern2, "\r\n");
            Expect4j expect4j = ExpectEmulation.expStateCurrent(interp);
            try {
                expect4j.send(arg);
            }
            catch (Exception ioe) {
                throw new TclException(interp, "Unable to send " + arg);
            }
            if (ExpectEmulation.isEcho(interp)) {
                System.out.println(arg);
            }
        }
    }

    public class LogUserCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length != 2) {
                throw new TclNumArgsException(interp, 0, argv, "[0|1]");
            }
            String arg = argv[1].toString();
            if (arg.equals("1")) {
                ExpectEmulation.setLogUser(interp, true);
            } else if (arg.equals("0")) {
                ExpectEmulation.setLogUser(interp, false);
            } else {
                throw new TclNumArgsException(interp, 0, argv, "[0|1]");
            }
        }
    }

    public class ExpInternalCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length != 2) {
                throw new TclNumArgsException(interp, 0, argv, "[0|1]");
            }
            String arg = argv[1].toString();
            if (arg.equals("1")) {
                ExpectEmulation.setExpDebug(interp, true);
            } else if (arg.equals("0")) {
                ExpectEmulation.setExpDebug(interp, false);
            } else {
                throw new TclNumArgsException(interp, 0, argv, "[0|1]");
            }
        }
    }

    public class ExpContinueCommand
    implements Command {
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            if (argv.length != 1) {
                throw new TclNumArgsException(interp, 0, argv, "");
            }
            ExpectEmulation.setExpContinue(interp, true);
        }
    }

    public class ExpectCommand
    implements Command {
        void releaseClosures(Interp interp, Collection<TclObject> preserved) {
            Iterator<TclObject> iter = preserved.iterator();
            while (iter.hasNext()) {
                iter.next().release();
            }
        }

        public void cmdProc(Interp interp, TclObject[] args) throws TclException {
            int ret;
            int i;
            if (args.length != 2) {
                throw new TclNumArgsException(interp, 0, args, "expect {[-opts] pat1 body1] ... [-opts] patn [bodyn]}");
            }
            TclObject argArr = args[1];
            TclObject[] argv = TclList.getElements((Interp)interp, (TclObject)argArr);
            ArrayList<Match> pairs = new ArrayList<Match>();
            logger.debug("Looking at expect args");
            ArrayList<TclObject> preserved = new ArrayList<TclObject>(argv.length - i);
            for (i = 0; i < argv.length; ++i) {
                Match pair;
                block23: {
                    TclObject patternObj;
                    TclClosure closure;
                    TclObject tclCode;
                    String arg = argv[i].toString();
                    if (arg.equals("timeout")) {
                        if (i + 1 >= argv.length) {
                            throw new TclNumArgsException(interp, i, argv, "expect [[-opts] pat1 body1] ... [-opts] patn [bodyn]");
                        }
                        tclCode = argv[++i];
                        closure = new TclClosure(interp, tclCode);
                        pair = new TimeoutMatch(closure);
                        logger.debug("Adding Timeout Match");
                        pairs.add(pair);
                        continue;
                    }
                    if (arg.equals("eof")) {
                        if (i + 1 >= argv.length) {
                            throw new TclNumArgsException(interp, i, argv, "expect [[-opts] pat1 body1] ... [-opts] patn [bodyn]");
                        }
                        tclCode = argv[++i];
                        closure = new TclClosure(interp, tclCode);
                        pair = new EofMatch(closure);
                        logger.debug("Adding Eof Match");
                        pairs.add(pair);
                        continue;
                    }
                    if (arg.startsWith("-")) {
                        patternObj = argv[++i];
                    } else {
                        patternObj = argv[i];
                        arg = "-gl";
                    }
                    String javaStr = patternObj.toString();
                    javaStr = javaStr.replaceAll("\\r", "\\\\r");
                    javaStr = javaStr.replaceAll("\\n", "\\\\n");
                    Command substCmd = interp.getCommand("substcr");
                    TclObject[] substArgv = new TclObject[]{TclString.newInstance((String)"substcr"), TclString.newInstance((String)"-nocommands"), TclString.newInstance((String)"-nobackslashes"), patternObj};
                    substCmd.cmdProc(interp, substArgv);
                    TclObject substPatternObj = interp.getResult();
                    String pattern = substPatternObj.toString();
                    TclClosure closure2 = null;
                    TclObject tclCode2 = null;
                    if (i + 1 < argv.length) {
                        TclObject tclCodeDirect = argv[++i];
                        tclCodeDirect.preserve();
                        preserved.add(tclCodeDirect);
                        tclCode2 = tclCodeDirect;
                    }
                    closure2 = new TclClosure(interp, tclCode2);
                    logger.debug(i + " Pattern Obj is >>" + javaStr + "<< and pattern is >>>" + pattern + "<<<");
                    try {
                        if (arg.startsWith("-re")) {
                            pair = new RegExpMatch(pattern, closure2);
                            break block23;
                        }
                        if (arg.startsWith("-ex")) {
                            throw new TclException(interp, "Exact matches not supported yet");
                        }
                        if (arg.startsWith("-gl")) {
                            pair = new GlobMatch(pattern, closure2);
                            logger.debug(i + " Glob at regexp " + ((GlobMatch)pair).getPattern().getPattern());
                            break block23;
                        }
                        throw new TclException(interp, "Unknown type of pattern");
                    }
                    catch (TclException te) {
                        this.releaseClosures(interp, preserved);
                        throw te;
                    }
                    catch (MalformedPatternException mpe) {
                        this.releaseClosures(interp, preserved);
                        throw new TclException(interp, "Invalid pattern: " + pattern);
                    }
                }
                pairs.add(pair);
            }
            Expect4j expect4j = ExpectEmulation.expStateCurrent(interp);
            try {
                TclObject timeoutObj = interp.getVar("timeout", null, 0);
                int timeout = TclInteger.get((Interp)interp, (TclObject)timeoutObj);
                expect4j.setDefaultTimeout(timeout * 1000);
            }
            catch (Exception e) {
                expect4j.setDefaultTimeout(10000L);
            }
            boolean isDebug = ExpectEmulation.isExpDebug(interp);
            boolean isEcho = ExpectEmulation.isEcho(interp);
            boolean isLogUser = ExpectEmulation.isLogUser(interp);
            try {
                ret = expect4j.expect(pairs);
            }
            catch (TclException te) {
                throw te;
            }
            catch (Exception e) {
                throw new TclException(interp, e.getMessage());
            }
            finally {
                this.releaseClosures(interp, preserved);
            }
            interp.setResult(ret);
        }
    }
}

