/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletRequestAttributes
extends AbstractRequestAttributes {
    private static final Log logger = LogFactory.getLog((Class)PortletRequestAttributes.class);
    private final PortletRequest request;
    private PortletSession session;
    private final Map sessionAttributesToUpdate = new HashMap();
    private final Map globalSessionAttributesToUpdate = new HashMap();

    public PortletRequestAttributes(PortletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
        this.session = request.getPortletSession(false);
    }

    public final PortletRequest getRequest() {
        return this.request;
    }

    protected final PortletSession getSession(boolean allowCreate) {
        try {
            this.session = this.request.getPortletSession(allowCreate);
            return this.session;
        }
        catch (IllegalStateException ex) {
            if (this.session == null) {
                throw ex;
            }
            if (allowCreate) {
                boolean canAskForExistingSession = false;
                try {
                    this.session = this.request.getPortletSession(false);
                    canAskForExistingSession = true;
                }
                catch (IllegalStateException ex2) {
                    // empty catch block
                }
                if (canAskForExistingSession) {
                    throw ex;
                }
            }
            return this.session;
        }
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(name);
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                Object value = session.getAttribute(name, 1);
                if (value != null) {
                    this.globalSessionAttributesToUpdate.put(name, value);
                }
                return value;
            }
            Object value = session.getAttribute(name);
            if (value != null) {
                this.sessionAttributesToUpdate.put(name, value);
            }
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            this.request.setAttribute(name, value);
        } else {
            PortletSession session = this.getSession(true);
            if (scope == 2) {
                session.setAttribute(name, value, 1);
                this.globalSessionAttributesToUpdate.remove(name);
            } else {
                session.setAttribute(name, value);
                this.sessionAttributesToUpdate.remove(name);
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            this.request.removeAttribute(name);
            this.removeRequestDestructionCallback(name);
        } else {
            PortletSession session = this.getSession(false);
            if (session != null) {
                if (scope == 2) {
                    session.removeAttribute(name, 1);
                    this.globalSessionAttributesToUpdate.remove(name);
                } else {
                    session.removeAttribute(name);
                    this.sessionAttributesToUpdate.remove(name);
                }
            }
        }
    }

    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            return StringUtils.toStringArray((Enumeration)this.request.getAttributeNames());
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                return StringUtils.toStringArray((Enumeration)session.getAttributeNames(1));
            }
            return StringUtils.toStringArray((Enumeration)session.getAttributeNames());
        }
        return new String[0];
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name, callback);
        } else {
            this.registerSessionDestructionCallback(name, callback);
        }
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return PortletUtils.getSessionMutex(this.getSession(true));
    }

    protected void updateAccessedSessionAttributes() {
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            Object oldValue;
            Object newValue;
            String name;
            Map.Entry entry;
            Iterator it = this.sessionAttributesToUpdate.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                name = (String)entry.getKey();
                newValue = entry.getValue();
                oldValue = session.getAttribute(name);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue);
            }
            it = this.globalSessionAttributesToUpdate.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                name = (String)entry.getKey();
                newValue = entry.getValue();
                oldValue = session.getAttribute(name, 1);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue, 1);
            }
        }
        this.sessionAttributesToUpdate.clear();
        this.globalSessionAttributesToUpdate.clear();
    }

    private void registerSessionDestructionCallback(String name, Runnable callback) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Could not register destruction callback [" + callback + "] for attribute '" + name + "' for session scope because Portlet API 1.0 does not support session attribute callbacks"));
        }
    }

    public String toString() {
        return this.request.toString();
    }
}

