/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.web.portlet.handler.AbstractHandlerMapping;

public abstract class AbstractMapBasedHandlerMapping
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private final Map handlerMap = new HashMap();

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    protected Object getHandlerInternal(PortletRequest request) throws Exception {
        Object lookupKey = this.getLookupKey(request);
        Object handler = this.handlerMap.get(lookupKey);
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Key [" + lookupKey + "] -> handler [" + handler + "]"));
        }
        if (handler instanceof Map) {
            Map predicateMap = (Map)handler;
            Iterator it = predicateMap.keySet().iterator();
            while (it.hasNext()) {
                PortletRequestMappingPredicate predicate = (PortletRequestMappingPredicate)it.next();
                if (!predicate.match(request)) continue;
                return predicateMap.get(predicate);
            }
            return null;
        }
        return handler;
    }

    protected abstract Object getLookupKey(PortletRequest var1) throws Exception;

    protected void registerHandlers(Map handlerMap) throws BeansException {
        Assert.notNull((Object)handlerMap, (String)"Handler Map must not be null");
        Iterator it = handlerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.registerHandler(entry.getKey(), entry.getValue());
        }
    }

    protected void registerHandler(Object lookupKey, Object handler) throws BeansException, IllegalStateException {
        this.registerHandler(lookupKey, handler, null);
    }

    protected void registerHandler(Object lookupKey, Object handler, PortletRequestMappingPredicate predicate) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull((Object)lookupKey, (String)"Lookup key must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(lookupKey)) != null && !(mappedHandler instanceof Map)) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map handler [" + handler + "] to key [" + lookupKey + "]: There's already handler [" + mappedHandler + "] mapped.");
            }
        } else {
            if (predicate != null) {
                LinkedHashMap<PortletRequestMappingPredicate, Object> predicateMap = (LinkedHashMap<PortletRequestMappingPredicate, Object>)mappedHandler;
                if (predicateMap == null) {
                    predicateMap = new LinkedHashMap<PortletRequestMappingPredicate, Object>();
                    this.handlerMap.put(lookupKey, predicateMap);
                }
                predicateMap.put(predicate, resolvedHandler);
            } else {
                this.handlerMap.put(lookupKey, resolvedHandler);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped key [" + lookupKey + "] onto handler [" + resolvedHandler + "]"));
            }
        }
    }

    protected static interface PortletRequestMappingPredicate {
        public boolean match(PortletRequest var1);
    }
}

