/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.ftp4j;

import it.sauronsoftware.ftp4j.FTPDataTransferConnectionProvider;
import it.sauronsoftware.ftp4j.FTPDataTransferException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;

class FTPDataTransferServer
implements FTPDataTransferConnectionProvider,
Runnable {
    private ServerSocket serverSocket = null;
    private Socket socket;
    private IOException exception;
    private Thread thread;

    public FTPDataTransferServer() throws FTPDataTransferException {
        boolean useRange = false;
        String aux = System.getProperty("ftp4j.activeDataTransfer.portRange");
        int start = 0;
        int stop = 0;
        if (aux != null) {
            boolean valid = false;
            StringTokenizer st = new StringTokenizer(aux, "-");
            if (st.countTokens() == 2) {
                int v2;
                int v1;
                String s1 = st.nextToken();
                String s2 = st.nextToken();
                try {
                    v1 = Integer.parseInt(s1);
                }
                catch (NumberFormatException e) {
                    v1 = 0;
                }
                try {
                    v2 = Integer.parseInt(s2);
                }
                catch (NumberFormatException e) {
                    v2 = 0;
                }
                if (v1 > 0 && v2 > 0 && v2 >= v1) {
                    start = v1;
                    stop = v2;
                    valid = true;
                    useRange = true;
                }
            }
            if (!valid) {
                System.err.println("WARNING: invalid value \"" + aux + "\" for the " + "ftp4j.activeDataTransfer.portRange" + " system property. The value should " + "be in the start-stop form, with " + "start > 0, stop > 0 and start <= stop.");
            }
        }
        if (useRange) {
            int size;
            ArrayList<Integer> availables = new ArrayList<Integer>();
            for (int i = start; i <= stop; ++i) {
                availables.add(new Integer(i));
            }
            boolean done = false;
            while (!done && (size = availables.size()) > 0) {
                int rand = (int)Math.floor(Math.random() * (double)size);
                int port = (Integer)availables.remove(rand);
                try {
                    this.serverSocket = new ServerSocket(port);
                    done = true;
                }
                catch (IOException e) {}
            }
            if (!done) {
                throw new FTPDataTransferException("Cannot open the ServerSocket. No available port found in range " + aux);
            }
        } else {
            try {
                this.serverSocket = new ServerSocket(0);
            }
            catch (IOException e) {
                throw new FTPDataTransferException("Cannot open the ServerSocket", e);
            }
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timeout = 30000;
        String aux = System.getProperty("ftp4j.activeDataTransfer.acceptTimeout");
        if (aux != null) {
            int value;
            boolean valid = false;
            try {
                value = Integer.parseInt(aux);
            }
            catch (NumberFormatException e) {
                value = -1;
            }
            if (value >= 0) {
                timeout = value;
                valid = true;
            }
            if (!valid) {
                System.err.println("WARNING: invalid value \"" + aux + "\" for the " + "ftp4j.activeDataTransfer.acceptTimeout" + " system property. The value should " + "be an integer greater or equal to 0.");
            }
        }
        try {
            this.serverSocket.setSoTimeout(timeout);
            this.socket = this.serverSocket.accept();
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Socket openDataTransferConnection() throws FTPDataTransferException {
        if (this.socket == null && this.exception == null) {
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.exception != null) {
            throw new FTPDataTransferException("Cannot receive the incoming connection", this.exception);
        }
        if (this.socket == null) {
            throw new FTPDataTransferException("No socket available");
        }
        return this.socket;
    }
}

