/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.ftp4j.connectors;

import it.sauronsoftware.ftp4j.FTPConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class SOCKS4Connector
implements FTPConnector {
    private String socks4host;
    private int socks4port;
    private String socks4user;

    public SOCKS4Connector(String socks4host, int socks4port, String socks4user) {
        this.socks4host = socks4host;
        this.socks4port = socks4port;
        this.socks4user = socks4user;
    }

    public SOCKS4Connector(String socks4host, int socks4port) {
        this(socks4host, socks4port, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Socket connect(String host, int port) throws IOException {
        byte[] address;
        boolean socks4a = false;
        try {
            address = InetAddress.getByName(host).getAddress();
        }
        catch (Exception e) {
            socks4a = true;
            address = new byte[]{0, 0, 0, 1};
        }
        boolean connected = false;
        Socket socket = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            int aux;
            socket = new Socket(this.socks4host, this.socks4port);
            in = socket.getInputStream();
            out = socket.getOutputStream();
            out.write(4);
            out.write(1);
            out.write(port >> 8);
            out.write(port);
            out.write(address);
            if (this.socks4user != null) {
                out.write(this.socks4user.getBytes("UTF-8"));
            }
            out.write(0);
            if (socks4a) {
                out.write(host.getBytes("UTF-8"));
                out.write(0);
            }
            if ((aux = this.read(in)) != 0) {
                throw new IOException("SOCKS4Connector: invalid proxy response");
            }
            aux = this.read(in);
            switch (aux) {
                case 90: {
                    in.skip(6L);
                    connected = true;
                    return socket;
                }
                case 91: {
                    throw new IOException("SOCKS4Connector: connection refused/failed");
                }
                case 92: {
                    throw new IOException("SOCKS4Connector: cannot validate the user");
                }
                case 93: {
                    throw new IOException("SOCKS4Connector: invalid user");
                }
                default: {
                    throw new IOException("SOCKS4Connector: invalid proxy response");
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!connected) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable t) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable t) {}
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private int read(InputStream in) throws IOException {
        int aux = in.read();
        if (aux < 0) {
            throw new IOException("SOCKS4Connector: connection closed by the proxy");
        }
        return aux;
    }

    public Socket connectForCommunicationChannel(String host, int port) throws IOException {
        return this.connect(host, port);
    }

    public Socket connectForDataTransferChannel(String host, int port) throws IOException {
        return this.connect(host, port);
    }
}

