/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.SessionConfig;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationPushBuilder
implements PushBuilder {
    private static final StringManager sm = StringManager.getManager(ApplicationPushBuilder.class);
    private static final Set<String> DISALLOWED_METHODS = new HashSet<String>();
    private final HttpServletRequest baseRequest;
    private final Request catalinaRequest;
    private final org.apache.coyote.Request coyoteRequest;
    private final String sessionCookieName;
    private final String sessionPathParameterName;
    private final boolean addSessionCookie;
    private final boolean addSessionPathParameter;
    private final Map<String, List<String>> headers = new CaseInsensitiveKeyMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String method = "GET";
    private String path;
    private String eTag;
    private String lastModified;
    private String queryString;
    private String sessionId;
    private boolean conditional;

    public ApplicationPushBuilder(HttpServletRequest request) {
        this.baseRequest = request;
        HttpServletRequest current = request;
        while (current instanceof ServletRequestWrapper) {
            current = ((ServletRequestWrapper)current).getRequest();
        }
        if (!(current instanceof Request)) {
            throw new UnsupportedOperationException(sm.getString("applicationPushBuilder.noCoyoteRequest", new Object[]{current.getClass().getName()}));
        }
        this.catalinaRequest = (Request)current;
        this.coyoteRequest = this.catalinaRequest.getCoyoteRequest();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList values = new ArrayList();
            this.headers.put(headerName, values);
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                values.add(headerValues.nextElement());
            }
        }
        this.headers.remove("if-match");
        if (this.headers.remove("if-none-match") != null) {
            this.conditional = true;
        }
        if (this.headers.remove("if-modified-since") != null) {
            this.conditional = true;
        }
        this.headers.remove("if-unmodified-since");
        this.headers.remove("if-range");
        this.headers.remove("range");
        this.headers.remove("expect");
        this.headers.remove("authorization");
        this.headers.remove("referer");
        this.headers.remove("cookie");
        StringBuffer referer = request.getRequestURL();
        if (request.getQueryString() != null) {
            referer.append('?');
            referer.append(request.getQueryString());
        }
        this.addHeader("referer", referer.toString());
        Context context = this.catalinaRequest.getContext();
        this.sessionCookieName = SessionConfig.getSessionCookieName(context);
        this.sessionPathParameterName = SessionConfig.getSessionUriParamName(context);
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.sessionId = session.getId();
        }
        if (this.sessionId == null) {
            this.sessionId = request.getRequestedSessionId();
        }
        if (!request.isRequestedSessionIdFromCookie() && !request.isRequestedSessionIdFromURL() && this.sessionId != null) {
            Set sessionTrackingModes = request.getServletContext().getEffectiveSessionTrackingModes();
            this.addSessionCookie = sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
            this.addSessionPathParameter = sessionTrackingModes.contains(SessionTrackingMode.URL);
        } else {
            this.addSessionCookie = request.isRequestedSessionIdFromCookie();
            this.addSessionPathParameter = request.isRequestedSessionIdFromURL();
        }
        if (request.getCookies() != null) {
            for (Cookie requestCookie : request.getCookies()) {
                this.cookies.add(requestCookie);
            }
        }
        for (Cookie responseCookie : this.catalinaRequest.getResponse().getCookies()) {
            if (responseCookie.getMaxAge() < 0) {
                Iterator<Cookie> cookieIterator = this.cookies.iterator();
                while (cookieIterator.hasNext()) {
                    Cookie cookie = cookieIterator.next();
                    if (!cookie.getName().equals(responseCookie.getName())) continue;
                    cookieIterator.remove();
                }
                continue;
            }
            this.cookies.add(new Cookie(responseCookie.getName(), responseCookie.getValue()));
        }
    }

    public PushBuilder path(String path) {
        if (path.startsWith("/")) {
            this.path = path;
        } else {
            String contextPath = this.baseRequest.getContextPath();
            int len = contextPath.length() + path.length() + 1;
            StringBuilder sb = new StringBuilder(len);
            sb.append(contextPath);
            sb.append('/');
            sb.append(path);
            this.path = sb.toString();
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public PushBuilder method(String method) {
        String upperMethod = method.trim().toUpperCase();
        if (DISALLOWED_METHODS.contains(upperMethod)) {
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodInvalid", new Object[]{upperMethod}));
        }
        for (char c : upperMethod.toCharArray()) {
            if (HttpParser.isToken((int)c)) continue;
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodNotToken", new Object[]{upperMethod}));
        }
        this.method = method;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public PushBuilder eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PushBuilder lastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public PushBuilder conditional(boolean conditional) {
        this.conditional = conditional;
        return this;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public PushBuilder addHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
        return this;
    }

    public PushBuilder removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public void push() {
        String pushPath;
        if (this.path == null) {
            throw new IllegalStateException(sm.getString("pushBuilder.noPath"));
        }
        org.apache.coyote.Request pushTarget = new org.apache.coyote.Request();
        pushTarget.method().setString(this.method);
        pushTarget.serverName().setString(this.baseRequest.getServerName());
        pushTarget.setServerPort(this.baseRequest.getServerPort());
        pushTarget.scheme().setString(this.baseRequest.getScheme());
        for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
            for (String value : header.getValue()) {
                pushTarget.getMimeHeaders().addValue(header.getKey()).setString(value);
            }
        }
        int queryIndex = this.path.indexOf(63);
        String pushQueryString = null;
        if (queryIndex > -1) {
            pushPath = this.path.substring(0, queryIndex);
            if (queryIndex + 1 < this.path.length()) {
                pushQueryString = this.path.substring(queryIndex + 1);
            }
        } else {
            pushPath = this.path;
        }
        if (this.sessionId != null) {
            if (this.addSessionPathParameter) {
                pushPath = pushPath + ";" + this.sessionPathParameterName + "=" + this.sessionId;
                pushTarget.addPathParameter(this.sessionPathParameterName, this.sessionId);
            }
            if (this.addSessionCookie) {
                this.cookies.add(new Cookie(this.sessionCookieName, this.sessionId));
            }
        }
        pushTarget.requestURI().setString(pushPath);
        pushTarget.decodedURI().setString(ApplicationPushBuilder.decode(pushPath, this.catalinaRequest.getConnector().getURIEncodingLower()));
        if (pushQueryString == null && this.queryString != null) {
            pushTarget.queryString().setString(this.queryString);
        } else if (pushQueryString != null && this.queryString == null) {
            pushTarget.queryString().setString(pushQueryString);
        } else if (pushQueryString != null && this.queryString != null) {
            pushTarget.queryString().setString(pushQueryString + "&" + this.queryString);
        }
        if (this.conditional) {
            if (this.eTag != null) {
                this.setHeader("if-none-match", this.eTag);
            } else if (this.lastModified != null) {
                this.setHeader("if-modified-since", this.lastModified);
            }
        }
        this.setHeader("cookie", ApplicationPushBuilder.generateCookieHeader(this.cookies, this.catalinaRequest.getContext().getCookieProcessor()));
        this.coyoteRequest.action(ActionCode.PUSH_REQUEST, (Object)pushTarget);
        pushTarget = null;
        this.path = null;
        this.eTag = null;
        this.lastModified = null;
        this.headers.remove("if-none-match");
        this.headers.remove("if-modified-since");
    }

    static String decode(String input, String charsetName) {
        Charset charset;
        int start = input.indexOf(37);
        int end = 0;
        if (start == -1) {
            return input;
        }
        try {
            charset = B2CConverter.getCharsetLower((String)charsetName);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
        StringBuilder result = new StringBuilder(input.length());
        while (start != -1) {
            result.append(input.substring(end, start));
            for (end = start + 3; end < input.length() && input.charAt(end) == '%'; end += 3) {
            }
            result.append(ApplicationPushBuilder.decode(input.substring(start, end), charset));
            start = input.indexOf(37, end);
        }
        result.append(input.substring(end));
        return result.toString();
    }

    private static String decode(String percentSequence, Charset charset) {
        byte[] bytes = new byte[percentSequence.length() / 3];
        for (int i = 0; i < bytes.length; i += 3) {
            bytes[i] = (byte)(HexUtils.getDec((int)percentSequence.charAt(1 + 3 * i)) << 4 + HexUtils.getDec((int)percentSequence.charAt(2 + 3 * i)));
        }
        return new String(bytes, charset);
    }

    private static String generateCookieHeader(List<Cookie> cookies, CookieProcessor cookieProcessor) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Cookie cookie : cookies) {
            if (first) {
                first = false;
            } else {
                result.append(';');
            }
            result.append(cookieProcessor.generateHeader(cookie));
        }
        return result.toString();
    }

    static {
        DISALLOWED_METHODS.add("POST");
        DISALLOWED_METHODS.add("PUT");
        DISALLOWED_METHODS.add("DELETE");
        DISALLOWED_METHODS.add("CONNECT");
        DISALLOWED_METHODS.add("OPTIONS");
        DISALLOWED_METHODS.add("TRACE");
    }
}

