/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.IOException;
import net.sf.expectit.Expect;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.SingleInputExpect;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.Matchers;

abstract class AbstractExpectImpl
implements Expect {
    private final long timeout;

    AbstractExpectImpl(long timeoutMs) {
        this.timeout = timeoutMs;
    }

    long getTimeout() {
        return this.timeout;
    }

    @Override
    public abstract <R extends Result> R expectIn(int var1, long var2, Matcher<R> var4) throws IOException;

    @Override
    public MultiResult expectIn(int input, long timeoutMs, Matcher<?> ... matchers) throws IOException {
        return this.expectIn(input, timeoutMs, (Matcher<R>)Matchers.allOf(matchers));
    }

    @Override
    public <R extends Result> R expectIn(int input, Matcher<R> matcher) throws IOException {
        return this.expectIn(input, this.timeout, matcher);
    }

    @Override
    public <R extends Result> R expect(Matcher<R> matcher) throws IOException {
        return this.expectIn(0, matcher);
    }

    @Override
    public MultiResult expect(Matcher<?> ... matchers) throws IOException {
        return this.expect(0L, matchers);
    }

    @Override
    public <R extends Result> R expect(long timeoutMs, Matcher<R> matcher) throws IOException {
        return this.expectIn(0, timeoutMs, matcher);
    }

    @Override
    public MultiResult expect(long timeoutMs, Matcher<?> ... matchers) throws IOException {
        return this.expectIn(0, timeoutMs, matchers);
    }

    abstract SingleInputExpect[] getInputs();
}

