/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Pipe;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import net.sf.expectit.AppendableAdapter;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectImpl;
import net.sf.expectit.SingleInputExpect;
import net.sf.expectit.echo.EchoOutput;
import net.sf.expectit.filter.Filter;
import net.sf.expectit.filter.Filters;

public class ExpectBuilder {
    public static final int DEFAULT_TIMEOUT_MS = 30000;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private InputStream[] inputs;
    private Filter filter;
    private OutputStream output;
    private long timeout = 30000L;
    private EchoOutput echoOutputOld;
    private Charset charset = Charset.defaultCharset();
    @Deprecated
    private boolean errorOnTimeout;
    private String lineSeparator = "\n";
    private Appendable echoOutput;
    private Appendable echoInput;
    private Appendable[] echoInputs;
    private int bufferSize = 1024;
    private boolean exceptionOnFailure;
    private boolean autoFlushEcho;
    private boolean combineInputs;

    public final ExpectBuilder withOutput(OutputStream output) {
        this.output = output;
        return this;
    }

    public final ExpectBuilder withInputs(InputStream ... inputs) {
        this.inputs = inputs;
        return this;
    }

    public final ExpectBuilder withTimeout(long duration, TimeUnit unit) {
        ExpectBuilder.validateDuration(duration);
        this.timeout = unit.toMillis(duration);
        return this;
    }

    static void validateDuration(long duration) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration <= 0");
        }
    }

    public final ExpectBuilder withInfiniteTimeout() {
        this.timeout = -1L;
        return this;
    }

    @Deprecated
    public final ExpectBuilder withEchoOutput(EchoOutput echoOutput) {
        this.echoOutputOld = echoOutput;
        return this;
    }

    public final ExpectBuilder withEchoOutput(Appendable echoOutput) {
        this.echoOutput = echoOutput;
        return this;
    }

    public final ExpectBuilder withEchoInput(Appendable firstInput, Appendable ... otherInputs) {
        this.echoInput = firstInput;
        this.echoInputs = otherInputs;
        return this;
    }

    public final ExpectBuilder withCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public final ExpectBuilder withInputFilters(Filter filter, Filter ... moreFilters) {
        if (moreFilters.length == 0) {
            this.filter = filter;
        } else {
            Filter[] filters = new Filter[moreFilters.length + 1];
            filters[0] = filter;
            System.arraycopy(moreFilters, 0, filters, 1, moreFilters.length);
            this.filter = Filters.chain(filters);
        }
        return this;
    }

    @Deprecated
    public final ExpectBuilder withErrorOnTimeout(boolean errorOnTimeout) {
        this.errorOnTimeout = errorOnTimeout;
        return this;
    }

    public final ExpectBuilder withExceptionOnFailure() {
        this.exceptionOnFailure = true;
        return this;
    }

    public final ExpectBuilder withLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public final ExpectBuilder withBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        this.bufferSize = bufferSize;
        return this;
    }

    public final ExpectBuilder withAutoFlushEcho(boolean autoFlushEcho) {
        this.autoFlushEcho = autoFlushEcho;
        return this;
    }

    public final ExpectBuilder withCombineInputs(boolean combineInputs) {
        this.combineInputs = combineInputs;
        return this;
    }

    public final Expect build() throws IOException {
        if (this.inputs == null || this.inputs.length == 0) {
            throw new IllegalStateException("Inputs are null or empty");
        }
        if (this.echoInputs != null && this.echoInputs.length != 0 && this.echoInputs.length != this.inputs.length - 1) {
            throw new IllegalArgumentException("The number of echo input does not correspond to the total number of the input streams");
        }
        SingleInputExpect[] inputs = new SingleInputExpect[this.inputs.length];
        Pipe pipe = null;
        Pipe.SourceChannel source = null;
        Pipe.SinkChannel sink = null;
        for (int i = 0; i < inputs.length; ++i) {
            if (!this.combineInputs || pipe == null) {
                pipe = Pipe.open();
                source = pipe.source();
                sink = pipe.sink();
            }
            inputs[i] = new SingleInputExpect(source, sink, this.inputs[i], this.charset, this.getEchoInputForIndex(i), this.filter, this.bufferSize, this.autoFlushEcho);
        }
        if (this.echoOutputOld != null) {
            this.echoOutput = new AppendableAdapter(){

                @Override
                public Appendable append(CharSequence csq) throws IOException {
                    ExpectBuilder.this.echoOutputOld.onSend(csq.toString());
                    return this;
                }
            };
        }
        ExpectImpl instance = new ExpectImpl(this.timeout, this.output, inputs, this.charset, this.echoOutput, this.errorOnTimeout, this.lineSeparator, this.exceptionOnFailure, this.autoFlushEcho);
        instance.start();
        return instance;
    }

    private Appendable getEchoInputForIndex(final int i) {
        if (this.echoOutputOld != null) {
            return new AppendableAdapter(){

                @Override
                public Appendable append(CharSequence csq) throws IOException {
                    ExpectBuilder.this.echoOutputOld.onReceive(i, csq.toString());
                    return this;
                }
            };
        }
        if (this.echoInput == null) {
            return null;
        }
        if (this.echoInputs.length == 0 || i == 0) {
            return this.echoInput;
        }
        return this.echoInputs[i - 1];
    }
}

