/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.expectit.AbstractExpectImpl;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.ExpectIOException;
import net.sf.expectit.ExpectTimeoutAdapter;
import net.sf.expectit.InteractBuilderImpl;
import net.sf.expectit.NamedExecutorThreadFactory;
import net.sf.expectit.Result;
import net.sf.expectit.SingleInputExpect;
import net.sf.expectit.Utils;
import net.sf.expectit.interact.InteractBuilder;
import net.sf.expectit.matcher.Matcher;

class ExpectImpl
extends AbstractExpectImpl {
    private static final Logger LOG = Logger.getLogger(ExpectImpl.class.getName());
    static final int INFINITE_TIMEOUT = -1;
    private final OutputStream output;
    private final SingleInputExpect[] inputs;
    private final Charset charset;
    private final Appendable echoOutput;
    @Deprecated
    private final boolean errorOnTimeout;
    private final ExecutorService executor;
    private final String lineSeparator;
    private final boolean exceptionOnFailure;
    private final boolean autoFlushEcho;

    ExpectImpl(long timeout, OutputStream output, SingleInputExpect[] inputs, Charset charset, Appendable echoOutput, boolean errorOnTimeoutOld, String lineSeparator, boolean exceptionOnFailure, boolean autoFlushEcho) {
        super(timeout);
        this.output = output;
        this.inputs = inputs;
        this.charset = charset;
        this.echoOutput = echoOutput;
        this.errorOnTimeout = errorOnTimeoutOld;
        this.exceptionOnFailure = exceptionOnFailure;
        this.lineSeparator = lineSeparator;
        this.autoFlushEcho = autoFlushEcho;
        this.executor = Executors.newFixedThreadPool(inputs.length, new NamedExecutorThreadFactory("expect-"));
    }

    void start() {
        for (SingleInputExpect input : this.inputs) {
            input.start(this.executor);
        }
    }

    @Override
    public <R extends Result> R expectIn(int input, long timeoutMs, Matcher<R> matcher) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Expect matcher '%s' with timeout %d (ms) in input #%d", Utils.toDebugString(matcher), timeoutMs, input));
        }
        R result = this.inputs[input].expect(timeoutMs, matcher);
        if (this.exceptionOnFailure && !result.isSuccessful()) {
            String inputBuffer = this.inputs[input].getBuffer().toString();
            throw new ExpectIOException("Expect operation fails (timeout: " + timeoutMs + " ms) for matcher: " + matcher, inputBuffer);
        }
        if (this.errorOnTimeout && !result.isSuccessful()) {
            throw new AssertionError((Object)("Expect timeout (" + timeoutMs + " ms) for matcher: " + matcher));
        }
        return result;
    }

    @Override
    public Expect withTimeout(long duration, TimeUnit unit) {
        ExpectBuilder.validateDuration(duration);
        return new ExpectTimeoutAdapter(this, unit.toMillis(duration));
    }

    @Override
    public Expect withInfiniteTimeout() {
        return new ExpectTimeoutAdapter(this, -1L);
    }

    @Override
    public Expect send(String string) throws IOException {
        byte[] bytes = string.getBytes(this.charset);
        this.writeBytes(bytes);
        this.echoString(string);
        return this;
    }

    @Override
    public Expect sendLine() throws IOException {
        return this.sendLine("");
    }

    @Override
    public Expect sendLine(String string) throws IOException {
        return this.send(string + this.lineSeparator);
    }

    @Override
    public Expect sendBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes);
        this.echoString(new String(bytes, this.charset));
        return this;
    }

    private void writeBytes(byte[] bytes) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing bytes: " + Utils.toDebugString(bytes, bytes.length, this.charset));
        }
        this.output.write(bytes);
        this.output.flush();
    }

    private void echoString(String string) throws IOException {
        if (this.echoOutput != null) {
            this.echoOutput.append(string);
            if (this.autoFlushEcho) {
                Utils.flushAppendable(this.echoOutput);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (SingleInputExpect input : this.inputs) {
            input.stop();
        }
        this.executor.shutdown();
        if (this.autoFlushEcho) {
            Utils.flushAppendable(this.echoOutput);
        }
    }

    @Override
    public InteractBuilder interact() {
        return this.interactWith(0);
    }

    @Override
    public InteractBuilder interactWith(int input) {
        return this.interactWithInternal(this, input);
    }

    InteractBuilder interactWithInternal(AbstractExpectImpl expect, int input) {
        if (input >= this.inputs.length || input < 0) {
            throw new IllegalArgumentException("Input index is out of bounds: " + input);
        }
        return new InteractBuilderImpl(expect, input);
    }

    @Override
    SingleInputExpect[] getInputs() {
        return this.inputs;
    }
}

