/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.expectit.Utils;

class InputStreamCopier
implements Callable<Object> {
    private static final Logger LOG = Logger.getLogger(InputStreamCopier.class.getName());
    private final InputStream from;
    private final WritableByteChannel to;
    private final int bufferSize;
    private final Appendable echo;
    private final Charset charset;
    private final boolean autoFlushEcho;

    InputStreamCopier(WritableByteChannel to, InputStream from, int bufferSize, Appendable echo, Charset charset, boolean autoFlushEcho) {
        this.from = from;
        this.to = to;
        this.bufferSize = bufferSize;
        this.echo = echo;
        this.charset = charset;
        this.autoFlushEcho = autoFlushEcho;
    }

    @Override
    public Object call() throws Exception {
        byte[] buffer = new byte[this.bufferSize];
        try {
            int bytesRead;
            while ((bytesRead = this.from.read(buffer)) != -1) {
                this.to.write(ByteBuffer.wrap(buffer, 0, bytesRead));
                if (LOG.isLoggable(Level.FINE) && bytesRead > 0) {
                    LOG.fine(String.format("Received from %s: %s", this.from, Utils.toDebugString(buffer, bytesRead, this.charset)));
                }
                if (this.echo == null || bytesRead <= 0) continue;
                this.printEcho(buffer, bytesRead);
            }
        }
        finally {
            this.to.close();
        }
        return null;
    }

    private void printEcho(byte[] buffer, int bytesRead) throws IOException {
        if (this.charset == null) {
            if (this.echo instanceof OutputStream) {
                ((OutputStream)((Object)this.echo)).write(buffer, 0, bytesRead);
            } else {
                this.echo.append(new String(buffer, 0, bytesRead, Charset.defaultCharset()));
            }
        } else {
            this.echo.append(new String(buffer, 0, bytesRead, this.charset));
        }
        if (this.autoFlushEcho) {
            Utils.flushAppendable(this.echo);
        }
    }
}

