/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.expectit.AbstractExpectImpl;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.SingleInputExpect;
import net.sf.expectit.interact.Action;
import net.sf.expectit.interact.InteractBuilder;
import net.sf.expectit.interact.OngoingResult;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.Matchers;
import net.sf.expectit.matcher.SimpleResult;

class InteractBuilderImpl
implements InteractBuilder {
    private static final Logger LOG = Logger.getLogger(SingleInputExpect.class.getName());
    private final AbstractExpectImpl expect;
    private final int input;
    private final List<Matcher<?>> matchers = new ArrayList();
    private final List<Action> actions = new ArrayList<Action>();

    public InteractBuilderImpl(AbstractExpectImpl expect, int input) {
        this.expect = expect;
        this.input = input;
    }

    @Override
    public <R extends Result> OngoingResult<R> when(final Matcher<R> matcher) {
        return new OngoingResult<R>(){

            @Override
            public InteractBuilder then(Action action) {
                if (action == null) {
                    throw new NullPointerException("Action cannot be null");
                }
                InteractBuilderImpl.this.matchers.add(matcher);
                InteractBuilderImpl.this.actions.add(action);
                return InteractBuilderImpl.this;
            }
        };
    }

    @Override
    public <R extends Result> R until(Matcher<R> matcher) throws IOException {
        InternalResult untilResult;
        boolean matched;
        Matcher[] array = new Matcher[this.matchers.size() + 1];
        for (int i = 0; i < this.matchers.size(); ++i) {
            array[i + 1] = this.matchers.get(i);
        }
        array[0] = new ResultMatcher(matcher);
        do {
            long time = System.currentTimeMillis();
            MultiResult multiResult = this.expect.expectIn(this.input, Matchers.anyOf(array));
            String inputBuffer = this.expect.getInputs()[this.input].getBuffer().toString();
            if (System.currentTimeMillis() - time > this.expect.getTimeout()) {
                LOG.fine("Until matching operation timeout");
                return (R)SimpleResult.failure(inputBuffer, true);
            }
            untilResult = (InternalResult)multiResult.getResults().get(0);
            matched = false;
            for (int i = 0; i < multiResult.getResults().size() - 1; ++i) {
                Result result = multiResult.getResults().get(i + 1);
                if (!result.isSuccessful() || untilResult.isSuccessful() && untilResult.getResult().end() <= result.end()) continue;
                matched = true;
                LOG.fine("Condition #" + i + " matched: " + result);
                this.actions.get(i).apply(result);
            }
        } while (matched || !untilResult.isSuccessful());
        LOG.fine("Until condition is successful");
        return (R)untilResult.getResult();
    }

    private static class ResultMatcher
    implements Matcher<Result> {
        private final Matcher<Result> matcher;

        public ResultMatcher(Matcher<Result> matcher) {
            this.matcher = matcher;
        }

        @Override
        public Result matches(String input, boolean isEof) {
            Result result = this.matcher.matches(input, isEof);
            return new InternalResult(result, input);
        }

        public String toString() {
            return this.matcher.toString();
        }
    }

    private static class InternalResult
    extends SimpleResult {
        private final Result result;

        public InternalResult(Result result, String input) {
            super(result.isSuccessful(), input, "", "", result.canStopMatching());
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }
    }
}

