/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.expectit.InputStreamCopier;
import net.sf.expectit.Result;
import net.sf.expectit.Utils;
import net.sf.expectit.filter.Filter;
import net.sf.expectit.matcher.Matcher;

class SingleInputExpect {
    private static final Logger LOG = Logger.getLogger(SingleInputExpect.class.getName());
    public static final int BUFFER_SIZE = 1024;
    private final InputStream input;
    private final StringBuilder buffer;
    private final Charset charset;
    private final Appendable echoInput;
    private final Filter filter;
    private Future<Object> copierFuture;
    private final Pipe.SourceChannel source;
    private final Pipe.SinkChannel sink;
    private final int bufferSize;
    private final boolean autoFlushEcho;

    protected SingleInputExpect(Pipe.SourceChannel source, Pipe.SinkChannel sink, InputStream input, Charset charset, Appendable echoInput, Filter filter, int bufferSize, boolean autoFlushEcho) throws IOException {
        this.input = input;
        this.charset = charset;
        this.echoInput = echoInput;
        this.filter = filter;
        this.bufferSize = bufferSize;
        this.autoFlushEcho = autoFlushEcho;
        this.source = source;
        this.sink = sink;
        source.configureBlocking(false);
        this.buffer = new StringBuilder();
    }

    public void start(ExecutorService executor) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Starting expect thread: input=%s, charset=%s, echoInput=%s, filter=%s, bufferSize=%d", this.input, this.charset, this.echoInput, this.filter, this.bufferSize));
        }
        this.copierFuture = executor.submit(new InputStreamCopier(this.sink, this.input, this.bufferSize, this.echoInput, this.charset, this.autoFlushEcho));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Result> R expect(long timeoutMs, Matcher<R> matcher) throws IOException {
        if (this.copierFuture == null) {
            throw new IllegalStateException("Not started");
        }
        long timeToStop = System.currentTimeMillis() + timeoutMs;
        boolean isInfiniteTimeout = timeoutMs == -1L;
        long timeElapsed = timeoutMs;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        Selector selector = Selector.open();
        try {
            this.source.register(selector, 1);
            R result = matcher.matches(this.buffer.toString(), this.copierFuture.isDone());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Initial matcher %s result: %s", Utils.toDebugString(matcher), Utils.toDebugString(result)));
            }
            while (!(result.isSuccessful() || result.canStopMatching() || !isInfiniteTimeout && timeElapsed <= 0L)) {
                int keys;
                int n = keys = isInfiniteTimeout ? selector.select() : selector.select(timeElapsed);
                if (Thread.currentThread().isInterrupted()) {
                    LOG.fine("Thread was interrupted");
                    throw new ClosedByInterruptException();
                }
                if (!isInfiniteTimeout) {
                    timeElapsed = timeToStop - System.currentTimeMillis();
                }
                if (keys == 0) {
                    LOG.fine("Selector returns 0 key");
                    continue;
                }
                selector.selectedKeys().clear();
                int len = this.source.read(byteBuffer);
                if (len > 0) {
                    String string = new String(byteBuffer.array(), 0, len, this.charset);
                    this.processString(string);
                    byteBuffer.clear();
                }
                result = matcher.matches(this.buffer.toString(), len == -1);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine(String.format("Matcher %s result: %s. Operation time: %d ms", Utils.toDebugString(matcher), Utils.toDebugString(result), timeoutMs - timeElapsed));
            }
            if (result.isSuccessful()) {
                this.buffer.delete(0, result.end());
            } else if (this.copierFuture.isDone() && this.buffer.length() == 0) {
                throw new EOFException("Input closed");
            }
            R r = result;
            return r;
        }
        finally {
            selector.close();
        }
    }

    private void processString(String string) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing string: " + Utils.toDebugString(string));
        }
        if (this.filter != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Before append filter: " + Utils.toDebugString(this.filter));
            }
            string = this.filter.beforeAppend(string, this.buffer);
        }
        if (string != null) {
            this.buffer.append(string);
            if (this.filter != null) {
                LOG.fine("After append filter: " + Utils.toDebugString(this.filter));
                this.filter.afterAppend(this.buffer);
            }
        }
    }

    public void stop() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Releasing resources for input: " + this.input);
        }
        if (this.copierFuture != null) {
            this.copierFuture.cancel(true);
        }
        this.sink.close();
        this.source.close();
        if (this.autoFlushEcho) {
            Utils.flushAppendable(this.echoInput);
        }
    }

    StringBuilder getBuffer() {
        return this.buffer;
    }
}

