/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit;

import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;

final class Utils {
    static final int MAX_STRING_LENGTH = 200;

    private Utils() {
    }

    static String toDebugString(byte[] bytes, int len, Charset charset) {
        if (charset == null) {
            return Utils.toDebugString(new String(bytes, 0, len, Charset.defaultCharset()));
        }
        return Utils.toDebugString(new String(bytes, 0, len, charset));
    }

    static String toDebugString(String string) {
        if (string == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            if (i <= 200) continue;
            builder.append(" ... (");
            builder.append(string.length() - i);
            builder.append(" char more)");
            break;
        }
        return builder.toString();
    }

    static String toDebugString(Object object) {
        return Utils.toDebugString(String.valueOf(object));
    }

    static void flushAppendable(Appendable appendable) throws IOException {
        if (appendable instanceof Flushable) {
            ((Flushable)((Object)appendable)).flush();
        }
    }
}

