/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.expectit.filter.Filter;
import net.sf.expectit.filter.FilterAdapter;

public final class Filters {
    private static final String COLORS_REGEXP_STRING = "\\x1b\\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]";
    public static final Pattern COLORS_PATTERN = Pattern.compile("\\x1b\\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]");
    public static final Pattern NON_PRINTABLE_PATTERN = Pattern.compile("[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]");

    private Filters() {
    }

    public static Filter removeNonPrintable() {
        return Filters.replaceInString(NON_PRINTABLE_PATTERN, "");
    }

    public static Filter replaceInString(final Pattern regexp, final String replacement) {
        return new FilterAdapter(){

            @Override
            protected String doBeforeAppend(String string, StringBuilder buffer) {
                return regexp.matcher(string).replaceAll(replacement);
            }
        };
    }

    public static Filter replaceInString(String regexp, String replacement) {
        return Filters.replaceInString(Pattern.compile(regexp), replacement);
    }

    public static Filter removeColors() {
        return Filters.replaceInString(COLORS_PATTERN, "");
    }

    public static Filter replaceInBuffer(String regexp, String replacement) {
        return Filters.replaceInBuffer(Pattern.compile(regexp), replacement);
    }

    public static Filter replaceInBuffer(final Pattern regexp, final String replacement) {
        return new FilterAdapter(){

            @Override
            protected boolean doAfterAppend(StringBuilder buffer) {
                Matcher matcher = regexp.matcher(buffer);
                String str = matcher.replaceAll(replacement);
                buffer.replace(0, buffer.length(), str);
                return false;
            }
        };
    }

    public static Filter chain(final Filter ... filters) {
        return new FilterAdapter(){

            @Override
            protected String doBeforeAppend(String string, StringBuilder buffer) {
                String previousResult = null;
                for (Filter filter : filters) {
                    if ((string = filter.beforeAppend(string, buffer)) == null) {
                        return previousResult;
                    }
                    previousResult = string;
                }
                return string;
            }

            @Override
            protected boolean doAfterAppend(StringBuilder buffer) {
                for (Filter filter : filters) {
                    if (!filter.afterAppend(buffer)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

