/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.matcher;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.MultiMatcher;
import net.sf.expectit.matcher.MultiResultImpl;
import net.sf.expectit.matcher.RegexpMatcher;
import net.sf.expectit.matcher.SimpleResult;

public final class Matchers {
    private Matchers() {
    }

    public static Matcher<Result> matches(String pattern) {
        return Matchers.matches(Pattern.compile(pattern));
    }

    public static Matcher<Result> matches(Pattern pattern) {
        return new RegexpMatcher(pattern, false);
    }

    public static Matcher<Result> regexp(String pattern) {
        return Matchers.regexp(Pattern.compile(pattern));
    }

    public static Matcher<Result> regexp(Pattern pattern) {
        return new RegexpMatcher(pattern, true);
    }

    public static Matcher<Result> contains(final String string) {
        return new Matcher<Result>(){

            @Override
            public Result matches(String input, boolean isEof) {
                int pos = input.indexOf(string);
                return pos != -1 ? SimpleResult.success(input, input.substring(0, pos), string) : SimpleResult.failure(input, false);
            }

            public String toString() {
                return Matchers.generateToString("contains", string);
            }
        };
    }

    public static Matcher<MultiResult> allOf(Matcher<?> ... matchers) {
        Matchers.checkNotEmpty(matchers);
        return new MultiMatcher(true, matchers);
    }

    public static Matcher<MultiResult> anyOf(Matcher<?> ... matchers) {
        Matchers.checkNotEmpty(matchers);
        return new MultiMatcher(false, matchers);
    }

    public static Matcher<Result> eof() {
        return new Matcher<Result>(){

            @Override
            public Result matches(String input, boolean isEof) {
                return isEof ? SimpleResult.success(input, input, "") : SimpleResult.failure(input, false);
            }

            public String toString() {
                return "eof";
            }
        };
    }

    public static Matcher<MultiResult> times(int number, Matcher<?> matcher) {
        Object[] matchers = new Matcher[number];
        Arrays.fill(matchers, matcher);
        return Matchers.sequence(matchers);
    }

    public static Matcher<MultiResult> sequence(final Matcher<?> ... matchers) {
        Matchers.checkNotEmpty(matchers);
        return new Matcher<MultiResult>(){

            @Override
            public MultiResult matches(String input, boolean isEof) {
                Object result;
                int matchCount = 0;
                Object[] results = new Result[matchers.length];
                Arrays.fill(results, SimpleResult.failure(input, false));
                int beginIndex = 0;
                for (int i = 0; i < matchers.length && (result = matchers[i].matches(input.substring(beginIndex), isEof)).isSuccessful(); ++i) {
                    beginIndex += result.end();
                    results[i] = result;
                    if (++matchCount != matchers.length) continue;
                    String group = result.group();
                    SimpleResult finalResult = new SimpleResult(true, input, input.substring(0, beginIndex - group.length()), group, result.canStopMatching());
                    return new MultiResultImpl(finalResult, Arrays.asList(results));
                }
                List<Object> resultList = Arrays.asList(results);
                boolean canStopMatching = MultiResultImpl.canStopMatching(resultList);
                return new MultiResultImpl(SimpleResult.failure(input, canStopMatching), resultList);
            }

            public String toString() {
                return String.format("sequence(%s)", MultiMatcher.matchersToString(matchers));
            }
        };
    }

    public static Matcher<Result> anyString() {
        return new Matcher<Result>(){

            @Override
            public Result matches(String input, boolean isEof) {
                return input.length() > 0 ? SimpleResult.success(input, "", input) : SimpleResult.failure(input, false);
            }

            public String toString() {
                return "anyString";
            }
        };
    }

    private static void checkNotEmpty(Matcher<?>[] matchers) {
        if (matchers.length == 0) {
            throw new IllegalArgumentException("Matchers cannot be empty");
        }
    }

    static String generateToString(String name, Object parameter) {
        return String.format("%s('%s')", name, parameter);
    }

    public static Matcher<Result> exact(final String exact) {
        return new Matcher<Result>(){

            @Override
            public Result matches(String input, boolean isEof) {
                return exact.equals(input) ? SimpleResult.success(input, "", input) : SimpleResult.failure(input, input.length() > exact.length());
            }

            public String toString() {
                return Matchers.generateToString("exact", exact);
            }
        };
    }

    public static Matcher<Result> startsWith(final String prefix) {
        return new Matcher<Result>(){

            @Override
            public Result matches(String input, boolean isEof) {
                return input.startsWith(prefix) ? SimpleResult.success(input, "", prefix) : SimpleResult.failure(input, input.length() > prefix.length());
            }

            public String toString() {
                return Matchers.generateToString("startsWith", prefix);
            }
        };
    }
}

