/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.MultiResultImpl;

class MultiMatcher
implements Matcher<MultiResult> {
    private final Matcher<?>[] matchers;
    private final boolean allOperation;

    public MultiMatcher(boolean allOperation, Matcher<?> ... matchers) {
        this.matchers = matchers;
        this.allOperation = allOperation;
    }

    @Override
    public MultiResult matches(String input, boolean isEof) {
        ArrayList<Result> results = new ArrayList<Result>();
        ArrayList<Result> successResults = new ArrayList<Result>();
        Result firstFailResult = null;
        for (Matcher<?> matcher : this.matchers) {
            Object result = matcher.matches(input, isEof);
            if (result.isSuccessful()) {
                successResults.add((Result)result);
            } else if (firstFailResult == null) {
                firstFailResult = (Result)result;
            }
            results.add((Result)result);
        }
        Result delegate = this.allOperation ? this.getAllOfResult(successResults, firstFailResult) : this.getAnyOfResult(successResults, results);
        return new MultiResultImpl(delegate, results);
    }

    private Result getAllOfResult(List<Result> successResults, Result firstFailResult) {
        if (firstFailResult == null) {
            return MultiMatcher.findResultWithMaxEnd(successResults);
        }
        return firstFailResult;
    }

    private Result getAnyOfResult(List<Result> successResults, List<Result> results) {
        if (successResults.size() > 0) {
            return MultiMatcher.findResultWithMaxEnd(successResults);
        }
        return results.get(0);
    }

    private static Result findResultWithMaxEnd(List<Result> successResults) {
        return Collections.max(successResults, new Comparator<Result>(){

            @Override
            public int compare(Result o1, Result o2) {
                return Integer.valueOf(o1.end()).compareTo(o2.end());
            }
        });
    }

    public String toString() {
        StringBuilder matchersString = MultiMatcher.matchersToString(this.matchers);
        if (this.allOperation) {
            return String.format("allOf(%s)", matchersString);
        }
        return String.format("anyOf(%s)", matchersString);
    }

    static StringBuilder matchersToString(Matcher ... matchers) {
        StringBuilder matchersString = new StringBuilder();
        for (Matcher matcher : matchers) {
            if (matchersString.length() > 0) {
                matchersString.append(',');
            }
            matchersString.append(String.valueOf(matcher));
        }
        return matchersString;
    }
}

