/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.matcher;

import java.util.Collections;
import java.util.List;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;

class MultiResultImpl
implements MultiResult {
    private final List<Result> results;
    private final Result delegate;
    private final boolean canStopMatching;

    MultiResultImpl(Result delegate, List<Result> results) {
        this.delegate = delegate;
        this.results = results;
        this.canStopMatching = MultiResultImpl.canStopMatching(results);
    }

    @Override
    public String getInput() {
        return this.delegate.getInput();
    }

    @Override
    public boolean isSuccessful() {
        return this.delegate.isSuccessful();
    }

    @Override
    public String getBefore() {
        return this.delegate.getBefore();
    }

    @Override
    public boolean canStopMatching() {
        return this.canStopMatching;
    }

    @Override
    public int start() {
        return this.delegate.start();
    }

    @Override
    public int start(int group) {
        return this.delegate.start(group);
    }

    @Override
    public int end() {
        return this.delegate.end();
    }

    @Override
    public int end(int group) {
        return this.delegate.end(group);
    }

    @Override
    public String group() {
        return this.delegate.group();
    }

    @Override
    public String group(int group) {
        return this.delegate.group(group);
    }

    @Override
    public int groupCount() {
        return this.delegate.groupCount();
    }

    @Override
    public List<Result> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    static boolean canStopMatching(List<Result> results) {
        boolean canStopMatching = false;
        for (Result r : results) {
            if (!r.canStopMatching()) {
                return false;
            }
            canStopMatching = true;
        }
        return canStopMatching;
    }

    public String toString() {
        return "MultiResultImpl{results=" + this.results + ", delegate=" + this.delegate + ", canStopMatching=" + this.canStopMatching + '}';
    }
}

