/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.matcher;

import java.util.regex.Pattern;
import net.sf.expectit.Result;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.Matchers;
import net.sf.expectit.matcher.RegexpResult;
import net.sf.expectit.matcher.SimpleResult;

class RegexpMatcher
implements Matcher<Result> {
    private final Pattern pattern;
    private final boolean useFind;

    public RegexpMatcher(Pattern pattern, boolean useFind) {
        this.pattern = pattern;
        this.useFind = useFind;
    }

    @Override
    public Result matches(String input, boolean isEof) {
        java.util.regex.Matcher matcher = this.pattern.matcher(input);
        boolean result = this.useFind ? matcher.find() : matcher.matches();
        if (result) {
            return new RegexpResult(true, input, input.substring(0, matcher.start()), matcher);
        }
        return SimpleResult.failure(input, false);
    }

    public String toString() {
        if (this.useFind) {
            return Matchers.generateToString("regexp", this.pattern);
        }
        return Matchers.generateToString("matches", this.pattern);
    }
}

