/*
 * Decompiled with CFR 0.152.
 */
package net.sf.expectit.matcher;

import net.sf.expectit.Result;

public class SimpleResult
implements Result {
    private final boolean succeeded;
    private final String before;
    private final String group;
    private final String input;
    private final boolean canStopMatching;

    protected SimpleResult(boolean succeeded, String input, String before, String group, boolean canStopMatching) {
        this.succeeded = succeeded;
        this.input = input;
        this.before = before;
        this.group = group;
        this.canStopMatching = canStopMatching;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public boolean isSuccessful() {
        return this.succeeded;
    }

    @Override
    public String getBefore() {
        this.checkSucceeded();
        return this.before;
    }

    @Override
    public boolean canStopMatching() {
        return this.canStopMatching;
    }

    @Override
    public int start() {
        return this.getBefore().length();
    }

    @Override
    public int start(int group) {
        this.checkGroup(group);
        return this.start();
    }

    @Override
    public int end() {
        return this.start() + this.group().length();
    }

    @Override
    public int end(int group) {
        this.checkGroup(group);
        return this.end();
    }

    @Override
    public String group() {
        this.checkSucceeded();
        return this.group;
    }

    @Override
    public String group(int group) {
        this.checkGroup(group);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    void checkGroup(int group) {
        if (group != 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkSucceeded() {
        if (!this.succeeded) {
            throw new IllegalStateException();
        }
    }

    public static Result success(String input, String before, String group) {
        return new SimpleResult(true, input, before, group, true);
    }

    public static Result failure(String input, boolean canStopMatching) {
        return new SimpleResult(false, input, null, null, canStopMatching);
    }

    public String toString() {
        return "SimpleResult{succeeded=" + this.succeeded + ", before='" + this.before + '\'' + ", group='" + this.group + '\'' + ", input='" + this.input + '\'' + ", canStopMatching=" + this.canStopMatching + '}';
    }
}

