/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;

public abstract class JEditorPaneMarkupProcessor
implements MarkupProcessor {
    public static final JEditorPaneMarkupProcessor RTF = new JEditorPaneMarkupProcessor(){

        public String getContentType() {
            return "text/rtf";
        }
    };
    public static final JEditorPaneMarkupProcessor HTML = new JEditorPaneMarkupProcessor(){

        public String getContentType() {
            return "text/html";
        }
    };

    public String convert(String srcText) {
        JEditorPane editorPane = new JEditorPane(this.getContentType(), srcText);
        editorPane.setEditable(false);
        ArrayList elements = new ArrayList();
        Document document = editorPane.getDocument();
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        JRStyledText styledText = new JRStyledText();
        styledText.setGlobalAttributes(new HashMap());
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            String chunk = "";
            try {
                chunk = document.getText(startOffset, endOffset - startOffset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            styledText.append(chunk);
            styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset, endOffset));
        }
        return JRStyledTextParser.getInstance().write(styledText);
    }

    protected void addElements(List elements, Element element) {
        if (element instanceof AbstractDocument.LeafElement) {
            elements.add(element);
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element child = element.getElement(i);
            this.addElements(elements, child);
        }
    }

    protected Map getAttributes(AttributeSet attrSet) {
        HashMap<TextAttribute, Object> attrMap = new HashMap<TextAttribute, Object>();
        if (attrSet.isDefined(StyleConstants.FontFamily)) {
            attrMap.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Bold)) {
            attrMap.put(TextAttribute.WEIGHT, StyleConstants.isBold(attrSet) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Italic)) {
            attrMap.put(TextAttribute.POSTURE, StyleConstants.isItalic(attrSet) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Underline)) {
            attrMap.put(TextAttribute.UNDERLINE, StyleConstants.isUnderline(attrSet) ? TextAttribute.UNDERLINE_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.StrikeThrough)) {
            attrMap.put(TextAttribute.STRIKETHROUGH, StyleConstants.isStrikeThrough(attrSet) ? TextAttribute.STRIKETHROUGH_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.FontSize)) {
            attrMap.put(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(attrSet)));
        }
        if (attrSet.isDefined(StyleConstants.Foreground)) {
            attrMap.put(TextAttribute.FOREGROUND, StyleConstants.getForeground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Background)) {
            attrMap.put(TextAttribute.BACKGROUND, StyleConstants.getBackground(attrSet));
        }
        return attrMap;
    }

    public abstract String getContentType();

    public static final class HtmlFactory
    implements MarkupProcessorFactory {
        public MarkupProcessor createMarkupProcessor() {
            return HTML;
        }
    }

    public static final class RtfFactory
    implements MarkupProcessorFactory {
        public MarkupProcessor createMarkupProcessor() {
            return RTF;
        }
    }
}

