/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BatikRenderer
extends JRAbstractSvgRenderer
implements JRImageMapRenderer {
    private static final long serialVersionUID = 10200L;
    private String svgText;
    private List areaHyperlinks;

    public BatikRenderer(String svgText, List areaHyperlinks) {
        this.svgText = svgText;
        this.areaHyperlinks = areaHyperlinks;
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        try {
            UserAgentAdapter userAgent = new UserAgentAdapter();
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
            documentFactory.setValidating(userAgent.isXMLParserValidating());
            SVGDocument document = documentFactory.createSVGDocument("", (Reader)new StringReader(this.svgText));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode graphicsNode = builder.build(ctx, (Document)document);
            AffineTransform transform = ViewBox.getViewTransform(null, (Element)document.getRootElement(), (float)((float)rectangle.getWidth()), (float)((float)rectangle.getHeight()), (BridgeContext)ctx);
            Graphics2D graphics = (Graphics2D)grx.create();
            graphics.translate(rectangle.getX(), rectangle.getY());
            graphics.transform(transform);
            graphicsNode.paint(graphics);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public List renderWithHyperlinks(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(grx, rectangle);
        return this.areaHyperlinks;
    }

    public List getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return GraphicsUtil.createGraphics((BufferedImage)bi);
    }
}

