/*
function name chksafecodesc
parameter str: safe to be verified
return value: return true as safe code, only digitally, return false indicating safe code contains other characters..
*/
function chkSafeCodeSc(info)
{
	var str=info+"";
	if(str.length!=0)
	{
		var sc2=str.split(",");
	  	var num="0123456789";
	
	  	var result=true;
	  	
	  	for(var i=0;i<sc2.length;i++)
	  	{
	  		var sc=sc2[i].substring(sc2[i].length-1,sc2[i].length);
	  		if(num.indexOf(sc)>0)
			{
				result=true;
			}else
			{
				result=false;
				break;
			}
	  	}
	}else
	{
		result=false;
	}
  	
	return result;
}




/*
function name chknumandletter
parameter str: a string to be verifying
return value: true is returned as a string consisting only of numbers and letters, returning false indicating that the string contains other characters..
*/
function chkNumAndLetter(str)
{
	var result=true;
	var strScope="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    for(var i=0;i<str.length;i++)
	{
		var c=str.substring(i,i+1);  //charAt
		if(strScope.indexOf(c)==-1)
		{
			result=false;
		}
	}
	return result;
}


/*
function name chknumber
parameter str: a string to be verifying
return value: returns true, which is represented by a string consisting only of numbers, returning false indicating that the string contains other characters..
*/
function chkNumber(str)
{
	var result=true;
	var strScope="0123456789";
        for(var i=0;i<str.length;i++)
	{
		var c=str.substring(i,i+1);  //charAt
		if(strScope.indexOf(c)==-1)
		{
			result=false;
		}
	}
	return result;
}

function formatNum(obj)
{
	var t=obj.value;
	var len=obj.value.length;
	if(len!=0 && !isNaN(t))
	{
		if(t.indexOf('.')==-1)
		{
			obj.value=obj.value+".00";
		}
		else if(t.indexOf('.')==(len-2))
		{
			obj.value=obj.value+"0";	
		}
		else if(t.indexOf('.')==(len-1))
		{
			obj.value=obj.value+"00";
		}
	}
}


/*
function name: chkmaxlen
function: verifies whether the string str exceeds the length n, and if the operation length is n, it prompts."the maximum length of strname is n!"
parameter: str:the string to be verified.n represents the maximum length of a string.strname represents the meaning of a string, such as"full name","address"etc..
*/
function chkMaxLen(str,n,strname)  
{
   if(isNaN(n))
   {
     alert("development error, error call,n is not a digital type!");
	 return false;
   }
   else
   {
	 str=str+"";  //conversion to string type
     if(str.length>n)
	   {
	      alert(strname+"the maximum length is"+ n + "at present, the string has exceeded the length" + n + "!");
		  return false;
	   }
	 else
	   {
	      return true;
	   }
   }
}

/*
function name: chkvaluelength
function: verify that the string str is etc.at the length of n, if the operation is not etc.n is a hint"the most length of strname should be n!"
parameter: str:the string to be verified.n represents the maximum length of a string.strname represents the meaning of a string, such as"full name","address"etc..
*/
function chkValueLength(str,n,strname)  
{
   if(isNaN(n))
   {
     return "development error, error call,n is not a digital type!";
   }
   else
   {
	 str=str+"";  //conversion to string type
     if(str.length!=n)
	   {
	     return strname+"the length should be"+ n + "at present, the string is not etc.in length" + n + "!";
	   }
	 else
	   {
	      return "";
	   }
   }
}

/**
* function: remove superfluous space function
* trim:remove both sides of space ltrim:removal of left space rtrim: removal of right space
* usage:
*     var str = "  hello ";
*     str = str.trim();
*/
String.prototype.trim = function()
{
    return this.replace(/(^[\s]*)|([\s]*$)/g, "");
}
String.prototype.lTrim = function()
{
    return this.replace(/(^[\s]*)/g, "");
}
String.prototype.rTrim = function()
{
    return this.replace(/([\s]*$)/g, "");
}

/**
* function: to intercept the excess value after the numeric type
* parameter: num intercepted digits 
* usage:
*     var num = 2.333333;
*     num = num.trim(4);
*     return num = 2.3333;
* time: 2007-03-21
*/
Number.prototype.toCut = function(num)
{
	var a,b,c,i;
	a = this.toString();
	b = a.indexOf(".");
	c = a.length;
	if (num==0)
	{
		if (b!=-1)
		a = a.substring(0,b);
	}
	else
	{
		if (b==-1)
		{
			a = a + ".";
			for (i=1;i<=num;i++)
			a = a + "0";
		}
		else
		{
			a = a.substring(0,b+num+1);
			
			for (i=c;i<=b+num;i++)
			a = a + "0";
		}
	}
	return a;
}

/*the digital check part uses the isnan function in the java script..*/
function chkFloatLen(str_num,x,y)
{
	if (isNaN(x)||isNaN(y))
	{
		alert("development error: parameterx,the y type should be a digital type!");
		return false;
	}
  if(isNaN(str_num))
	{
        alert(str_num + "for non - digital type!");
		return false;
    }
 else
	{
       str_num=str_num.trim();
	   var a=str_num.split(".");
	   if (a.length==2)
	   {
		   if (a[0].length>x&&a[1].length>y)
		   {
			   alert("the number is wrong and the integer part is larger than the number." + x +  "bit and number of digits are greater than" + y + "position!");
			   return false;
		   }
		   if (a[0].length<=x&&a[1].length>y)
		   {
			   alert("the number is wrong and the number of digits is larger than the number." + y + "position!");
			   return false;
		   }
		   if (a[0].length>x&&a[1].length<=y)
		   {
			   alert("the number is wrong and the integer bit is larger than the number." + x + "position!");
			   return false;
		   }

		   return true;
	   }
		   else
		{
		   if (a[0].length>x)
		   {
			   alert("the number is wrong and the integer part is larger than the number." + x + "position!");
			   return false;
		   }
		   return true;
		}
   }
}


/*
function name chkempty
parameter str: a string to be verifying
return value: return true is empty, return false to be non empty..
*/

function chkEmpty(str)
{
  if (str.trim().length==0)
  {
	  return true;
  }
  else
	  return false;
}


/********************************** Empty **************************************/
/**
*verify that the string is empty
*return value:
*if it is not empty, define the check pass and return to true
*if it is empty, the check does not pass, and returns the false reference prompt information: the input field can not be empty!
*/
function chkNotEmpty(str)
{
    if(str.trim() == "")
        return false;
    else
        return true;
}//~~~
/*--------------------------------- Empty --------------------------------------*/
/********************************** Integer *************************************/
/**
*verify that the string is an integer
*return value:
*if it is empty, define the check pass and return to true
*if the string is all numeric, check it through and return to true.
*if the check is not passed, return to false reference prompt information: the input field must be digits.
*/
function chkInt(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(/^(\-?)(\d+)$/.test(str))
        return true;
    else
        return false;
}//~~~
/**
*minimum value of check integer
*str: the string to be checked.  val: the value of the comparison
*
*return value:
*if it is empty, define the check pass and return to true
*if the condition is satisfied, more than etc.for a given value, check and pass, return to true
*if the value is less than the specified value, return the false reference prompt information: the input field can not be less than the given value.
*/
function chkIntMinValue(str,val)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(typeof(val) != "string")
        val = val + "";
    if(chkInt(str) == true)
    {
        if(parseInt(str,10)>=parseInt(val,10))
            return true;
        else
            return false;
    }
    else
        return false;
}//~~~
/**
*str is greater than val to return to true
*/
function chkIntMoreThan(str,val)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(typeof(val) != "string")
        val = val + "";
    if(chkInt(str) == true)
    {
        if(parseInt(str,10)>parseInt(val,10))
            return true;
        else
            return false;
    }
    else
        return false;
}//~~~
/**
*check the maximum value of the integer
*str: the string to be checked.  val: the value of the comparison
*
*return value:
*if it is empty, define the check pass and return to true
*if the condition is satisfied, less than etc.for a given value, check and pass, return to true
*if the value is greater than the specified value, return the false reference prompt information: the input value can not be greater than the given value.
*/
function chkIntMaxValue(str,val)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(typeof(val) != "string")
        val = val + "";
    if(chkInt(str) == true)
    {
        if(parseInt(str,10)<=parseInt(val,10))
            return true;
        else
            return false;
    }
    else
        return false;
}//~~~
/**
*check whether the integer is non negative
*str: the string to be checked.
*
*return value:
*if it is null, define the check pass and return to true
*if not negative, return to true
*if it is negative, return to false reference prompt information: the input value can not be negative.
*/
function isNotNegInt(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(chkInt(str) == true)
    {
        if(parseInt(str,10) < 0)
            return false;
        else
            return true;
    }
    else
        return false;
}//~~~
/*--------------------------------- Integer --------------------------------------*/
/********************************** Double ****************************************/
/**
*check whether the string is floating point type
*return value:
*if it is empty, define the check pass and return to true
*if the string is a floating point, verify that it passes and return to true
*if the check is not passed, return to false reference prompt information: the input field is not a valid floating point number!
*/
function chkDbl(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    //if it is an integer, the validity of the integer is checked
    if(str.indexOf(".") == -1)
    {
        if(chkInt(str) == true)
            return true;
        else
            return false;
    }
    else
    {
        if(/^(\-?)(\d+)(.{1})(\d+)$/g.test(str))
            return true;
        else
            return false;
    }
}//~~~
/**
*check floating-point minimum
*str: the string to be checked.  val: the value of the comparison
*
*return value:
*if it is empty, define the check pass and return to true
*if the condition is satisfied, more than etc.for a given value, check and pass, return to true
*if the value is less than the specified value, return the false reference prompt information: the input field can not be less than the given value.
*/
function chkDblMinValue(str,val)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(typeof(val) != "string")
        val = val + "";
    if(chkDbl(str) == true)
    {
        if(parseFloat(str)>=parseFloat(val))
            return true;
        else
            return false;
    }
    else
        return false;
}//~~~
/**
*check floating-point maximum value
*str: the string to be checked.  val: the value of the comparison
*
*return value:
*if it is empty, define the check pass and return to true
*if the condition is satisfied, less than etc.for a given value, check and pass, return to true
*if the value is greater than the specified value, return the false reference prompt information: the input value can not be greater than the given value.
*/
function chkDblMaxValue(str,val)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(typeof(val) != "string")
        val = val + "";
    if(chkDbl(str) == true)
    {
        if(parseFloat(str)<=parseFloat(val))
            return true;
        else
            return false;
    }
    else
        return false;
}//~~~
/**
*check whether the floating-point type is non negative
*str: the string to be checked.
*
*return value:
*if it is null, define the check pass and return to true
*if not negative, return to true
*if it is negative, return to false reference prompt information: the input value can not be negative.
*/
function isNotNegDbl(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if(chkDbl(str) == true)
    {
        if(parseFloat(str) < 0)
            return false;
        else
            return true;
    }
    else
        return false;
}//~~~
/*--------------------------------- Double ---------------------------------------*/
/********************************** date ******************************************/
/**
*verify that the string is a date type
*return value:
*if it is empty, define the check pass and return to true
*if the string is a date type, the check is passed and returns to true.
*if the date is not valid, return the false reference prompt information: the time in the input domain is not valid! (yyyy-MM-dd）
*/
function chkValidDate(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
	if(str.length!=10)
		return false;        //it must be 10.
    var pattern = /^((\d{4}))-(\d{1,2})-(\d{1,2})$/g;
    if(!pattern.test(str))
        return false;
    var arrDate = str.split("-");   
    var date =  new Date(arrDate[0],(parseInt(arrDate[1],10) -1)+"",arrDate[2]);
	if(date.getFullYear()<1900||date.getFullYear()>2100)
		return false;
    if(date.getFullYear() == arrDate[0]
       && date.getMonth() == (parseInt(arrDate[1],10) -1)+""
       && date.getDate() == arrDate[2])
        return true;
    else
        return false;
}
//~~~
/**
*check the two dates
*return value:
*if one of the dates is empty, the check is passed.,          return to true
*if the start date is earlier than etc.at the end date, check and pass, return to true
*if the start date is later than the expiration date, return the false reference message: the start date is not later than the end date..
*/
function chkDateEarlier(strStart,strEnd)
{
    if(chkValidDate(strStart) == false || chkValidDate(strEnd) == false)
        return false;
    //if an input is empty, pass the test
    if (( strStart == "" ) || ( strEnd == "" ))
        return true;
    var arr1 = strStart.split("-");
    var arr2 = strEnd.split("-");
    var date1 = new Date(arr1[0],parseInt(arr1[1].replace(/^0/,""),10) - 1,arr1[2]);
    var date2 = new Date(arr2[0],parseInt(arr2[1].replace(/^0/,""),10) - 1,arr2[2]);
    if(arr1[1].length == 1)
        arr1[1] = "0" + arr1[1];
    if(arr1[2].length == 1)
        arr1[2] = "0" + arr1[2];
    if(arr2[1].length == 1)
        arr2[1] = "0" + arr2[1];
    if(arr2[2].length == 1)
        arr2[2]="0" + arr2[2];
    var d1 = arr1[0] + arr1[1] + arr1[2];
    var d2 = arr2[0] + arr2[1] + arr2[2];
    if(parseInt(d1,10) > parseInt(d2,10))
       return false;
    else
       return true;
}//~~~



/**
*check the two dates
*return value:
*if one of the dates is empty, the check is passed.,          return to true
*if the start date is earlier than etc.at the end date, check and pass, return to true
*if the start date is later than the expiration date, return the false reference message: the start date is not later than the end date..
*/
function chkDateLate(strStart,strEnd)
{
    if(chkValidDate(strStart) == false || chkValidDate(strEnd) == false)
        return false;
    //if an input is empty, pass the test
    if (( strStart == "" ) || ( strEnd == "" ))
        return true;
    var arr1 = strStart.split("-");
    var arr2 = strEnd.split("-");
    var date1 = new Date(arr1[0],parseInt(arr1[1].replace(/^0/,""),10) - 1,arr1[2]);
    var date2 = new Date(arr2[0],parseInt(arr2[1].replace(/^0/,""),10) - 1,arr2[2]);
    if(arr1[1].length == 1)
        arr1[1] = "0" + arr1[1];
    if(arr1[2].length == 1)
        arr1[2] = "0" + arr1[2];
    if(arr2[1].length == 1)
        arr2[1] = "0" + arr2[1];
    if(arr2[2].length == 1)
        arr2[2]="0" + arr2[2];
    var d1 = arr1[0] + arr1[1] + arr1[2];
    var d2 = arr2[0] + arr2[1] + arr2[2];
    if(parseInt(d1,10) >= parseInt(d2,10))
       return false;
    else
       return true;
}//~~~

/*--------------------------------- date -----------------------------------------*/
/********************************** email *****************************************/
/**
*verify that the string is email type
*return value:
*if it is empty, define the check pass and return to true
*if the string is email, check through, return to true
*if email is not valid, return the false reference prompt: the format of email is incorrect.
*/
function chkEmail(str)
{
    //if it is empty, pass the check
    if(str == "")
        return true;
    if (str.charAt(0) == "." || str.charAt(0) == "@" || str.indexOf('@', 0) == -1
        || str.indexOf('.', 0) == -1 || str.lastIndexOf("@") == str.length-1 || str.lastIndexOf(".") == str.length-1)
        return false;
    else
        return true;
}
//~~~
/*--------------------------------- email ----------------------------------------*/

/********************************** chinese ***************************************/
/**
*verify that the string is chinese
*return value:
*if empty, return false to identify non chinese and return to false.
*if the string is chinese, check through, return to true
*if the string is non chinese, return the false reference message: it must be chinese!
*/

function chkChinese(str)
{
    //if the value is empty, pass the check
    if (str == "")
        return false;
    var pattern = /[^\x00-\xff]/g ;///^([\u4E00-\u9FA5]|[\uFE30-\uFFA0])*$/gi;
    if (pattern.test(str))
        return true;
    else
        return false;
}//~~~
/**
* calculate the length of a string, two characters of a chinese character.
*/
String.prototype.realLength = function()
{
  return this.replace(/[^\x00-\xff]/g,"**").length;
}
/*--------------------------------- chinese --------------------------------------*/
/********************************** mask ***************************************/
/**
*check whether the string matches the custom regular expression.
*str to check the string pat custom regular expression
*return value:
*if it is empty, define the check pass and return to true
*if the string matches, check through, return to true
*if the string does not match, false reference prompt information must be returned.***pattern
*/
function chkMask(str,pat)
{
    //if the value is empty, pass the check
    if (str == "")
        return true;
    var pattern = new RegExp(pat,"gi")
    if (pattern.test(str))
        return true;
    else
        return false;
}//~~~
/*--------------------------------- mask --------------------------------------*/
/********************************** file ***************************************/
/**
* added by LxcJie 2004.6.25
* get the suffix name of the file
* ofile is a file control object
*/
function getFilePostfix(oFile)
{
    if(oFile == null)
        return null;
    var pattern = /(.*)\.(.*)$/gi;
    if(typeof(oFile) == "object")
    {
        if(oFile.value == null || oFile.value == "")
            return null;
        var arr = pattern.exec(oFile.value);
        return RegExp.$2;
    }
    else if(typeof(oFile) == "string")
    {
        var arr = pattern.exec(oFile);
        return RegExp.$2;
    }
    else
        return null;
}//~~~
/*--------------------------------- file --------------------------------------*/ 

/*
function name: option_move
function: transfer the selection in list box obj1 to list box obj 2..
*/

function Option_Move(obj1,obj2)
{
   for(i=0;i<obj1.length;i++)
	{
	   if(obj1.options[i].selected)
		{
		   obj2.add(new Option(obj1.options[i].text,obj1.options[i].value));
		   obj1.options[i]=null;
	   }
   }
}


function  trim(str)
{
return  str.replace(/^\s*(.*?)[\s\n]*$/g,'$1');
}

/*
*function: determine all of the pages<html:text>whether the content in the text box is empty
*/
function checkSubmit()
{
	//check that all text text fields in the form can not be empty and can not contain spaces..
	//according to the actual situation, sometimes we can allow some text fields to be empty, so we add judgement conditions to the text fields that can be empty in the page.
	//please add the alt property: 1 - can't be empty; 0 - can be empty.
  var whitespace = " \n\r\t";
  for(var j=0;j<document.forms[0].length;j++) {
    if(document.forms[0][j].type == "text" && document.forms[0][j].alt==1) {
       var string_value = document.forms[0][j].value;
       if(string_value == "") {
         alert("please enter " + document.forms[0][j].title + "   ");
         document.forms[0][j].focus();
         return false;
       }else {
        var isAllSpace = true;
          for(var i=0;i<string_value.length;i++) {
            var current_char = string_value.charAt(i);
            if(whitespace.indexOf(current_char) == -1 ) {
                isAllSpace=false;
                }
              }
              if(isAllSpace){
             alert("please enter " + document.forms[0][j].title);
             document.forms[0][j].focus();
             return false;
          }
             
          }
          
          //Check for overflow 255 .Added by frank.
           if(string_value.length>255)
        {
        alert("input "+document.forms[0][j].title +"more than 255 character restrictions ");
         document.forms[0][j].focus();
         return false;
        }
       }
    } 
   var aa = true;   
   return aa;
}


/*
function: get the current date, return to xxxx-xx-the year and the day of the xx format
*/
function getDateTime()
{
   var d=new Date();
   var strDt=d.getYear() + "-" + ((d.getMonth()+1)<10?("0"+(d.getMonth()+1)):(d.getMonth()+1)) + "-" + (d.getDate()<10?("0" + d.getDate()):d.getDate());
   
    return strDt;
}

/*
function: get the current date serial number, which is used to replace random numbers and return to date.().getTime()formatted year and month
*/
function getTimePoint()
{
   var d=new Date();
    
    return d.getTime();
}

/*check the numeric str_num type, the integer part is not greater than the x bit, and the fractional part is not greater than the y bit..strtitle represents the real meaning of the value*/

function chkFloatFormat(str_num,x,y,strTitle)
{
	var errors="";

  if(isNaN(str_num))
	{
        errors = strTitle + "inputfor non - digital type!";
    }
  else
	{
       str_num=str_num.trim();
	   var a=str_num.split(".");
	   if (a.length==2)
	   {
		   if (a[0].length>x&&a[1].length>y)
		   {
			   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x +  "bit and number of digits are greater than" + y + "position!";
		   }
		   else if (a[0].length<=x&&a[1].length>y)
		   {
			   errors = strTitle +"the number is wrong and the number of digits is larger than the number." + y + "position!";
		   }
		   else if (a[0].length>x&&a[1].length<=y)
		   {
			   errors = strTitle + "the number is wrong and the integer bit is larger than the number." + x + "position!";
		   }

	   }
		 else
		{
		   if (a[0].length>x)
		   {
			   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x + "position!";
		   }
		}
   }

   return errors;
}


/*the non scene verification part examines the number str_num type, the integer part is not greater than 15 bits, and the fractional part is not greater than 2 bits..strtitle represents the real meaning of the value*/

function chkFloatFormat1(str_num,x,y,strTitle)
{
	var errors="";
	var fuhao=str_num.split("-");
  if(fuhao.length>=2)
  {
  		if(isNaN(str_num))
		{
	        errors = strTitle + "inputfor non - digital type!";
	    }
	  else
		{
	       str_num=fuhao[1].trim();
		   var a=str_num.split(".");
		   //alert(fuhao[1]);
		   //if(fuhao.length==2)
		   //{
		   	//x=x+1;
		   //}
		   
		   if (a.length==2)
		   {
			   if (a[0].length>x&&a[1].length>y)
			   {
				   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x +  "bit and number of digits are greater than" + y + "position!";
			   }
			   else if (a[0].length<=x&&a[1].length>y)
			   {
				   errors = strTitle +"the number is wrong and the number of digits is larger than the number." + y + "position!";
			   }
			   else if (a[0].length>x&&a[1].length<=y)
			   {
				   errors = strTitle + "the number is wrong and the integer bit is larger than the number." + x + "position!";
			   }
	
		   }
			 else
			{
			   if (a[0].length>x)
			   {
				   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x + "position!";
			   }
			}
	   }
  }
  else
  {
	  if(isNaN(str_num))
		{
	        errors = strTitle + "inputfor non - digital type!";
	    }
	  else
		{
	       str_num=str_num.trim();
		   var a=str_num.split(".");
		   if (a.length==2)
		   {
			   if (a[0].length>x&&a[1].length>y)
			   {
				   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x +  "bit and number of digits are greater than" + y + "position!";
			   }
			   else if (a[0].length<=x&&a[1].length>y)
			   {
				   errors = strTitle +"the number is wrong and the number of digits is larger than the number." + y + "position!";
			   }
			   else if (a[0].length>x&&a[1].length<=y)
			   {
				   errors = strTitle + "the number is wrong and the integer bit is larger than the number." + x + "position!";
			   }
	
		   }
			 else
			{
			   if (a[0].length>x)
			   {
				   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x + "position!";
			   }
			}
	   }
	}
	return errors;
}


/*check the numeric str_num type, the integer part is not greater than the x bit, and the fractional part is not greater than the y bit..strtitle represents the real meaning of the value,judge whether or not it is positive and negative
if
flagNeg=-2 is to indicate whether the judgment is negative,including 0
flagNeg=-1 is to indicate whether the judgment is negative, not including 0
flagNeg=0 indicates whether the judgment is 0
flagNeg=1 judge whether the positive number is not including 0
flagNeg=2 judgment is positive, including 0
*/

function chkFloatFormat(str_num,x,y,strTitle,flagNeg)
{
	var errors="";

  if(isNaN(str_num))
	{
        errors = strTitle + "inputfor non - digital type!";
    }
  else
	{
       str_num=str_num.trim();
	   var a=str_num.split(".");
	   if (a.length==2)
	   {
		   if (a[0].length>x&&a[1].length>y)
		   {
			   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x +  "bit and number of digits are greater than" + y + "position!";
		   }
		   else if (a[0].length<=x&&a[1].length>y)
		   {
			   errors = strTitle +"the number is wrong and the number of digits is larger than the number." + y + "position!";
		   }
		   else if (a[0].length>x&&a[1].length<=y)
		   {
			   errors = strTitle + "the number is wrong and the integer bit is larger than the number." + x + "position!";
		   }

	   }
		 else
		{
		   if (a[0].length>x)
		   {
			   errors = strTitle + "the number is wrong and the integer part is larger than the number." + x + "position!";
		   }
		}
   }

   if(errors.length==0)
	{
	   if(flagNeg==-2&&(isNotNegDbl(str_num)&&parseFloat(str_num)!=0))
		{
	   errors = strTitle + "the number should be less than etc.at 0!";
	  }
      if(isNotNegDbl(str_num)&&flagNeg==-1)
		{
	   errors = strTitle + "the number should be less than 0!";
	  }
	  if(parseFloat(str_num)!=0&&flagNeg==0)
		{
		  errors = strTitle + "the number should be etc.at 0!";
	  }
	  if(((!isNotNegDbl(str_num))||parseFloat(str_num)==0)&&flagNeg==1)
		{
	   errors = strTitle + "the number should be greater than 0!";
	  }
	   if((!isNotNegDbl(str_num))&&flagNeg==2)
		{
	   errors = strTitle + "the number should be greater than etc.at 0!";
	  }
   }

   return errors;
}

/*
*function: determine whether the contents of the text box in the page are numeric.
*/
function   chkNum()   
  {   
      var   k   =   window.event.keyCode;   
      if   (k   <   48   ||   k   >   57){   
            alert("you input is not a number!")   
            window.event.keyCode   =   0   ;}   
  }
 /*
*function: determine whether the contents of the text box in the page are numeric.or'.'
*/
function   chkPressNum()   
  {   
      var   k   =   window.event.keyCode;   
      if   ((k   ==46) ||( k>=   48  &&   k   <=   57))
	  {
	      
	  }  
	  else
		  event.returnValue=false;

  }
  
/*
* function: to modify the text text box in the modified page for
       0 ,0.0 or'N'the value of the replacement is empty
* time: 2006-04-11
*/
function replaceZeroTextValue()
 {
	var collObjects , i ;
	collObjects = document.getElementsByTagName("input");
	if (typeof(collObjects) =="undefined") return ;
	if (typeof(collObjects[0]) == "object") {
		for(i=0;i<collObjects.length;i++){
			if (collObjects[i].type =="text" && (collObjects[i].value =="N" || collObjects[i].value =="0.0" || collObjects[i].value =="0"))  
   			collObjects[i].value = "" ;
   	}
   	return ;
	}else{
		if (collObjects.type =="text" && collObjects.value =="0.0")  
   		collObjects[0].value = "" ;
  }
  
 }
/*
* function: modify the text text box in the page to calculate in chinese science.
        the number representation is replaced by a common style display
* time: 2006-04-12
*/
function replaceENum2CommonNum(){
  	var collObjects , i , temp;
  	var pointPos1 , pointPos2 ;
  	pointPos1 = -1 ;
  	pointPos2 = -1 ;
		collObjects = document.getElementsByTagName("input");	
		if (typeof(collObjects) =="undefined") return ;
		if (typeof(collObjects[0]) == "object") {
			for(i=0;i<collObjects.length;i++){
				if (collObjects[i].type =="text" && collObjects[i].value.length>4){
					pointPos1 = collObjects[i].value.indexOf('.') ;					
					pointPos2 = collObjects[i].value.indexOf('.',pointPos1+1)	;
					if (pointPos2 ==-1){			
						if ((collObjects[i].value.indexOf('.')==1 || collObjects[i].value.indexOf('.')==2)&& (collObjects[i].value.indexOf('E')>2 || collObjects[i].value.indexOf('e')>2)){
				  		temp = parseFloat(collObjects[i].value).toFixed(0); 			  		
				  		if(!isNaN(temp)) collObjects[i].value = temp ;
			  	  }
		  	 }
		  	}
	  	}
		}else{
			if (collObjects.type =="text" && collObjects.value.length>4){ 
				pointPos1 = collObjects[i].value.indexOf('.') ;					
				pointPos2 = collObjects[i].value.indexOf('.',pointPos1+1)	;
				if (pointPos2 == -1){	
					if ((collObjects.value.indexOf('.')==1 || collObjects[i].value.indexOf('.')==2) && (collObjects.value.indexOf('E')>2 || collObjects.value.indexOf('e')>2)){ 
		   			temp = parseFloat(collObjects.value).toFixed(0); 
			  		if(!isNaN(temp)) collObjects.value = temp ;
			  	}
		  	}
		  }
	  }
}
  
/*
* function: determine whether the contents of the text box in the page are numeric.
* 
* return value: trueinput is the number,false input is not a number
*
* time: 2006-03-02
*/
function   chkPressNumber()   
  {   
      var   k   =   window.event.keyCode;   
      if   ( k>=   48  &&   k   <=   57)
	  {
	      return true;
	  }  
	  else
	  {
		  event.returnValue=false;
		  return false;
		}

  }
/*
* function: determine whether the contents of the text box in the page are numeric.or"."
* 
* return value: trueinput is the numberor".",false input is not a numberor"."
.event.keyCode;   
   if ((k   ==46) ||( k>=   48  &&   k   <=   57))
	 {
	  	return true;   
	 }  
	 else
	 {
		event.returnValue=false;
		return false;
	 }

}
/*
* function: determine whether the character of input is the character required by the date.
* 
* return value: trueinput is the numberor"-",false input is not a numberor"-"
*/
function   chkPressDate()   
{   
	 var   k   =   window.event.keyCode;   
	
   if ((k   ==45) ||( k>=   48  &&   k   <=   57))
	 {
	  	return true;   
	 }  
	 else
	 {
		event.returnValue=false;
		return false;
	 }

}
/*
* function: determine whether the contents of the text box in the page are letters.
* 
* return value: trueinput is the alphabet,false input is not an alphabet
*
*
* time: 2006-03-02
*/
function   chkPressLetter()   
{   
	var   k   =   window.event.keyCode; 
		
  if ( k>=   97  &&   k   <=   122)
	{
	      return true;
	}  
	else
	{
		  event.returnValue=false;
		  return false;
	}	  

}
/*
* function: determine whether the contents of the text box in the page are numeric.or alphabet
* 
* return value: trueinput is the numberor alphabet,false input is not a numberor alphabet
*
*
* time: 2006-03-02
*/
function   chkPressNumOrLetter()   
{   
   var   k   =   window.event.keyCode;   
  if ( ( k>=   48  &&   k   <=   57) ||( k>=   97  &&   k   <=   122) || ( k>=   65  &&   k   <=   90))
	{
	      return true;
	}  
	else
	{
		  event.returnValue=false;
		  return false;
    }

}

function   chkPressNumOrLetter_Upper()   
{   
   var   k   =   window.event.keyCode;   
  if ( ( k>=   48  &&   k   <=   57) ||( k>=   97  &&   k   <=   122) || ( k>=   65  &&   k   <=   90))
	{
	      if(k>=   97  &&   k   <=   122)
	      {
	      	window.event.keyCode= k - 32;
	      }
	      return true;
	}  
	else
	{
		  event.returnValue=false;
		  return false;
    }

}

/*
* function: determine whether the content of the text box in the page is float type.
*
* input:  obj: the value of the input
         x: all digits
         y:decimals
         flagNeg=-2 is to indicate whether the judgment is negative,including 0
				flagNeg=-1 is to indicate whether the judgment is negative, not including 0
				flagNeg=0 indicates whether the judgment is 0
				flagNeg=1 judge whether the positive number is not including 0
				flagNeg=2 judgment is positive, including 0
* 
* return value: the digital or of true input"."making the content of the input as a legitimate float type
         the digital or of false input"."making the content after the input as an unlawful float type
*
* time: 2006-03-02
*/
function  chkPressFloat(obj,x,y,flagNeg)   
{   
	 
  if (chkPressNumOrDot())
  {
  
  	if(window.event.keyCode == 46)  //input"."
		{				
				if( obj.length == 0 || obj.indexOf(".")>=0 )//if is the first one".",or already exist".",input is not allowed
				{
					event.returnValue=false;
				}
		}
		else
		{
				var data = obj + String.fromCharCode(event.keyCode);
				var error = chkFloatFormat(data,x,y,"",flagNeg);
				if (error.length !=0)
				{					
					 event.returnValue=false;
				}	
		}	
  }

  else
  {
  
  	 event.returnValue=false;
		 return false;
  }  
}

/*
if the chkfloatformat return value is greater than 0, if more than 0, it prompts the return information for the onblur event in the text box.
*/
  function chkFloatFormatWithMessage(str_num,x,y,strTitle)
  {
	  var strMessage=chkFloatFormat(str_num,x,y,strTitle)
      if(strMessage.length>0)
	  {
	    alert(strMessage);
	  }
  }


  /*
judge chkfloatformat(str_num,x,y,strTitle,flagNeg)if the return value is greater than 0, if more than 0, it prompts the return information for the onblur event in the text box.
*/
  function chkFloatFormatWithMessage(str_num,x,y,strTitle,flagNeg)
  {
	  var strMessage=chkFloatFormat(str_num,x,y,strTitle,flagNeg)
      if(strMessage.length>0)
	  {
	    alert(strMessage);
	  }
  }
  
  
/*
 the following functions are used for common account check
*/


/*
function name: chkcorcorpid

parameter:obj: the enterprise code to be validated.

function function:
1,check whether the input's enterprise code is empty.
2,check whether the enterprise code of input contains chinese characters.
3,check whether the enterprise code for input is 9 bits.

return value:errors, prompt error message, if is empty, no error..

date of realization: 2006-03-02
*/

function chkCorCorpId(obj)
{
	var errors="";	
	
	if(obj.length == 0)
	{
		errors += "enterprise code can not be empty!\n";
	}	
	else if( obj.length >0 && chkChinese(obj))
	{
		errors += "the enterprise code can not contain chinese characters!\n";
	}	
	else if( obj.length >0 && !chkNumAndLetter(obj))
	{
		errors+= "the enterprise code can only contain numbers and letters!\n";
	}
	else if ( obj.length > 0 && obj.length != 9 )
	{
		errors += "the enterprise code must be 9 bit code!\n";
	}
	
	return errors;
	
}

/*
function name: chkidentity

parameter: str: the identity card number string to be verified.

function function:verify that the identity card number string is legitimate.

return value:errors, prompt error message, if is empty, no error..

date of realization: 2006-03-03
*/

function chkIdentity(str)
{
	var errors="";	
	
		
	if( str.length >0 && chkChinese(str))
	{
		errors += "there is no chinese character in the id number.\n";
	}	
	else if(str.length != 0 && str.length != 15 && str.length!=18)
	{
		errors += "the id number should be the 15 bit or person 18position!\n";
	}
	else if( str.length >0 && !chkNumAndLetter(str))
	{
		errors+= "there can only be numbers and letters in the id number.\n";
	}
	return errors;
	
}





/*
function name: chkcstgoodsid

parameter:obj: the number of goods to be verified.

function function:
1,check whether the input's commodity number is empty.
2,check whether the input's commodity number contains chinese characters.
2,check input's commodity number only to contain numbers.
3,check whether the commodity number of input is greater than 2 bits or less than 10 bits..

return value:errors, prompt error message, if is empty, no error..

author: fang dong bo

date of realization: 2006-03-31
*/

function chkCstGoodsId(obj)
{
	var errors="";	
	
	if(obj.length == 0)
	{
		errors += "the commodity number can not be empty!\n";
	}
	else if( obj.length >0 && chkChinese(obj))
	{
		errors += "commodity number can not contain chinese characters!\n";
	}	
	else if( obj.length >0 && !chkNumber(obj))
	{
		errors+= "there is only a number in the commodity number!\n";
	}
	else if ( obj.length > 0 && (obj.length <2 || obj.length >10))
	{
		errors += "the commodity number must be greater than etc.2 bits less than etc.in the 10 bit code!\n";
	}	
	return errors;
	
}


/**
function name: chkstartdateandenddate

parameter: strstart: the start date to verify.
      strEnd:   expiration date to be verified.
      title: date name to be verified.

function function:
1,check whether the start date and deadline are empty.
2,check whether the start date and the deadline are legal dates..
3,check whether the start date is less than the deadline.
4,check whether the start date is greater than the current date.

return value:errors, prompt error message, if is empty, no error..

author: fang dong bo

date of realization: 2006-03-31               
*/
function chkStartDateAndEndDate(strStart,strEnd,title)
{
	var error = "";
	if( strStart.length==0 && strEnd.length==0)
	{
		error += title+"the start date and the deadline cannot be empty!\n"
	} 
	else if (strStart.length==0 && strEnd.length!=0)
	{
		error += title+"the starting date and deadline must be input!\n"
	}
	else if (strStart.length!=0 && strEnd.length==0)
	{
		error += title+"the starting date and deadline must be input!\n"
	}
	else if (!chkValidDate(strStart))
	{
		error += title+"the start date is not a legal date!\n"
	}
	else if (!chkValidDate(strEnd))
	{
		error += title+"the deadline is not the legal date!\n"
	}
	else if (strStart>strEnd)
	{
		error += title+"the start date should not be later than the deadline!\n"
	}
	else if (strStart>getDateTime())
	{
		error += title+"the start date should not be later than the current date!\n"
	}
	
	return error;
    
}

/**
function name: chkstartdateandenddateYQ

parameter: strstart: the start date to verify.
      strEnd:   expiration date to be verified.
      title: date name to be verified.

function function:
1,check whether the start date and deadline are empty.
2,check whether the start date and the deadline are legal dates..
3,check whether the start date is less than the deadline.
4,check whether the start date is greater than the current date.

return value:errors, prompt error message, if is empty, no error..



date of realization: 2006-03-31               
*/
function chkStartDateAndEndDateYQ(strStart,strEnd,title)
{
	var error = "";
	if( strStart.length==0 && strEnd.length==0)
	{
		error += title+"the start date and the deadline cannot be empty!\n"
	} 
	else if (strStart.length==0 && strEnd.length!=0)
	{
		error += title+"the starting date and deadline must be input!\n"
	}
	else if (strStart.length!=0 && strEnd.length==0)
	{
		error += title+"the starting date and deadline must be input!\n"
	}
	else if (!chkValidDate(strStart))
	{
		error += title+"the start date is not a legal date!\n"
	}
	else if (!chkValidDate(strEnd))
	{
		error += title+"the deadline is not the legal date!\n"
	}
	else if (strStart>strEnd)
	{
		error += title+"the start date should not be later than the deadline!\n"
	}	
	return error;
    
}


/**
function name: chkminamtandmaxamt

parameter:minamt: minimum amount to be verified.
      maxAmt: the maximum amount to be verified.
      title: the name of the amount to be verified.

function function:
1,check whether the minimum amount and maximum amount are empty.
2,check the minimum sum and maximum amount of the legal amount..
3,check whether the minimum amount is less than the maximum amount.

return value:errors, prompt error message, if is empty, no error..
date of realization: 2006-03-31               
*/
function chkMinAmtAndMaxAmt(minAmt,maxAmt,title)
{
	var errors = "";
	
	if(minAmt.length==0&&maxAmt.length==0)
	{
		errors += title + "the minimum amount and maximum amount can not be empty!\n";
	}
	if(minAmt.length!=0&&maxAmt.length==0)
	{
		errors += title + "minimum amount and maximum amount must be input at the same time.!\n";
	}
	else if(minAmt.length==0&&maxAmt.length!=0)
	{
		errors += title + "minimum amount and maximum amount must be input at the same time!\n";
	}
	else if(minAmt.length>0&&maxAmt.length>0)
	{		
		var error1 = chkFloatFormat(minAmt,17,2,title+'minimum amount',2);
		if(error1.length>0)
		{
			errors += "  -"+error1+"\n";
		}
		
		var error2 = chkFloatFormat(maxAmt,17,2,title+'maximum amount',2);
		if(error2.length>0)
		{
			errors += "  -"+error2+"\n";
		}
		
		if (error1.length==0&&error2.length==0)
		{
			if(parseInt(minAmt)>parseInt(maxAmt))	
			{
				errors += title + "minimum amount can't be larger than maximum amount\n";
			}
		}
	}	
	return errors;
    
}



