  /*---------------.
  | :: Textures :: |
  '---------------*/

Texture2D InputTexture < string type = "input"; >; //Framebuffer input from the game
#if (USE_FXAA_ANTIALIASING == 1)
  Texture2D FXAATexture < string type = "output"; string format = "DXGI_FORMAT_B8G8R8A8_UNORM_SRGB"; >; //FXAA needs the luma in the alpha channel
#endif


  /*---------------.
  | :: Samplers :: |
  '---------------*/
  
SamplerState ColorSampler
{
	Filter = MIN_MAG_LINEAR_MIP_POINT;
	AddressU = Clamp;
	AddressV = Clamp;
};


  /*-------------------------.
  | :: Defining constants :: |
  '-------------------------*/

#if EFX_HLSL_4 == 1 || EFX_HLSL_5 == 1 ||EFX_HLSL_4_1
  #define s0 InputTexture
  #define myTex2D(s,p) s.Sample(ColorSampler, p)
#endif


  /*-------------------------.
  | :: Including effects ::  |
  '-------------------------*/
#include "SweetFX/Shaders/Main.h"  //Include the main SweetFX control shader


  /*--------------.
  | :: Structs :: |
  '--------------*/

struct Output
{
float4 position_cs : SV_POSITION;
float2 texcoord : TEXCOORD;
};

  /*-----------------------------------.
  | :: SweetFX - main vertex shader :: |
  '-----------------------------------*/

Output main_VS(uint id: SV_VertexID) {
                      
Output output;
 
output.texcoord = float2((id << 1) & 2, id & 2);
output.position_cs = float4(output.texcoord * float2(2, -2) + float2(-1, 1), 0, 1);

return output;
}

  /*----------------------------------.
  | :: SweetFX - main pixel shader :: |
  '----------------------------------*/

float4 main(float4 position  : SV_POSITION,
            float2 texcoord  : TEXCOORD0
          /*float4 offset[2] : TEXCOORD1,*/
            ) : SV_TARGET
{
                                                                        
    float4 color = InputTexture.Sample(ColorSampler, texcoord);
    
    color = SweetFX_main(texcoord,color); // Add the other effects

    return color;  //Returning the pixel
    
}

  /*------------------------.
  | :: FXAA pixel shader :: |
  '------------------------*/
#if (USE_FXAA_ANTIALIASING == 1)

#define FXAA_PC 1
#define FXAA_HLSL_4 1

#include "SweetFX/Shaders/FXAA.h"

float4 FXAA(float4 position : SV_POSITION,
            float2 texcoord : TEXCOORD0
            ) : SV_TARGET
{

  FxaaTex fxaaTex = { ColorSampler, FXAATexture };
        
  return FxaaPixelShader(
    texcoord, 
    float4(0,0,0,0),
    fxaaTex,
    fxaaTex,
    fxaaTex,
    pixel,
    float4(0,0,0,0),
    float4(0,0,0,0),
    float4(0,0,0,0),
    fxaa_Subpix,
    fxaa_EdgeThreshold,
    fxaa_EdgeThresholdMin,
    8.0,
    0.125,
    0.05,
    float4(0,0,0,0)
    );
				
}
#endif

  /*-----------.
  | :: SMAA :: |
  '-----------*/

#include "SweetFX/Shaders/SMAA_D3D10.h"

  /*-----------------.
  | :: Techniques :: |
  '-----------------*/

technique10 SweetFX {
//----------------------( SweetFX )---------------------
    pass SweetFX
    #if (USE_FXAA_ANTIALIASING == 1)
        < string output0 = "FXAATexture"; >
    #endif
    {
        SetVertexShader(CompileShader(vs_4_0, main_VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, main()));
    }

//-----------------------( FXAA )-----------------------
#if (USE_FXAA_ANTIALIASING == 1)
    pass FXAA
    {
        SetVertexShader(CompileShader(vs_4_0, main_VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, FXAA()));
    }    
#endif    

//-----------------------( SMAA )-----------------------
#if (USE_SMAA_ANTIALIASING == 1)

    pass LumaEdgeDetection {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAAEdgeDetectionVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(PS_VERSION, DX10_SMAALumaEdgeDetectionPS()));

        SetDepthStencilState(DisableDepthReplaceStencil, 1);
        SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
    }


    pass ColorEdgeDetection {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAAEdgeDetectionVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(PS_VERSION, DX10_SMAAColorEdgeDetectionPS()));

        SetDepthStencilState(DisableDepthReplaceStencil, 1);
        SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
    }


    pass BlendingWeightCalculation {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAABlendingWeightCalculationVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(PS_VERSION, DX10_SMAABlendingWeightCalculationPS()));

        SetDepthStencilState(DisableDepthUseStencil, 1);
        SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
    }


    pass NeighborhoodBlending {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAANeighborhoodBlendingVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(PS_VERSION, DX10_SMAANeighborhoodBlendingPS()));

        SetDepthStencilState(DisableDepthStencil, 0);
        SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
        // For SMAA 1x, just use NoBlending!
    }

/* // -- 2x multisampled buffer conversion into two regular buffers --
    pass Separate {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAASeparateVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(PS_VERSION, DX10_SMAASeparatePS()));

        SetDepthStencilState(DisableDepthStencil, 0);
        SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
    }
*/
#endif   


}
