class UIImportFromPool extends UIScreenListener;

var UICustomize_Info Menu;
var UIMechaListItem ImportButton;
var UIButton ImportFromPoolButton;
var UIMechaListItem item;
var UIListItemString buttonItem;
var UI_Definitions defs;

event OnInit(UIScreen Screen)
{
	local float ListHeight;
	//create instance of the customization menu with the screen object
	Menu = UICustomize_Info(Screen);

	defs = new class'UI_Definitions';

	//If we are in the armory, add an import button to list
	if(Menu.bInArmory || Menu.bInMP){
		//ImportFromPoolButton = Menu.Spawn(class'UIButton', Menu).InitButton('Import Button', "Load Soldier From Pool", OnImportButtonClicked);
		
		Menu.UpdateData();
		UIMechaListItem(Menu.List.CreateItem(class'UIMechaListItem')).InitListItem().UpdateDataDescription("Load character", OnImportButtonClicked);


		Menu.List.SetHeight(250); 
	}
}

function OnImportButtonClicked(){
	OnUpdateCharacter();
}

function OnUpdateCharacter(){
	local CharacterPoolManager pool;
	local XComGameState_Unit poolUnit;
	local TDialogueBoxData kDialogData;
	local String dialogueText;
	local String dialogueTitle;

	dialogueText = "Imported soldier from pool.";
	dialogueTitle = "Imported Data From Pool";

	`log("Clicked Import Button");
	`log(Menu.CustomizeManager.Unit.GetFullName());

	pool = CharacterPoolManager(`XENGINE.GetCharacterPoolManager());
	poolUnit = pool.GetCharacter(Menu.CustomizeManager.Unit.GetFullName());
	
	if(poolUnit == none){
		dialogueTitle = "Error Importing From Pool";
		dialogueText = "Could not find soldier by the name of '"$Menu.CustomizeManager.Unit.GetFullName()$"' in pool. (Hint: Name the soldier that you wish to customize to the name of the soldier in the pool to load data from.)";
	}else{
		if(!(Menu.CustomizeManager.Unit.IsVeteran())){
			dialogueText = dialogueText $ " [WARNING]: Soldier is not a veteran, and so did not get nickname or attitiude from pool.";
		}
		if(!(poolUnit.GetSoldierClassTemplateName() == Menu.CustomizeManager.Unit.GetSoldierClassTemplateName())){
			dialogueText = dialogueText $ " [WARNING]: Soldier in pool was described as a different class to the soldier it was applied to.";
			CopySoldierCustomization(poolUnit);
		}else{
			CopySoldierCustomization(poolUnit);
		}

		dialogueText = dialogueText $ " [INFO]: Weapon color copied, but not pattern. This is a limitation of the engine, and a fix is currently being worked on.";
	}

	kDialogData.eType = eDialog_Normal;
	kDialogData.strTitle = dialogueTitle;
	kDialogData.strText = dialogueText;
	kDialogData.strAccept = "OK";
	Menu.Movie.Pres.UIRaiseDialog(kDialogData);
}

function CopySoldierCustomization(XComGameState_Unit poolUnit){
	local XComGameState_Unit currentUnit;
	local X2TacticalGameRulesetDataStructures data;
	local XComGameState_Item currentPrimaryWeapon;
	local XCOMGameState_Item poolPrimaryWeapon;
	local XCOMGameStateHistory History;
	local array<XCOMGameState_Item> Items;
	local int Index;
	currentUnit = Menu.CustomizeManager.Unit;

	//load customized values
	//-----Character Info------
	if (currentUnit.isVeteran()){
		currentUnit.setUnitName(poolUnit.getName(poolUnit.ENameType.eNameType_First), poolUnit.getName(poolUnit.ENameType.eNameType_Last), poolUnit.GetName(poolUnit.ENameType.eNameType_Nick)); //set nickname
	} //only set the name (&nickname) if the unit is a veteran, otherwise rookies will have nicknames
	currentUnit.SetBackground(poolUnit.GetBackground()); //bio
	currentUnit.SetCountry(poolUnit.GetCountry()); //country

	//-----apperance-----
	currentUnit.kAppearance = poolUnit.kAppearance;

	data = new class'X2TacticalGameRulesetDataStructures';
	History = `XCOMHISTORY;
	//-----weapon customization------EInventorySlot
	currentPrimaryWeapon = XComGameState_Item(History.GetGameStateForObjectID(currentUnit.GetItemInSlot(data.EInventorySlot.eInvSlot_PrimaryWeapon).ObjectID));
	poolPrimaryWeapon = XComGameState_Item(History.GetGameStateForObjectID(poolUnit.GetItemInSlot(data.EInventorySlot.eInvSlot_PrimaryWeapon).ObjectID));

	Items = poolUnit.getAllInventoryItems();
	if(Items.Length > 0)
		{
			for(Index = 0; Index < Items.Length; ++Index)
			{
				`log("Item : "$Items[Index].WeaponAppearance.nmWeaponPattern);
			}
		}

	`log("weapon pattern: "$currentPrimaryWeapon.WeaponAppearance.nmWeaponPattern);

	currentUnit.kAppearance.nmWeaponPattern = poolPrimaryWeapon.WeaponAppearance.nmWeaponPattern;
	currentPrimaryWeapon.WeaponAppearance = poolPrimaryWeapon.WeaponAppearance;
	Menu.CustomizeManager.OnCategoryValueChange(Menu.CustomizeManager.EUICustomizeCategory.eUICustomizeCat_WeaponPatterns, 1);
	XGWeapon(currentPrimaryWeapon.GetVisualizer()).SetAppearance(poolPrimaryWeapon.WeaponAppearance);
	//currentUnit.GetItemInSlot(data.EInventorySlot.eInvSlot_PrimaryWeapon).WeaponAppearance = poolUnit.GetItemInSlot(data.EInventorySlot.eInvSlot_PrimaryWeapon).WeaponAppearance;

	//refresh by switching to next soldier
	if (Menu.bInMP){
		XComHumanPawn(Menu.CustomizeManager.ActorPawn).SetAppearance(currentUnit.kAppearance);
		Menu.CustomizeManager.UpdateCamera();
	}else{
		Menu.NextSoldier();
		Menu.PrevSoldier();
	}
	
	Menu.UpdateData();
}

defaultproperties
{
	ScreenClass = class'UICustomize_Info';
}