# Generated by Django 2.1.7 on 2019-07-05 05:48

from django.db import migrations
from django.db.models import F
from django.db.models import CharField, Value as V
from django.db.models.functions import Concat


def migrate_assets_protocol(apps, schema_editor):
    asset_model = apps.get_model("assets", "Asset")
    db_alias = schema_editor.connection.alias
    assets = asset_model.objects.using(db_alias).all().annotate(
        protocols_new=Concat(
            'protocol', V('/'), 'port',
            output_field=CharField(),
        ),
    )
    assets.update(protocols=F('protocols_new'))


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0033_auto_20190624_2108'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='asset',
            name='protocols',
        ),
        migrations.AddField(
            model_name='asset',
            name='protocols',
            field=CharField(blank=True, default='ssh/22', max_length=128, verbose_name='Protocols'),
        ),
        migrations.RunPython(migrate_assets_protocol),
        migrations.DeleteModel(name='Protocol'),
    ]
