/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.bean;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.util.HashMap;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.IBean;
import javax.rad.type.bean.IBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConverter {
    private static final ILogger LOGGER = LoggerFactory.getInstance(BeanConverter.class);
    private IBeanType beanType;
    private HashMap<String, String> hmpPropertyNames = null;
    private String[] pojoPropertyNames;

    public BeanConverter() {
    }

    public BeanConverter(IBeanType iBeanType) {
        this.setBeanType(iBeanType);
    }

    public Object[] createArray(Object object) {
        String[] stringArray;
        IBean iBean;
        if (object == null) {
            return new Object[this.beanType.getPropertyCount()];
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof IBean) {
            iBean = (IBean)object;
            stringArray = this.beanType.getPropertyNames();
        } else {
            iBean = new Bean(object);
            stringArray = this.pojoPropertyNames;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                objectArray[i] = iBean.get(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
        return objectArray;
    }

    public IBean createBean(Object[] objectArray) {
        Bean bean = new Bean(this.beanType);
        String[] stringArray = this.beanType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (objectArray != null && i < objectArray.length) {
                bean.put(stringArray[i], objectArray[i]);
                continue;
            }
            if (objectArray != null) continue;
            bean.put(stringArray[i], (Object)null);
        }
        return bean;
    }

    public IBean createBean(Object object) {
        Bean bean = new Bean(this.beanType);
        Bean bean2 = new Bean(object);
        String[] stringArray = this.beanType.getPropertyNames();
        for (int i = 0; i < this.pojoPropertyNames.length; ++i) {
            try {
                bean.put(stringArray[i], bean2.get(this.pojoPropertyNames[i]));
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
        return bean;
    }

    public IBean createEmptyBean() {
        return new Bean(this.beanType);
    }

    public <T> T createPOJO(Class<T> clazz, IBean iBean) {
        Bean bean = new Bean(clazz);
        String[] stringArray = this.beanType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                bean.put(this.pojoPropertyNames[i], iBean.get(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
        return (T)bean.getObject();
    }

    public <T> T createPOJO(Class<T> clazz, Object object) {
        Bean bean = new Bean(clazz);
        Bean bean2 = new Bean(object);
        for (int i = 0; i < this.pojoPropertyNames.length; ++i) {
            try {
                bean.put(this.pojoPropertyNames[i], bean2.get(this.pojoPropertyNames[i]));
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
        return (T)bean.getObject();
    }

    public <T> T createPOJO(Class<T> clazz, Object[] objectArray) {
        Bean bean = new Bean(clazz);
        for (int i = 0; i < this.pojoPropertyNames.length; ++i) {
            try {
                bean.put(this.pojoPropertyNames[i], objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
                if (this.beanType.getPropertyIndex(this.pojoPropertyNames[i]) < 0) continue;
                throw new IllegalArgumentException("Setting value for column [" + this.pojoPropertyNames[i] + "] failed!", exception);
            }
        }
        return (T)bean.getObject();
    }

    public IBeanType getBeanType() {
        return this.beanType;
    }

    public String getPojoPropertyName(int n) {
        return this.pojoPropertyNames[n];
    }

    public String getPropertyNameForColumn(String string) {
        if (this.hmpPropertyNames == null) {
            return null;
        }
        return this.hmpPropertyNames.get(string);
    }

    public boolean isInitialized() {
        return this.beanType != null;
    }

    public void removePropertyNameForColumn(String string) {
        if (this.hmpPropertyNames == null) {
            return;
        }
        this.hmpPropertyNames.remove(string);
    }

    public void setBeanType(IBeanType iBeanType) {
        this.beanType = iBeanType;
        String[] stringArray = this.beanType.getPropertyNames();
        this.pojoPropertyNames = new String[stringArray.length];
        for (int i = 0; i < this.pojoPropertyNames.length; ++i) {
            String string = this.hmpPropertyNames != null ? this.hmpPropertyNames.get(stringArray[i]) : null;
            if (string == null) {
                string = StringUtil.convertToMemberName(stringArray[i]);
            }
            this.pojoPropertyNames[i] = string;
        }
    }

    public void setPojoPropertyName(int n, String string) {
        this.pojoPropertyNames[n] = string;
    }

    public void setPropertyNameForColumn(String string, String string2) {
        if (this.hmpPropertyNames == null) {
            this.hmpPropertyNames = new HashMap();
        }
        this.hmpPropertyNames.put(string, string2);
    }

    public void updateArray(Object[] objectArray, Object object) {
        if (objectArray == null || objectArray.length == 0 || object == null) {
            return;
        }
        IBean iBean = null;
        String[] stringArray = null;
        if (object instanceof IBean) {
            iBean = (IBean)object;
            stringArray = this.beanType.getPropertyNames();
        } else {
            iBean = new Bean(object);
            stringArray = this.pojoPropertyNames;
        }
        for (int i = 0; i < Math.min(stringArray.length, objectArray.length); ++i) {
            objectArray[i] = iBean.get(stringArray[i]);
        }
    }

    public void updateBean(IBean iBean, Object object) {
        String[] stringArray;
        IBean iBean2;
        if (iBean == null || object == null) {
            return;
        }
        String[] stringArray2 = this.beanType.getPropertyNames();
        if (object instanceof IBean) {
            iBean2 = (IBean)object;
            stringArray = stringArray2;
        } else {
            iBean2 = new Bean(object);
            stringArray = this.pojoPropertyNames;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                iBean.put(stringArray2[i], iBean2.get(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
    }

    public void updateBean(IBean iBean, Object[] objectArray) {
        if (iBean == null || objectArray == null || objectArray.length == 0) {
            return;
        }
        String[] stringArray = this.beanType.getPropertyNames();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                iBean.put(stringArray[i], objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
    }

    public void updatePOJO(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        Bean bean = new Bean(object);
        IBean iBean = null;
        String[] stringArray = null;
        if (object2 instanceof IBean) {
            iBean = (IBean)object2;
            stringArray = this.beanType.getPropertyNames();
        } else {
            iBean = new Bean(object2);
            stringArray = this.pojoPropertyNames;
        }
        for (int i = 0; i < this.pojoPropertyNames.length; ++i) {
            try {
                bean.put(this.pojoPropertyNames[i], iBean.get(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
    }

    public void updatePOJO(Object object, Object[] objectArray) {
        if (object == null || objectArray == null || objectArray.length == 0) {
            return;
        }
        Bean bean = new Bean(object);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                bean.put(this.pojoPropertyNames[i], objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOGGER.debug(exception);
            }
        }
    }
}

