/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.server.annotation.Accessible;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStorage
extends AbstractCachedStorage {
    public static final String SUBSTORAGE_PREFIX = ".subStorages.";
    private static final String AUTOMATICLINKREFERENCE_PREFIX = ".FK.";
    private ServerMetaData mdServerMetaData = new ServerMetaData();
    private HashMap<String, DBStorage> hmpSubStorages = new HashMap();
    private ArrayUtil<StorageReferenceDefinition> auManualLinkReferences = new ArrayUtil();
    private ArrayUtil<StorageReferenceDefinition> auAutomaticLinkReferences = new ArrayUtil();
    private ArrayUtil<StorageReferenceDefinition> auSortedAutomaticLinkReferences = new ArrayUtil();
    private boolean bIsOpen = false;
    private DBAccess dbAccess;
    private String sFromClause;
    private String sFromClauseBeforeOpen;
    private String[] saQueryColumns;
    private String[] saAdditionalQueryColumns;
    private String[] saQueryColumnsBeforeOpen;
    private String sBeforeQueryColumns;
    private String sWhereClause;
    private String sAfterWhereClause;
    private String sOrderByClause;
    private String[] saWritebackColumns;
    private String sWritebackTable;
    private String sSchema;
    private String sCatalog;
    private SortDefinition sdDefaultSort;
    private ICondition cRestrictCondition;
    private Boolean bAutoLinkReference;
    private static boolean bDefaultAutoLinkReference = true;
    private Boolean bDefaultValue;
    private static boolean bDefaultDefaultValue = true;
    private Boolean bAllowedValues;
    private boolean bLazyFetchEnabled = true;
    private static boolean bDefaultAllowedValues = true;
    private boolean bLockOnRefetch = true;
    private ICondition subStorageConditions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        ISession iSession = SessionContext.getCurrentSession();
        String string2 = null;
        if (iSession != null && (string2 = (String)iSession.getProperty("client.file.encoding")) == null) {
            string2 = (String)iSession.getProperty("client.defaultCharset");
        }
        if (StringUtil.isEmpty(string2)) {
            string2 = DataBookCSVExporter.getDefaultEncoding();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
        try {
            int n;
            iCondition = this.createFilter(iCondition);
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            } else {
                this.checkSort(sortDefinition);
            }
            if (stringArray == null) {
                stringArray = this.mdServerMetaData.getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = this.mdServerMetaData.getServerColumnMetaData(stringArray[n]).getLabel();
                    if (stringArray2[n] != null) continue;
                    stringArray2[n] = ColumnMetaData.getDefaultLabel(stringArray[n]);
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n], '\"'));
            }
            outputStreamWriter.write("\n");
            String[] stringArray3 = this.sBeforeQueryColumns != null ? (String[])this.saQueryColumns.clone() : (String[])stringArray.clone();
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int[] nArray = new int[stringArray.length];
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                ServerColumnMetaData serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData(stringArray[i]);
                iDataTypeArray[i] = serverColumnMetaData.getColumnMetaData().getDataType();
                nArray[i] = this.mdServerMetaData.getServerColumnMetaDataIndex(stringArray[i]);
                if (this.sBeforeQueryColumns != null) continue;
                if (this.saQueryColumns != null && !StringUtil.isEmpty(this.saQueryColumns[nArray[i]])) {
                    stringArray3[i] = this.saQueryColumns[nArray[i]];
                    continue;
                }
                stringArray3[i] = serverColumnMetaData.getRealQueryColumnName();
                if (!StringUtil.isEmpty(stringArray3[i])) continue;
                stringArray3[i] = stringArray[i];
            }
            int n3 = 0;
            boolean bl = false;
            String string3 = this.getFromClauseIntern();
            while (!bl) {
                List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, stringArray3, string3, iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, this.sOrderByClause, n3, 500, true);
                n3 += list.size();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    Object[] objectArray = list.get(i);
                    if (objectArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (j > 0) {
                                outputStreamWriter.write(string);
                            }
                            DataBookCSVExporter.writeQuoted(outputStreamWriter, iDataTypeArray[j], objectArray[nArray[j]], string);
                        }
                        outputStreamWriter.write("\n");
                        continue;
                    }
                    bl = true;
                }
            }
            outputStreamWriter.flush();
            Object var23_25 = null;
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            CommonUtil.close(outputStreamWriter);
            throw throwable;
        }
        CommonUtil.close(outputStreamWriter);
    }

    @Override
    @Accessible
    public MetaData getMetaData() throws DataSourceException {
        MetaData metaData = this.mdServerMetaData.getMetaData();
        if (this.hasInsteadOfInsertEventHandler() || this.hasInsteadOfUpdateEventHandler() || this.hasInsteadOfDeleteEventHandler()) {
            metaData.addFeature(MetaData.Feature.WriteBack);
        }
        return metaData;
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        iCondition = this.createFilter(iCondition);
        List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, new String[]{"COUNT(*)"}, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 1, false);
        if (list != null && list.size() >= 1 && list.get(0).length > 0) {
            Object object = list.get(0)[0];
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            throw new DataSourceException("countRows() result data typ not supported! - " + object.getClass().getName());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list;
        Record record = ProtocolFactory.openRecord("STORAGE", "EXECUTE_FETCH", new Object[0]);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBStorage isn't open!");
            }
            iCondition = this.createFilter(iCondition);
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            } else {
                this.checkSort(sortDefinition);
            }
            if (record != null) {
                record.setParameter(iCondition, sortDefinition, n, n2);
            }
            list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, this.sOrderByClause, n, n2, this.bLazyFetchEnabled);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Record record = ProtocolFactory.openRecord("STORAGE", "EXECUTE_REFETCH", new Object[0]);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBStorage isn't open!");
            }
            objectArray2 = this.refetchRow(objectArray, this.isLockOnRefetch());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Object[] objectArray3;
        Record record;
        block6: {
            block5: {
                Object[] objectArray4;
                record = ProtocolFactory.openRecord("STORAGE", "EXECUTE_INSERT", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() != null) break block5;
                    objectArray4 = null;
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray4;
            }
            objectArray3 = this.dbAccess.insert(this.getWritebackTable(), this.mdServerMetaData, objectArray);
            if (!this.isRefetch() || (objectArray2 = this.refetchRow(objectArray3, false)) == null) break block6;
            Object[] objectArray5 = objectArray2;
            Object var7_6 = null;
            CommonUtil.close(record);
            return objectArray5;
        }
        objectArray2 = objectArray3;
        Object var7_7 = null;
        CommonUtil.close(record);
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        Object[] objectArray3;
        Object[] objectArray4;
        Record record;
        block6: {
            block5: {
                Object[] objectArray5;
                record = ProtocolFactory.openRecord("STORAGE", "EXECUTE_UPDATE", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() != null) break block5;
                    objectArray5 = null;
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray5;
            }
            objectArray4 = this.dbAccess.update(this.getWritebackTable(), this.mdServerMetaData, objectArray, objectArray2);
            if (!this.isRefetch() || (objectArray3 = this.refetchRow(objectArray4, false)) == null) break block6;
            Object[] objectArray6 = objectArray3;
            Object var8_7 = null;
            CommonUtil.close(record);
            return objectArray6;
        }
        objectArray3 = objectArray4;
        Object var8_8 = null;
        CommonUtil.close(record);
        return objectArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeDelete(Object[] objectArray) throws DataSourceException {
        Record record;
        block5: {
            block4: {
                record = ProtocolFactory.openRecord("STORAGE", "EXECUTE_DELETE", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() == null) {
                        Object var4_3 = null;
                        break block4;
                    }
                    this.dbAccess.delete(this.getWritebackTable(), this.mdServerMetaData, objectArray);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
            }
            CommonUtil.close(record);
            return;
        }
        Object var4_4 = null;
        CommonUtil.close(record);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsOpen()=");
        stringBuffer.append(this.bIsOpen);
        stringBuffer.append("\n");
        stringBuffer.append(this.dbAccess);
        stringBuffer.append("\n");
        stringBuffer.append(this.sBeforeQueryColumns);
        stringBuffer.append(" ");
        for (n = 0; this.saQueryColumns != null && n < this.saQueryColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saQueryColumns[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.sFromClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sAfterWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append("Writeback:\n");
        stringBuffer.append(this.getWritebackTable());
        stringBuffer.append("\n");
        for (n = 0; this.saWritebackColumns != null && n < this.saWritebackColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saWritebackColumns[n]);
        }
        return stringBuffer.toString();
    }

    public void setMetaData(MetaData metaData) throws DataSourceException {
        if (this.isOpen()) {
            throw new DataSourceException("Metadata can not be changed when DBStorage is already open!");
        }
        this.mdServerMetaData.setMetaData(metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws DataSourceException {
        Record record = ProtocolFactory.openRecord("STORAGE", "OPEN_STORAGE", new Object[0]);
        try {
            this.sFromClauseBeforeOpen = this.getFromClause();
            this.saQueryColumnsBeforeOpen = this.getQueryColumns();
            if (record != null) {
                record.setParameter(this.sFromClauseBeforeOpen);
            }
            this.openInternal(false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected void openInternal(boolean bl) throws DataSourceException {
        if (this.dbAccess == null) {
            throw new DataSourceException("DBAccess isn't set!");
        }
        this.createMetaData(this.getBeforeQueryColumns(), this.getQueryColumns(), this.getFromClause(), this.getWhereClause(), this.getAfterWhereClause(), this.getWritebackTable(), this.getWritebackColumns(), this.isAutoLinkReference(), bl);
        this.bIsOpen = true;
    }

    protected void refreshMetaData() throws DataSourceException {
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.openInternal(false);
    }

    private String putSubStorage(DBStorage dBStorage) {
        String string = this.createSubStorageName(dBStorage);
        this.hmpSubStorages.put(string, dBStorage);
        return SUBSTORAGE_PREFIX + string;
    }

    private DBStorage getSubStorage(String string) {
        if (string.startsWith(SUBSTORAGE_PREFIX)) {
            return this.hmpSubStorages.get(string.substring(SUBSTORAGE_PREFIX.length()));
        }
        return null;
    }

    public void createAutomaticLinkReference(String[] stringArray, String string, String[] stringArray2) throws DataSourceException {
        if (this.isOpen()) {
            StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
            this.createAutomaticLinkStorage(storageReferenceDefinition, this.mdServerMetaData.getWritableColumnNames());
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    public void createAutomaticLinkReference(String[] stringArray, DBStorage dBStorage, String[] stringArray2) throws DataSourceException {
        String string = this.putSubStorage(dBStorage);
        StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
        if (this.isOpen()) {
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    private void addAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        Object object;
        int n;
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        boolean bl = storageReferenceDefinition.getReferencedStorage().startsWith(AUTOMATICLINKREFERENCE_PREFIX);
        String string = storageReferenceDefinition.getReferencedStorage().replace(AUTOMATICLINKREFERENCE_PREFIX, "").replace(SUBSTORAGE_PREFIX, "").toLowerCase();
        for (n = this.auAutomaticLinkReferences.size() - 1; n >= 0; --n) {
            StorageReferenceDefinition storageReferenceDefinition2 = this.auAutomaticLinkReferences.get(n);
            object = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            boolean bl2 = storageReferenceDefinition.getReferencedStorage().startsWith(AUTOMATICLINKREFERENCE_PREFIX);
            String string2 = storageReferenceDefinition2.getReferencedStorage().replace(AUTOMATICLINKREFERENCE_PREFIX, "").replace(SUBSTORAGE_PREFIX, "").toLowerCase();
            if (!string.equals(string2)) continue;
            if (stringArray2.length < ((Object)object).length && ArrayUtil.containsAll(object, stringArray2)) {
                if (bl == bl2) {
                    return;
                }
                this.auAutomaticLinkReferences.remove(n);
                continue;
            }
            if (stringArray2.length <= ((Object)object).length || !ArrayUtil.containsAll(stringArray2, object)) continue;
            this.auAutomaticLinkReferences.remove(n);
        }
        int n2 = this.auAutomaticLinkReferences.size();
        for (n = 0; n < n2; ++n) {
            object = this.auAutomaticLinkReferences.get(n);
            String[] stringArray3 = ArrayUtil.intersect(((ColumnMapping)object).getColumnNames(), stringArray);
            if (stringArray3.length == 0) {
                stringArray3 = ((ColumnMapping)object).getColumnNames();
            }
            if (stringArray3.length > stringArray2.length) {
                this.auAutomaticLinkReferences.add(n, storageReferenceDefinition);
                return;
            }
            if (stringArray3.length != stringArray2.length || !ArrayUtil.containsAll(stringArray3, stringArray2)) continue;
            this.auAutomaticLinkReferences.set(n, storageReferenceDefinition);
            return;
        }
        this.auAutomaticLinkReferences.add(storageReferenceDefinition);
    }

    private List<StorageReferenceDefinition> getSubAutomaticLinkReferences(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        ArrayUtil<StorageReferenceDefinition> arrayUtil = new ArrayUtil<StorageReferenceDefinition>();
        for (StorageReferenceDefinition storageReferenceDefinition2 : this.auAutomaticLinkReferences) {
            String[] stringArray3 = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            if (stringArray3.length >= stringArray2.length) {
                return arrayUtil;
            }
            if (stringArray3.length <= 0 || !ArrayUtil.containsAll(stringArray2, stringArray3)) continue;
            arrayUtil.add(storageReferenceDefinition2);
        }
        return arrayUtil;
    }

    protected void installAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition) throws DataSourceException {
        String[] stringArray = this.mdServerMetaData.getWritableColumnNames();
        this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray);
        String[] stringArray2 = storageReferenceDefinition.getColumnNames();
        List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
        for (StorageReferenceDefinition storageReferenceDefinition2 : list) {
            stringArray2 = ArrayUtil.removeAll(stringArray2, storageReferenceDefinition2.getColumnNames());
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                this.mdServerMetaData.getMetaData().getColumnMetaData(stringArray2[i]).setLinkReference(storageReferenceDefinition);
                continue;
            }
            catch (ModelException modelException) {
                throw new DataSourceException("Can't install automatic link reference!", modelException);
            }
        }
    }

    protected String createSubStorageName(DBStorage dBStorage) {
        int n;
        Object object;
        String string;
        if (dBStorage.getName() != null) {
            string = dBStorage.getName();
        } else {
            object = dBStorage;
            string = ((DBStorage)object).getWritebackTable() != null ? ((DBStorage)object).getWritebackTable() : ((DBStorage)object).getFromClause();
            n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = StringUtil.convertToMemberName(string);
        }
        object = string;
        n = 1;
        while (this.hasDifferentStorageWithName(dBStorage, (String)object)) {
            object = string + ++n;
        }
        return object;
    }

    private boolean hasDifferentStorageWithName(DBStorage dBStorage, String string) {
        DBStorage dBStorage2 = this.hmpSubStorages.get(string);
        if (dBStorage2 == null) {
            return false;
        }
        return !CommonUtil.equals(dBStorage2.getBeforeQueryColumns(), dBStorage.getBeforeQueryColumns()) || !Arrays.equals(dBStorage2.getQueryColumns(), dBStorage.getQueryColumns()) || !CommonUtil.equals(dBStorage2.getFromClause(), dBStorage.getFromClause()) || !CommonUtil.equals(dBStorage2.getWhereClause(), dBStorage.getWhereClause()) || !CommonUtil.equals(dBStorage2.getAfterWhereClause(), dBStorage.getAfterWhereClause()) || !CommonUtil.equals(dBStorage2.getWritebackTable(), dBStorage.getWritebackTable()) || !Arrays.equals(dBStorage2.getWritebackColumns(), dBStorage.getWritebackColumns()) || dBStorage2.isAutoLinkReference() != dBStorage.isAutoLinkReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAutomaticLinkStorage(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) throws DataSourceException {
        Record record = ProtocolFactory.openRecord("STORAGE", "CREATE_AUTOLINK", new Object[0]);
        try {
            String string;
            Object object;
            int n;
            Object object2;
            String[] stringArray2;
            String[] stringArray3;
            Object object3;
            TranslationMap translationMap = DBAccess.getAutomaticLinkColumnNameTranslation();
            String string2 = storageReferenceDefinition.getReferencedStorage();
            String[] stringArray4 = storageReferenceDefinition.getColumnNames();
            String[] stringArray5 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray6 = ArrayUtil.intersect(stringArray4, stringArray);
            boolean bl = string2.startsWith(AUTOMATICLINKREFERENCE_PREFIX);
            if (bl) {
                string2 = string2.substring(AUTOMATICLINKREFERENCE_PREFIX.length());
            }
            DBStorage dBStorage = new DBStorage();
            dBStorage.setDBAccess(this.dbAccess);
            dBStorage.setWritebackTable(string2);
            dBStorage.setAutoLinkReference(false);
            List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
            if (list.size() > 0) {
                for (StorageReferenceDefinition storageReferenceDefinition2 : list) {
                    object3 = storageReferenceDefinition2.getColumnNames();
                    String[] stringArray7 = storageReferenceDefinition2.getReferencedColumnNames();
                    stringArray3 = storageReferenceDefinition2.getReferencedStorage();
                    stringArray2 = this.getSubStorage((String)stringArray3);
                    object2 = new String[((String[])object3).length];
                    if (stringArray2.getWritebackTable() == null || string2.toLowerCase().equals(stringArray2.getWritebackTable().toLowerCase())) continue;
                    for (n = 0; n < ((String[])object2).length; ++n) {
                        int n2 = ArrayUtil.indexOf(stringArray4, object3[n]);
                        if (n2 < 0) {
                            object = object3[n];
                            int n3 = ((String)object3[n]).indexOf(95);
                            if (n3 >= 0) {
                                string = ((String)object).substring(0, n3);
                                String string3 = null;
                                for (int i = 0; string3 == null && i < stringArray4.length; ++i) {
                                    if (!string.equals(translationMap.translate(stringArray4[i]))) continue;
                                    string3 = translationMap.translate(stringArray5[i]);
                                }
                                if (string3 != null) {
                                    object = string3 + ((String)object).substring(string.length());
                                }
                            }
                            object2[n] = object;
                            stringArray4 = (String[])ArrayUtil.add(stringArray4, object3[n]);
                            stringArray5 = (String[])ArrayUtil.add(stringArray5, object2[n]);
                            continue;
                        }
                        object2[n] = stringArray5[n2];
                        stringArray6 = (String[])ArrayUtil.remove(stringArray6, object3[n]);
                    }
                    dBStorage.createAutomaticLinkReference((String[])object2, (DBStorage)stringArray2, stringArray7);
                }
            }
            dBStorage.openInternal(false);
            if (bl) {
                int n4 = this.dbAccess.getMaxColumnLength();
                int n5 = n4 / 2 + 5;
                if (stringArray6.length > 0) {
                    object3 = translationMap.translate(stringArray6[0]) + "_";
                    if (((String)object3).length() > n5) {
                        object3 = ((String)object3).substring(0, n5 - 1) + '_';
                    }
                } else {
                    int n6;
                    object3 = dBStorage.getWritebackTable();
                    if (object3 == null) {
                        object3 = dBStorage.getFromClause();
                    }
                    if ((n6 = ((String)(object3 = StringUtil.getText((String)object3, StringUtil.TextType.LettersDigitsWhitespace).replace("/n", " ").replace("/r", " ").replace("/t", " "))).indexOf(32)) < 0) {
                        n6 = ((String)object3).length();
                    }
                    object3 = ((String)object3).substring(0, Math.min(4, n6)).toUpperCase() + '_';
                }
                String[] stringArray8 = dBStorage.getMetaData().getRepresentationColumnNames();
                stringArray3 = stringArray4;
                stringArray2 = stringArray5;
                object2 = new ArrayUtil();
                for (n = 0; n < stringArray8.length; ++n) {
                    if (ArrayUtil.contains(stringArray2, stringArray8[n])) continue;
                    String string4 = (String)object3 + stringArray8[n];
                    if (string4.length() > n4) {
                        string4 = string4.substring(0, n4);
                    }
                    if (ArrayUtil.contains(stringArray3, string4)) {
                        object2.add(string4);
                    }
                    stringArray3 = ArrayUtil.add(stringArray3, string4);
                    stringArray2 = ArrayUtil.add(stringArray2, stringArray8[n]);
                }
                if (object2.size() > 0) {
                    stringArray3 = stringArray4;
                    stringArray2 = stringArray5;
                    String[] stringArray9 = ((String)object3).split("_", -1);
                    for (int i = 0; i < stringArray9.length; ++i) {
                        object = stringArray9[i];
                        if (((String)object).length() <= 4) continue;
                        stringArray9[i] = ((String)object).substring(0, 4);
                    }
                    String string5 = StringUtil.concat("_", stringArray9);
                    for (int i = 0; i < stringArray8.length; ++i) {
                        String string6 = stringArray8[i];
                        if (ArrayUtil.contains(stringArray2, string6)) continue;
                        string = (String)object3 + string6;
                        if (string.length() > n4) {
                            string = string.substring(0, n4);
                        }
                        if (object2.contains(string)) {
                            String[] stringArray10 = string6.split("_", -1);
                            int n7 = stringArray10.length > 3 ? 4 : 8;
                            for (int j = 0; j < stringArray10.length - 1; ++j) {
                                String string7 = stringArray10[j];
                                if (string7.length() <= n7) continue;
                                stringArray10[j] = string7.substring(0, n7);
                            }
                            string6 = StringUtil.concat("_", stringArray10);
                        }
                        if ((string = string5 + string6).length() > n4) {
                            string = string.substring(0, n4);
                        }
                        int n8 = 2;
                        while (ArrayUtil.contains(stringArray3, string)) {
                            String string8 = "" + n8;
                            if (string.length() > n4 - string8.length()) {
                                string = string.substring(0, n4 - string8.length());
                            }
                            string = string + string8;
                        }
                        stringArray3 = ArrayUtil.add(stringArray3, string);
                        stringArray2 = ArrayUtil.add(stringArray2, stringArray8[i]);
                    }
                }
                stringArray4 = stringArray3;
                stringArray5 = stringArray2;
            }
            String string9 = this.putSubStorage(dBStorage);
            if (record != null) {
                record.setParameter(string9);
            }
            storageReferenceDefinition.setColumnNames(stringArray4);
            storageReferenceDefinition.setReferencedColumnNames(stringArray5);
            storageReferenceDefinition.setReferencedStorage(string9);
            Object var29_44 = null;
        }
        catch (Throwable throwable) {
            Object var29_45 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected boolean isAutomaticLinkNullable(String[] stringArray, ServerColumnMetaData[] serverColumnMetaDataArray) {
        boolean bl = true;
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[i];
            if (!ArrayUtil.contains(stringArray, serverColumnMetaData.getName()) || !serverColumnMetaData.isWritable()) continue;
            if (serverColumnMetaData.isNullable()) {
                return true;
            }
            bl = false;
        }
        return bl;
    }

    private String getFromClause(String string, ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" m");
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add(serverColumnMetaDataArray[i].getName());
        }
        String[] stringArray = arrayUtil.toArray(new String[arrayUtil.size()]);
        this.subStorageConditions = null;
        int n = this.auSortedAutomaticLinkReferences.size();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable;
            int n2;
            int n3;
            Object object;
            String[] stringArray2;
            int n4;
            stringBuilder.append("\n");
            StorageReferenceDefinition storageReferenceDefinition = this.auSortedAutomaticLinkReferences.get(i);
            String[] stringArray3 = storageReferenceDefinition.getColumnNames();
            String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray5 = arrayUtil.toArray(new String[arrayUtil.size()]);
            String[] stringArray6 = ArrayUtil.removeAll(stringArray3, stringArray5);
            arrayUtil.addAll(stringArray6);
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            String[] stringArray7 = dBStorage.mdServerMetaData.getWritableColumnNames();
            if (this.isAutomaticLinkNullable(stringArray3, serverColumnMetaDataArray) || dBStorage.getRestrictCondition() != null) {
                stringBuilder.append("       LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("       INNER JOIN ");
            }
            boolean bl = dBStorage.getWritebackTable() != null && dBStorage.getRestrictCondition() == null;
            for (n4 = 0; bl && n4 < stringArray6.length; ++n4) {
                bl = ArrayUtil.contains(stringArray7, storageReferenceDefinition.getReferencedColumnName(stringArray6[n4]));
            }
            if (bl) {
                stringBuilder.append(dBStorage.getWritebackTable());
            } else {
                ICondition iCondition = null;
                if (dBStorage.getRestrictCondition() != null) {
                    iCondition = dBStorage.getRestrictCondition().clone();
                }
                stringArray2 = this.dbAccess.getParameterizedSelectStatement(dBStorage.mdServerMetaData, dBStorage.getBeforeQueryColumns(), dBStorage.getQueryColumns(), dBStorage.getFromClause(), iCondition, dBStorage.getWhereClause(), dBStorage.getAfterWhereClause(), null, null, -1, -1);
                stringArray2.setStatement(stringArray2.getStatement().replaceAll("\\s+", " "));
                if (iCondition != null) {
                    if (this.subStorageConditions == null) {
                        this.subStorageConditions = iCondition;
                    } else if (iCondition != null) {
                        this.subStorageConditions = this.subStorageConditions.and(iCondition);
                    }
                    if (dBStorage.subStorageConditions != null) {
                        this.subStorageConditions = this.subStorageConditions.and(dBStorage.subStorageConditions);
                    }
                }
                object = storageReferenceDefinition.getReferencedStorage();
                object = ((String)object).toUpperCase();
                object = ((String)object).replace('.', '_');
                n3 = stringArray2.getStatement().indexOf(63);
                for (n2 = 0; n3 > 0 && n2 < stringArray2.getNames().size(); ++n2) {
                    String string2 = stringArray2.getNames().get(n2);
                    cloneable = stringArray2.getNameToCondition().get(string2);
                    string2 = string2.toUpperCase();
                    if (cloneable != null) {
                        string2 = (String)object + "_" + string2;
                        ((CompareCondition)cloneable).setColumnName(string2);
                    }
                    stringArray2.setStatement(stringArray2.getStatement().substring(0, n3) + ":" + string2 + stringArray2.getStatement().substring(n3 + 1));
                    n3 = stringArray2.getStatement().indexOf(63, n3);
                }
                stringBuilder.append("(");
                stringBuilder.append(stringArray2.getStatement());
                stringBuilder.append(")");
            }
            n4 = i + 1;
            stringBuilder.append(" l");
            stringBuilder.append(n4);
            stringBuilder.append(" ON ");
            stringArray2 = ArrayUtil.intersect(stringArray3, stringArray);
            object = new String[stringArray2.length];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                object[n2] = stringArray4[ArrayUtil.indexOf(stringArray3, stringArray2[n2])];
            }
            String[] stringArray8 = dBStorage.mdServerMetaData.getPrimaryKeyColumnNames();
            if (stringArray8 != null && stringArray8.length > 0 && ArrayUtil.containsAll(object, stringArray8)) {
                object = stringArray8;
                stringArray2 = new String[((Object)object).length];
                for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                    stringArray2[n3] = stringArray3[ArrayUtil.indexOf(stringArray4, object[n3])];
                }
            }
            if (stringArray2.length == 0) {
                throw new DataSourceException("There has to be at least one column of write back table in automatic link reference to \"" + storageReferenceDefinition.getReferencedStorage() + "\"!");
            }
            n3 = 1;
            for (int j = 0; j < stringArray2.length; ++j) {
                cloneable = serverColumnMetaDataArray[ArrayUtil.indexOf(stringArray, stringArray2[j])];
                if (n3 == 0) {
                    stringBuilder.append(" AND ");
                }
                n3 = 0;
                stringBuilder.append("m.");
                stringBuilder.append(((ServerColumnMetaData)cloneable).getColumnName().getQuotedName());
                stringBuilder.append(" = ");
                stringBuilder.append("l");
                stringBuilder.append(n4);
                stringBuilder.append('.');
                try {
                    stringBuilder.append(dBStorage.mdServerMetaData.getServerColumnMetaData((String)object[j]).getColumnName().getQuotedName());
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException(modelException.getMessage());
                }
            }
        }
        return stringBuilder.toString();
    }

    private void generateSubStorageIndex(ServerColumnMetaData[] serverColumnMetaDataArray) {
        this.auSortedAutomaticLinkReferences.clear();
        ArrayUtil<Integer> arrayUtil = new ArrayUtil<Integer>();
        ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil2.add(serverColumnMetaDataArray[i].getName());
        }
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            int n;
            String[] stringArray = arrayUtil2.toArray(new String[arrayUtil2.size()]);
            String[] stringArray2 = storageReferenceDefinition.getColumnNames();
            String[] stringArray3 = ArrayUtil.removeAll(stringArray2, stringArray);
            if (stringArray3.length <= 0) continue;
            int n2 = -1;
            for (n = 0; n < stringArray2.length; ++n) {
                int n3 = arrayUtil2.indexOf(stringArray2[n]);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            for (n = arrayUtil.size(); n > 0 && n2 < (Integer)arrayUtil.get(n - 1); --n) {
            }
            arrayUtil.add(n, n2);
            this.auSortedAutomaticLinkReferences.add(n, storageReferenceDefinition);
            arrayUtil2.addAll(n2 + 1, stringArray3);
        }
    }

    private String[] getQueryColumns(ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add("m." + serverColumnMetaDataArray[i].getColumnName().getQuotedName());
            arrayUtil2.add(serverColumnMetaDataArray[i].getName());
        }
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            int n;
            String[] stringArray = arrayUtil2.toArray(new String[arrayUtil2.size()]);
            String[] stringArray2 = storageReferenceDefinition.getColumnNames();
            String[] stringArray3 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray4 = ArrayUtil.removeAll(stringArray2, stringArray);
            if (stringArray4.length <= 0) continue;
            int n2 = this.auSortedAutomaticLinkReferences.indexOfReference(storageReferenceDefinition) + 1;
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            int n3 = -1;
            for (int i = 0; i < stringArray2.length; ++i) {
                n = arrayUtil2.indexOf(stringArray2[i]);
                if (n <= n3) continue;
                n3 = n;
            }
            String[] stringArray5 = new String[stringArray4.length];
            for (n = 0; n < stringArray4.length; ++n) {
                String string = stringArray3[ArrayUtil.indexOf(stringArray2, stringArray4[n])];
                try {
                    stringArray5[n] = "l" + n2 + "." + dBStorage.mdServerMetaData.getServerColumnMetaData(string).getColumnName().getQuotedName() + " " + stringArray4[n];
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException("Column was not found!", modelException);
                }
            }
            arrayUtil.addAll(n3 + 1, stringArray5);
            arrayUtil2.addAll(n3 + 1, stringArray4);
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    /*
     * WARNING - void declaration
     */
    protected ServerMetaData createMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2, boolean bl, boolean bl2) throws DataSourceException {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        boolean bl3;
        Key key = null;
        List<Key> list = null;
        Map<String, Object> map = null;
        Map<String, Object[]> map2 = null;
        Object[] objectArray = null;
        String[] stringArray3 = null;
        MetaData metaData = this.mdServerMetaData.getMetaData();
        boolean bl4 = metaData.getPrimaryKeyColumnNames() != null;
        boolean bl5 = bl3 = metaData.getRepresentationColumnNames() != null;
        if (string5 != null) {
            serverColumnMetaDataArray = this.dbAccess.getTableForSynonym(string5);
            object6 = this.dbAccess.getTableInfo((String)serverColumnMetaDataArray);
            objectArray = this.dbAccess.getColumnMetaData((String)serverColumnMetaDataArray, null, null, null, null);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i].setWritable(true);
            }
            stringArray3 = BeanUtil.toArray(objectArray, new String[objectArray.length], "name");
            this.sCatalog = ((TableInfo)object6).getCatalog();
            this.sSchema = ((TableInfo)object6).getSchema();
            this.debug("WritebackTable Schema=", this.sSchema, ",Catalog=", this.sCatalog);
            String string6 = ((TableInfo)object6).getTable();
            if (bl) {
                object5 = this.dbAccess.getForeignKeys(this.sCatalog, this.sSchema, string6);
                String string7 = this.dbAccess.getDefaultSchema();
                if (string7 == null && this.sSchema != null && string5.equals(serverColumnMetaDataArray) && !DBAccess.removeQuotes(string5).toUpperCase().startsWith(this.sSchema.toUpperCase())) {
                    string7 = this.sSchema;
                }
                Iterator object42 = object5.iterator();
                while (object42.hasNext()) {
                    object3 = (ForeignKey)object42.next();
                    String string8 = ((ForeignKey)object3).getPKTable().getQuotedName();
                    Object object4 = object2 = ((ForeignKey)object3).getPKSchema() == null ? null : ((ForeignKey)object3).getPKSchema().getQuotedName();
                    if (string7 == null && object2 != null || string7 != null && !string7.equals(object2)) {
                        string8 = (String)object2 + "." + string8;
                    }
                    StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(BeanUtil.toArray(((ForeignKey)object3).getFKColumns(), new String[((ForeignKey)object3).getFKColumns().length], "name"), AUTOMATICLINKREFERENCE_PREFIX + string8, BeanUtil.toArray(((ForeignKey)object3).getPKColumns(), new String[((ForeignKey)object3).getPKColumns().length], "name"));
                    this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray3);
                }
            }
            if (this.isDefaultValue()) {
                map = this.dbAccess.getDefaultValues(this.sCatalog, this.sSchema, string6);
            }
            if (this.isAllowedValues()) {
                map2 = this.dbAccess.getAllowedValues(this.sCatalog, this.sSchema, string6);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (map2 != null && map2.get(((ServerColumnMetaData)objectArray[i]).getName()) != null || (object5 = this.dbAccess.getDefaultAllowedValues(this.sCatalog, this.sSchema, string6, (ServerColumnMetaData)objectArray[i])) == null) continue;
                    if (map2 == null) {
                        map2 = new Hashtable<String, Object[]>();
                    }
                    map2.put(((ServerColumnMetaData)objectArray[i]).getName(), (Object[])object5);
                }
            }
            if (!bl4) {
                key = this.dbAccess.getPrimaryKey(this.sCatalog, this.sSchema, string6);
            }
            if (!bl3) {
                list = this.dbAccess.getUniqueKeys(this.sCatalog, this.sSchema, string6);
            }
            for (StorageReferenceDefinition storageReferenceDefinition : this.auManualLinkReferences) {
                this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray3);
            }
            object5 = this.auAutomaticLinkReferences.iterator();
            while (object5.hasNext()) {
                StorageReferenceDefinition storageReferenceDefinition = (StorageReferenceDefinition)object5.next();
                String j = storageReferenceDefinition.getReferencedStorage();
                if (j.startsWith(SUBSTORAGE_PREFIX)) continue;
                this.createAutomaticLinkStorage(storageReferenceDefinition, stringArray3);
            }
            if (string2 == null) {
                this.generateSubStorageIndex((ServerColumnMetaData[])objectArray);
                object5 = this.getQueryColumns((ServerColumnMetaData[])objectArray);
                if (stringArray == null) {
                    stringArray = object5;
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String i2 = stringArray[i].toLowerCase();
                        if (i2.contains(".") || StringUtil.containsWhitespace(i2)) continue;
                        object3 = null;
                        for (int j = 0; object3 == null && j < ((Object)object5).length; ++j) {
                            object2 = ((String)object5[j]).toLowerCase();
                            int n = ((String)object2).length() - i2.length() - 1;
                            if (!((String)object2).endsWith(i2) || n >= 0 && !Character.isWhitespace(((String)object2).charAt(n)) && ((String)object2).charAt(n) != '.') continue;
                            object3 = object5[j];
                        }
                        if (object3 == null) continue;
                        stringArray[i] = object3;
                    }
                }
                this.setQueryColumns(stringArray);
                string2 = this.getFromClause(string5, (ServerColumnMetaData[])objectArray);
                this.setFromClause(string2);
            }
        }
        if (!(string5 != null || this.hasInsteadOfInsertEventHandler() || this.hasInsteadOfUpdateEventHandler() || this.hasInsteadOfDeleteEventHandler())) {
            metaData.removeFeature(MetaData.Feature.WriteBack);
        }
        serverColumnMetaDataArray = null;
        if (stringArray == null) {
            serverColumnMetaDataArray = this.dbAccess.getColumnMetaData(string2, stringArray, string, string3, string4);
            stringArray = new String[serverColumnMetaDataArray.length];
            for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                stringArray[i] = serverColumnMetaDataArray[i].getColumnName().getQuotedName();
            }
            this.setQueryColumns(stringArray);
        }
        if (this.saAdditionalQueryColumns != null) {
            stringArray = ArrayUtil.addAll(stringArray, this.saAdditionalQueryColumns);
            this.setQueryColumns(stringArray);
        }
        if (serverColumnMetaDataArray == null || this.saAdditionalQueryColumns != null) {
            serverColumnMetaDataArray = this.dbAccess.getColumnMetaData(string2, stringArray, string, string3, string4);
        }
        this.mdServerMetaData.setServerColumnMetaData(serverColumnMetaDataArray);
        object6 = new ArrayUtil();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            int n;
            serverColumnMetaDataArray[i].setCalculated(false);
            if (serverColumnMetaDataArray[i].isAutoIncrement()) {
                ((ArrayUtil)object6).add(serverColumnMetaDataArray[i].getColumnName());
            }
            if (map != null) {
                serverColumnMetaDataArray[i].setDefaultValue(map.get(serverColumnMetaDataArray[i].getName()));
            }
            if (map2 != null && (object5 = (Object[])map2.get(serverColumnMetaDataArray[i].getName())) != null && ((Object[])object5).length > 0) {
                serverColumnMetaDataArray[i].setAllowedValues((Object[])object5);
            }
            if (objectArray == null || (n = ServerMetaData.getServerColumnMetaDataIndex((ServerColumnMetaData[])objectArray, serverColumnMetaDataArray[i].getName())) < 0) continue;
            serverColumnMetaDataArray[i].setDetectedType(((ServerColumnMetaData)objectArray[n]).getDetectedType());
            serverColumnMetaDataArray[i].setSQLTypeName(((ServerColumnMetaData)objectArray[n]).getSQLTypeName());
            if (serverColumnMetaDataArray[i].getAllowedValues() == null && ((ServerColumnMetaData)objectArray[n]).getAllowedValues() != null) {
                serverColumnMetaDataArray[i].setAllowedValues(((ServerColumnMetaData)objectArray[n]).getAllowedValues());
            }
            serverColumnMetaDataArray[i].setNullable(((ServerColumnMetaData)objectArray[n]).isNullable());
            serverColumnMetaDataArray[i].setWritable(true);
        }
        if (!((ArrayUtil)object6).isEmpty()) {
            this.mdServerMetaData.setAutoIncrementColumnNames(((ArrayUtil)object6).toArray(new Name[((ArrayUtil)object6).size()]));
        }
        if (!bl4) {
            if (key != null && key.getColumns() != null && key.getColumns().length > 0) {
                this.mdServerMetaData.setPrimaryKeyColumnNames(key.getColumns());
                this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.PrimaryKeyColumns);
            } else if (list != null && list.size() > 0) {
                this.mdServerMetaData.setPrimaryKeyColumnNames(((Key)list.get(0)).getColumns());
                this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.UniqueKeyColumns);
            } else {
                String[] stringArray4 = ArrayUtil.intersect(this.mdServerMetaData.getColumnNames(), stringArray3);
                object5 = new ArrayUtil();
                for (int i = 0; i < stringArray4.length; ++i) {
                    try {
                        ServerColumnMetaData serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData(stringArray4[i]);
                        if (serverColumnMetaData.getColumnMetaData().getTypeIdentifier() == -2) continue;
                        ((ArrayUtil)object5).add(serverColumnMetaData.getColumnName());
                        continue;
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                if (((ArrayUtil)object5).size() > 0) {
                    this.mdServerMetaData.setPrimaryKeyColumnNames(((ArrayUtil)object5).toArray(new Name[((ArrayUtil)object5).size()]));
                    this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.AllColumns);
                }
            }
        }
        if (!bl3 && list != null && list.size() > 0) {
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            for (int i = 0; i < list.size(); ++i) {
                void var24_57;
                Name[] nameArray = ((Key)list.get(i)).getColumns();
                boolean bl6 = false;
                while (var24_57 < nameArray.length) {
                    if (arrayUtil.indexOf(nameArray[var24_57]) < 0) {
                        arrayUtil.add(nameArray[var24_57]);
                    }
                    ++var24_57;
                }
            }
            if (arrayUtil.size() > 0) {
                Name[] nameArray = new Name[arrayUtil.size()];
                arrayUtil.toArray(nameArray);
                this.mdServerMetaData.setRepresentationColumnNames(nameArray);
            }
        }
        if (string5 != null) {
            Object[] objectArray2;
            object = BeanUtil.toArray(objectArray, new String[objectArray.length], "label");
            HashMap<Object[], Object[]> hashMap = new HashMap<Object[], Object[]>();
            for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                object3 = storageReferenceDefinition.getColumnNames();
                String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
                object2 = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
                try {
                    for (int i = 0; i < ((String[])object3).length; ++i) {
                        ServerColumnMetaData serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData(object3[i]);
                        if (serverColumnMetaData.getLinkReference() != null || serverColumnMetaData.isWritable() || hashMap.put(objectArray2 = ((DBStorage)object2).getMetaData().getColumnMetaData(stringArray4[i]).getLabel(), objectArray2) == null || ArrayUtil.contains(object, objectArray2)) continue;
                        object = (String[])ArrayUtil.add(object, objectArray2);
                    }
                }
                catch (ModelException modelException) {
                }
            }
            for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                int n;
                object3 = storageReferenceDefinition.getColumnNames();
                String[] stringArray5 = storageReferenceDefinition.getReferencedColumnNames();
                object2 = storageReferenceDefinition.getReferencedStorage();
                DBStorage dBStorage = this.getSubStorage((String)object2);
                int n2 = ((String)object2).lastIndexOf(".");
                if (n2 >= 0) {
                    object2 = ((String)object2).substring(n2 + 1);
                }
                object2 = StringUtil.formatInitCap((String)object2) + " ";
                objectArray2 = ArrayUtil.intersect(object3, this.mdServerMetaData.getColumnNames());
                if (!Arrays.equals((Object[])object3, objectArray2)) {
                    String[] stringArray6 = new String[objectArray2.length];
                    for (n = 0; n < stringArray6.length; ++n) {
                        stringArray6[n] = stringArray5[ArrayUtil.indexOf(object3, objectArray2[n])];
                    }
                    object3 = objectArray2;
                    stringArray5 = stringArray6;
                    storageReferenceDefinition.setColumnNames((String[])object3);
                    storageReferenceDefinition.setReferencedColumnNames(stringArray5);
                }
                try {
                    boolean bl7 = this.isAutomaticLinkNullable((String[])object3, (ServerColumnMetaData[])objectArray);
                    for (n = 0; n < ((Object)object3).length; ++n) {
                        ColumnMetaData columnMetaData = this.mdServerMetaData.getMetaData().getColumnMetaData((String)object3[n]);
                        if (columnMetaData.getLinkReference() != null) continue;
                        if (!columnMetaData.isWritable()) {
                            String string9 = dBStorage.getMetaData().getColumnMetaData(stringArray5[n]).getLabel();
                            if (ArrayUtil.contains(object, string9)) {
                                string9 = (String)object2 + string9;
                            }
                            columnMetaData.setLabel(string9);
                            columnMetaData.setNullable(bl7);
                        }
                        columnMetaData.setLinkReference(storageReferenceDefinition);
                    }
                }
                catch (ModelException modelException) {
                    this.debug(Arrays.toString(this.mdServerMetaData.getColumnNames()));
                    this.debug(modelException);
                }
            }
        } else {
            for (StorageReferenceDefinition storageReferenceDefinition : this.auManualLinkReferences) {
                if (!storageReferenceDefinition.getReferencedStorage().startsWith(SUBSTORAGE_PREFIX)) {
                    this.createAutomaticLinkStorage(storageReferenceDefinition, this.mdServerMetaData.getWritableColumnNames());
                }
                this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
            }
        }
        if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() != null) {
            object = this.mdServerMetaData.getRepresentationColumnNames();
            String[] stringArray8 = null;
            for (int i = 0; stringArray8 == null && i < ((String[])object).length; ++i) {
                try {
                    if (this.mdServerMetaData.getMetaData().getColumnMetaData(object[i]).getTypeIdentifier() != 12 && ((String[])object).length != 1) continue;
                    stringArray8 = new String[]{object[i]};
                    continue;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            this.mdServerMetaData.setRepresentationColumnNames(stringArray8);
        }
        if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() == null) {
            void var24_65;
            object = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            boolean bl8 = false;
            while (object == null && var24_65 < serverColumnMetaDataArray.length) {
                if (!ArrayUtil.contains(this.mdServerMetaData.getPrimaryKeyColumnNames(), serverColumnMetaDataArray[var24_65].getName()) && !RowDefinition.isColumnIgnored(serverColumnMetaDataArray[var24_65].getName())) {
                    if (serverColumnMetaDataArray[var24_65].getColumnMetaData().getTypeIdentifier() == 12) {
                        object = serverColumnMetaDataArray[var24_65].getColumnName();
                    }
                    if (serverColumnMetaDataArray[var24_65].getColumnMetaData().getTypeIdentifier() != -2) {
                        arrayUtil.add(serverColumnMetaDataArray[var24_65].getColumnName());
                    }
                }
                if (serverColumnMetaDataArray[var24_65].getColumnMetaData().getTypeIdentifier() != -2) {
                    arrayUtil2.add(serverColumnMetaDataArray[var24_65].getColumnName());
                }
                ++var24_65;
            }
            if (object != null) {
                this.mdServerMetaData.setRepresentationColumnNames(new Name[]{object});
            } else if (arrayUtil.size() > 0) {
                this.mdServerMetaData.setRepresentationColumnNames(arrayUtil.toArray(new Name[arrayUtil.size()]));
            } else {
                this.mdServerMetaData.setRepresentationColumnNames(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
            }
        }
        return this.mdServerMetaData;
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    @Override
    public void close() {
        this.bIsOpen = false;
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.auAutomaticLinkReferences.clear();
    }

    public void setDBAccess(IDBAccess iDBAccess) {
        this.dbAccess = (DBAccess)iDBAccess;
    }

    public IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    private String getFromClauseIntern() {
        if (this.sFromClause == null) {
            return this.sWritebackTable;
        }
        return this.sFromClause;
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String[] getAdditionalQueryColumns() {
        return this.saAdditionalQueryColumns;
    }

    public void setAdditionalQueryColumns(String[] stringArray) {
        this.saAdditionalQueryColumns = stringArray;
    }

    public String getBeforeQueryColumns() {
        return this.sBeforeQueryColumns;
    }

    public void setBeforeQueryColumns(String string) {
        this.sBeforeQueryColumns = string;
    }

    public String getWhereClause() {
        return this.sWhereClause;
    }

    public void setWhereClause(String string) {
        this.sWhereClause = string;
    }

    public String getAfterWhereClause() {
        return this.sAfterWhereClause;
    }

    public void setAfterWhereClause(String string) {
        this.sAfterWhereClause = string;
    }

    public String getOrderByClause() {
        return this.sOrderByClause;
    }

    public void setOrderByClause(String string) {
        this.sOrderByClause = string;
    }

    public String[] getWritebackColumns() {
        return this.saWritebackColumns;
    }

    public void setWritebackColumns(String[] stringArray) {
        this.saWritebackColumns = stringArray;
    }

    public String getWritebackTable() {
        return this.sWritebackTable;
    }

    public void setWritebackTable(String string) {
        this.sWritebackTable = string;
    }

    public SortDefinition getDefaultSort() {
        return this.sdDefaultSort;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sdDefaultSort = sortDefinition;
    }

    public ICondition getRestrictCondition() {
        return this.cRestrictCondition;
    }

    public void setRestrictCondition(ICondition iCondition) {
        this.cRestrictCondition = iCondition;
    }

    public void setAutoLinkReference(boolean bl) {
        this.bAutoLinkReference = bl;
    }

    public boolean isAutoLinkReference() {
        if (this.bAutoLinkReference == null) {
            return bDefaultAutoLinkReference;
        }
        return this.bAutoLinkReference;
    }

    public static void setDefaultAutoLinkReference(boolean bl) {
        bDefaultAutoLinkReference = bl;
    }

    public static boolean isDefaultAutoLinkReference() {
        return bDefaultAutoLinkReference;
    }

    public void setDefaultValue(boolean bl) {
        this.bDefaultValue = bl;
    }

    public boolean isDefaultValue() {
        if (this.bDefaultValue == null) {
            return bDefaultDefaultValue;
        }
        return this.bDefaultValue;
    }

    public static void setDefaultDefaultValue(boolean bl) {
        bDefaultDefaultValue = bl;
    }

    public static boolean isDefaultDefaultValue() {
        return bDefaultDefaultValue;
    }

    public void setAllowedValues(boolean bl) {
        this.bAllowedValues = bl;
    }

    public boolean isAllowedValues() {
        if (this.bAllowedValues == null) {
            return bDefaultAllowedValues;
        }
        return this.bAllowedValues;
    }

    public static void setDefaultAllowedValues(boolean bl) {
        bDefaultAllowedValues = bl;
    }

    public static boolean isDefaultAllowedValues() {
        return bDefaultAllowedValues;
    }

    public boolean isLazyFetchEnabled() {
        return this.bLazyFetchEnabled;
    }

    public void setLazyFetchEnabled(boolean bl) {
        this.bLazyFetchEnabled = bl;
    }

    public boolean isLockOnRefetch() {
        return this.bLockOnRefetch;
    }

    public void setLockOnRefetch(boolean bl) {
        this.bLockOnRefetch = bl;
    }

    protected String getWritebackTableCatalog() {
        return this.sCatalog;
    }

    protected String getWritebackTableSchema() {
        return this.sSchema;
    }

    protected Object[] refetchRow(Object[] objectArray, boolean bl) throws DataSourceException {
        List<Object[]> list;
        if (objectArray == null) {
            return null;
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        ICondition iCondition = Filter.createEqualsFilter(this.mdServerMetaData.getPrimaryKeyColumnNames(), objectArray, this.mdServerMetaData.getMetaData().getColumnMetaData());
        if (bl && !this.dbAccess.isAutoCommit()) {
            this.dbAccess.lockRow(this.getWritebackTable(), this.mdServerMetaData, iCondition);
        }
        if (this.subStorageConditions != null) {
            iCondition = new And(this.subStorageConditions, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 2, this.bLazyFetchEnabled)) != null && list.size() == 2 && list.get(1) == null) {
            Object[] objectArray2 = list.get(0);
            for (int i = 0; i < objectArray2.length; ++i) {
                if (i >= objectArray.length || this.mdServerMetaData.getServerColumnMetaData(i) != null) continue;
                objectArray2[i] = objectArray[i];
            }
            return objectArray2;
        }
        return null;
    }

    @Accessible
    public Map<String, DBStorage> getSubStorages() {
        return this.hmpSubStorages;
    }

    private ICondition createFilter(ICondition iCondition) {
        And and = null;
        if (this.cRestrictCondition != null) {
            and = new And();
            and.and(this.cRestrictCondition);
        }
        if (this.subStorageConditions != null) {
            if (and == null) {
                and = new And();
            }
            and.and(this.subStorageConditions);
        }
        if (iCondition != null) {
            this.checkCondition(iCondition);
            if (and == null) {
                and = new And(iCondition);
            } else {
                and.and(new And(iCondition));
            }
        }
        return and;
    }

    private void checkSort(SortDefinition sortDefinition) {
        for (String string : sortDefinition.getColumns()) {
            this.checkChars(string);
        }
    }

    private void checkCondition(ICondition iCondition) {
        if (iCondition instanceof CompareCondition) {
            this.checkChars(((CompareCondition)iCondition).getColumnName());
        } else if (iCondition instanceof OperatorCondition) {
            for (ICondition iCondition2 : ((OperatorCondition)iCondition).getConditions()) {
                this.checkCondition(iCondition2);
            }
        }
    }

    private void checkChars(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isLetterOrDigit(c) || "._$#".indexOf(c) >= 0) continue;
            throw new IllegalArgumentException("Invalid characters detected.");
        }
    }
}

