/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<float[]> {
    private static final int TYPE_FLOAT_ARRAY_MIN = 56;
    private static final int TYPE_FLOAT_ARRAY_MAX = 58;

    @Override
    public Class<float[]> getTypeClass() {
        return float[].class;
    }

    @Override
    public int getMinValue() {
        return 56;
    }

    @Override
    public int getMaxValue() {
        return 58;
    }

    @Override
    public float[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 56, 58);
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        return fArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, float[] fArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, fArray.length, 56, 58);
        for (int i = 0; i < fArray.length; ++i) {
            dataOutputStream.writeFloat(fArray[i]);
        }
    }
}

